#include <Image.h>
#include <GraphicUnit.h>

Box::Box( IMAGE *& img, int x1, int y1, int x2, int y2) {
  setPoints(x1,y1,x2,y2);
  img->addObject ( this );
  imgDst = img;
}

Box::Box( IMAGE *& img, int x1, int y1, int x2, int y2,  char * c ) {
  setPoints(x1,y1,x2,y2);
  setPenColor(c);
  img->addObject ( this );
  imgDst = img;
}

Box::Box( IMAGE *& img, int x1, int y1, int x2, int y2,  char * c, int s) {
  setPoints(x1,y1,x2,y2);
  setPenColor(c);
  setSize(s);
  img->addObject ( this );
  imgDst = img;
}

Box::Box( IMAGE *& img, int x1, int y1, int x2, int y2, char * c, int s, char * c2 ) {
  setPoints(x1,y1,x2,y2);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  img->addObject ( this );
  imgDst = img;
}

Box::Box( IMAGE *& img, int x1, int y1, int x2, int y2, char * c, int s, char * c2, int d) {
  setPoints(x1,y1,x2,y2);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);
  img->addObject ( this );
  imgDst = img;
}

Box::Box( IMAGE *& img, 
		    int x1, int y1, int x2, int y2,
		    char * c, 
		    int s, 
		    char * c2, int d, 
		    char * u) {
  setPoints(x1,y1,x2,y2);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);
  setURL(u);
  img->addObject ( this );
  imgDst = img;
}

void Box::setPoints(int x1, int y1, int x2, int y2) {
  
  nbPoints = 4;
  
  addPoint(x1,y1);
  addPoint(x2,y1);
  addPoint(x2,y2);
  addPoint(x1,y2);
  //  addPoint(x1,y1);
}

#ifdef DEBUG
void Box::Debug ( void ) {
  cout << "Box " << endl;
  Point * tmp = points;
  
  while ( tmp != NULL ) {
    cout << "(" << tmp->X << "," << tmp->Y << ")" <<endl;
    tmp = tmp->next;
  }
  printAttribut();
}
#endif
