#include <Image.h>
#include <math.h>
#include <gd.h>


Circle::Circle( void ) { }


Circle::Circle( IMAGE *& img, int x, int y, int r ) {
  addPoint(x,y);
  rayon = r;
  setSize(0);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
}

Circle::Circle( IMAGE *& img, int x, int y, int r, char * c ) {
  addPoint(x,y);
  rayon = r;
  setPenColor(c);
  setSize(0);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
}

Circle::Circle( IMAGE *& img, int x, int y, int r, char * c, int s) {
  addPoint(x,y);
  rayon = r;
  setPenColor(c);
  setSize(s);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
}

Circle::Circle( IMAGE *& img, int x, int y, int r, char * c, int s, char * c2) {
  addPoint(x,y);
  rayon = r;
  setPenColor(c);
  setFillColor(c2);
  setSize(s);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
}

Circle::Circle( IMAGE *& img, 
	    int x, 
	    int y, 
	    int r, 
	    char * c, 
	    int s, 
	    char * c2,
		int d ) {
  addPoint(x,y);
  rayon = r;
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
}
Circle::Circle( IMAGE *& img, 
	    int x, 
	    int y, 
	    int r, 
	    char * c, 
	    int s, 
	    char * c2,
		int d,
		char * u) {
  addPoint(x,y);
  rayon = r;
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);
  setURL(u);

  ArcBegin = 0;
  ArcEnd   = 360;

  MaxX = points->X + r + size;
  MaxY = points->Y + r + size;
  MinX = points->X - r - size;
  MinY = points->Y - r - size;

  img->addObject ( this );
  imgDst = img;
  
}


#ifdef DEBUG
void Circle::Debug ( void ) {
  cout << "Circle " << endl;
  cout << "From " << points->X << "," << points->Y << endl;
  cout << "Rayon " << rayon << endl;
  printAttribut();
}
#endif

void Circle::Gif( gdImagePtr imOut ) {
  if ( filled ) {
    int DecX = 10;
    int DecY = 10;
    
    gdImagePtr buff = gdImageCreate(MaxX-MinX+DecX, MaxY-MinY + DecY );
    
    Color * col = imgDst->getColor(fillcolor);

    int bgd = gdImageColorAllocate(buff, col->Red, col->Green, col->Blue );
    col = imgDst->getColor(pencolor);
    int fgd = gdImageColorAllocate(buff, col->Red, col->Green, col->Blue );
    
    int trans = gdImageColorAllocate(buff, 255, 255, 255);

    gdImageColorTransparent(buff, trans );

    int Xcen = points->X;
    int Ycen = points->Y;
    
    int Abegin = int ( (360 - ArcBegin) * 2 * 3.1416/360 );
    int Aend   = int ( (360 - ArcEnd  ) * 2 * 3.1416/360 );

    double X = Xcen + ( rayon * cos(Abegin) );
    double Y = Ycen + ( rayon * cos(Abegin) );
    double X1 = Xcen + ( rayon * cos(Aend) );
    double Y1 = Ycen + ( rayon * cos(Aend) );

    gdImageLine(buff, (int)X,(int)Y, (int)X1, (int)Y1, fgd );

    gdImageArc( buff, Xcen - MinX, Ycen - MinY, rayon * 2, rayon * 2,
		360 - ArcEnd, 360 - ArcBegin, fgd);

    gdImageFill(buff, MaxX-MinX+DecX-1,
		MaxY-MinY+DecY-1, trans);
    gdImageLine(buff, (int)X, (int)Y, (int)X1, (int)Y1, bgd);
    gdImageCopyResized(imOut, buff, MinX, MinY, 0, 0, MaxX-MinX,
		       MaxY - MinY, MaxX - MinX, MaxY -MinY );
    
  }
  else {
    GifDash(imOut, imgDst->getColor(pencolor));
    gdImageArc(imOut, points->X, points->Y, rayon * 2, rayon * 2, 360 - ArcEnd, 
	       360 - ArcBegin, gdStyledBrushed );

  }


  //  gdImageCircle(imOut, points->points->X, points->points->Y, 
  //	      points->next->points->X, points->next->points->Y, gdStyledBrushed);
}
