//#include <GraphicUnit.h>
#include <Image.h>

extern int DefaultSize;
extern char * DefaultPenColor;
extern bool DefaultFilled;

/** Constructeur */

GraphicUnit::GraphicUnit( void ) {
  MaxX = MaxY = dash = 0;
  MinX = MinY = 10000;
  next = NULL;
  points = NULL;
  size = DefaultSize;
  filled = false;
  pencolor = fillcolor = DefaultPenColor;
}

GraphicUnit::~GraphicUnit( void ) {
//  while (p1->next != NULL) 
//    { p1 = points->next; delete(points); points = p1; }
Point * pointtmp;
pointtmp = p1 = points ;
 while (p1 != NULL){
   p1 = p1->next;
   delete pointtmp;
   pointtmp = p1;
 } /* fin while */
}

void GraphicUnit::addPoint( int x, int y ) {
  if ( points == NULL ) {
    p1 = points = new Point(x,y);
  }
  else {
    p1->next = new Point(x,y);
    p1 = p1->next;
  }

  if ( x > MaxX ) { MaxX = x+size ; }
  if ( y > MaxY ) { MaxY = y+size ; }
  if ( x < MinX ) { MinX = x; }
  if ( y < MinY ) { MinY = y; }

}

// Initialise la taille de l'object
void GraphicUnit::setSize( int s ) { size = s==0? DefaultSize: s; }

// initialisation du Dash
void GraphicUnit::setDash( int d ) { if ( d != 0) dash = d; }

// initialisation de l'URL
void GraphicUnit::setURL( char * u ) { if ( u != NULL ) url = u; }

// initialisation de la couleur de fond
void GraphicUnit::setFillColor( char * c ) {
  if ( c != NULL ) {
    filled = true;
    fillcolor = c;
  }
  else {
    filled = DefaultFilled;
  }
}
 
// initialisation de la couleur du crayon
void GraphicUnit::setPenColor( char * c ) {
  pencolor = c == NULL ? DefaultPenColor : c ;
}


void GraphicUnit::PostScriptPenColor ( ) {
}

void GraphicUnit::PostScriptFillColor () {
}

void GraphicUnit::GifDash( gdImagePtr imOut, Color * c) {
  gdImagePtr buff = gdImageCreate(size, 1);
  gdImageColorAllocate(buff, c->Red, c->Green, c->Blue );
  
  gdImageSetBrush(imOut, buff );
  
  if ( dash !=0 ) {
    //    int styleDot[dash];
    int *styleDot;
    styleDot= new int[dash];
    
    int i=0;
    for (; i < (dash/2); i++ ) { styleDot[i] = 1; }
    for (; i < dash; i++ ) { styleDot[i] = 0; }
    gdImageSetStyle(imOut, styleDot, dash);
    delete[] styleDot;
  }
  else {
    int st[1] = { 1 };
    gdImageSetStyle(imOut,st,1);
  }
  
}

void GraphicUnit::printAttribut( void ) {
  cout << "--------------" << endl;
  cout << "MaxX = "<< MaxX << " MaxY = "<< MaxY << endl;
  cout << "MinX = "<< MinX << " MinY = "<< MinY << endl;
  cout << "Taille = "<< size << endl;
  if ( filled ) { 
    cout << "Filled = true" << endl;
    if ( fillcolor != NULL ) {
      cout << "Filled Color =" << fillcolor << endl;
    }
  }
  if ( dash != 0 ) {
    cout << "DashSize = " << dash << endl;
  }

  cout << "Couleur = "<< pencolor << endl;
  cout << "--------------" << endl;
}

#ifdef DEBUG
void GraphicUnit::Debug ( void ) {
  cout << "\tGraphicUnit" << endl;
  
}
#endif

void GraphicUnit::Gif( gdImagePtr imOut ) { }
