#include <Image.h>
#include <Line.h>
#include <PointDraw.h>
#include <gd.h>
 
#include <stdio.h>
#include <stdlib.h>

/** Constructeur */

int DefaultSize = 1;

char * DefaultPenColor = "Black";
bool DefaultFilled = false;

IMAGE::IMAGE( void ) {
  nbobj = MaxX = MaxY  = 0;
  objects = NULL;

  Color * tmp;
  tmp = colors = new Color( "Black", -1, 0, 0, 0 ) ;
  tmp->next = new Color( "Red", 1, 255, 0  , 0);
  tmp = tmp->next;
  tmp->next = new Color( "Blue", 2, 0  , 0  , 255);
  tmp = tmp->next;
  tmp->next = new Color( "Green",3, 0,255,0);
  tmp = tmp->next;
  tmp->next = new Color( "Cyan", 4, 0,255,255);
  tmp = tmp->next;
  tmp->next = new Color( "Magenta", 5, 255,0,255);
  tmp = tmp->next;
  tmp->next = new Color( "Yellow", 6, 255,255,0);
  tmp = tmp->next;
  tmp->next = new Color( "White", 7,255,255,255);
  tmp = tmp->next;
  tmp->next = new Color( "Blue4", 8,0,0,137);
  tmp = tmp->next;
  tmp->next = new Color( "Blue3", 9,0,0,204);
  tmp = tmp->next;
  tmp->next = new Color( "Blue2", 10,0,0,240);
  tmp = tmp->next;
  tmp->next = new Color( "LightBlue", 11, 173,214,230);
  tmp = tmp->next;
  tmp->next = new Color( "Green4", 12, 0,137,0);
  tmp = tmp->next;
  tmp->next = new Color( "Green3", 13,0,204,0);
  tmp = tmp->next;
  tmp->next = new Color( "Green2", 14,0,240,0);
  tmp = tmp->next;
  //  tmp->next = new Color( "Cyan4", 15,0,137,137);
  tmp->next = new Color( "DarkSlateGrey", 15,47,79,79);
  tmp = tmp->next;
  //  tmp->next = new Color( "Cyan3", 16,0,204,204);
  tmp->next = new Color( "DimGrey", 16, 105, 105, 105);
  tmp = tmp->next;
  //  tmp->next = new Color( "Cyan2", 17,0,240,240);
  tmp->next = new Color( "SlateGrey", 17,112, 128,144);
  tmp = tmp->next;
  //  tmp->next = new Color( "Red4", 18,137,0,0);
  tmp->next = new Color( "LightSlateGrey", 18, 119, 136, 153);
  tmp = tmp->next;
  //  tmp->next = new Color( "Red3", 19,204,0,0);
  tmp->next = new Color( "Grey", 19, 192, 192, 192);
  tmp = tmp->next;
  //  tmp->next = new Color( "Red2", 20,240,0,0);
tmp->next = new Color( "LightGrey", 20, 211, 211, 211);
  tmp = tmp->next;
  tmp->next = new Color( "Magenta4", 21,137,0,137);
  tmp = tmp->next;
  tmp->next = new Color( "Magenta3", 22,204,0,204);
  tmp = tmp->next;
  tmp->next = new Color( "Magenta2", 23,240,0,240);
  tmp = tmp->next;
  tmp->next = new Color( "Brown4", 24,137,33,33);
  tmp = tmp->next;
  tmp->next = new Color( "Brown3", 25,204,51,51);
  tmp = tmp->next;
  tmp->next = new Color( "Brown2", 26,240,58,58);
  tmp = tmp->next;
  tmp->next = new Color( "Pink4",  27,137,96,107);
  tmp = tmp->next;
  tmp->next = new Color( "Pink3", 28,204,142,155);
  tmp = tmp->next;
  tmp->next = new Color( "Pink2", 29,240,168,183);
  tmp = tmp->next;
  tmp->next = new Color( "Pink", 30,255,191,201);
  tmp = tmp->next;
  tmp->next = new Color( "Gold", 31,255,214,0);
  tmp = tmp->next;


  colorIndex = 32;  
#ifdef DEBUG
  cout << "Cration de l'Image" << endl;
#endif

}

IMAGE::~IMAGE( void ) {
  if ( objects != NULL ) {
    GraphicUnit *monobj; 
    for ( int i = 0 ; i < nbobj ; i ++ ) { 
#ifdef DEBUG
      cout << "Liberation du GraphicUnit N" << i << "\r";
#endif
      monobj = objects->next;
      delete( objects );
      objects = monobj;
    }
  }

  /* Liberation des couleurs */
  Color * colortmp;
  colortmp = colors ;
  while (colors != NULL){
    colors = colors->next ;
    delete colortmp;
    colortmp = colors;
  } /* fin while */

#ifdef DEBUG
  cout << "Libration de l'Image" << endl;
#endif
}

void IMAGE::addObject( GraphicUnit * unit ) {
  if ( objects == NULL )  
    { 
      obj = objects = unit; 
    }
  else 
    {
      obj->next = unit;
      obj = unit;
    }
  nbobj ++ ;

#ifdef DEBUG
  cout << "Ajout d'un Element Graphic " << endl;
#endif

  if ( unit->MaxX > MaxX ) MaxX = unit->MaxX;
  if ( unit->MaxY > MaxY ) MaxY = unit->MaxY;

}

#ifdef DEBUG
void IMAGE::Debug ( void ) {
  cout << "\n---------------" << endl;
  cout << "Taille de l'image " << MaxX <<","<< MaxY << endl;
  cout << "Liste de Objects de l'image"<< endl;
  cout << "Nombre d'objects de l'image : " << nbobj << endl;
  
  obj = objects;
  while ( obj != NULL ) {
    obj->Debug();
    obj = obj->next;
  }
}
#endif


void IMAGE::Gif( char * filename ) {
  
  int nbobjmax = 100000 ;  // nombre d'objets maximum a dessiner
  FILE *out;
  gdImagePtr imOut;
  out = fopen(filename, "wb");
  //  out = tmpfile();
  imOut = gdImageCreate(MaxX,MaxY);
  int white = gdImageColorAllocate(imOut, 255, 255, 255);
  gdImageColorTransparent(imOut, white );
  gdImageInterlace(imOut,1);

  // Allocation des couleurs...
  Color * tmp = colors;
  while ( tmp != NULL ) {
    tmp->gifColor = 
      gdImageColorAllocate(imOut, tmp->Red, tmp->Green, tmp->Blue);
    tmp = tmp->next;
  }

  // Appel de Gif pour tous les objets...
  //cout << "nb objets = " << nbobj << endl;
  if (nbobj > nbobjmax)
    {
      char choix ;
      cout << "Warning !" << endl 
	   << "La cration de l'image ncessite une place mmoire importante"
	   <<  "(de l'ordre de " << nbobj*5/1000 
	   << " Mo. Voir le fichier ReadMe)." << endl
	   << "Crer l'image ? (y ou n)" ;
      cin >> choix ;
      while (choix != 'y' && choix != 'n')
	{
	  cout << "Erreur de frappe." << endl ;
	  cout <<  "Crer l'image ? (y ou n)" ;
	  cin >> choix ;
	} /* fin while */
      if (choix == 'n')
	exit(1) ;
      else 
	cout << "*** Cration de l'image ***" << endl ;
    } /* fin if */

  GraphicUnit * unit = objects;
  GraphicUnit * tmpunit = objects;
  while ( unit != NULL ) {
    unit->Gif( imOut);
    unit = unit->next;
    delete tmpunit ;
    tmpunit = unit ;
  }
  
  gdImageGif(imOut, out);
  fclose(out);
  gdImageDestroy(imOut);
}

int IMAGE::gifColor( char * c ) {
  Color * tmp = colors;
  
  while( strcmp( tmp->Name, c ) ) {
    tmp = tmp->next;
    if (tmp==NULL) return -1;
  }
  return tmp->gifColor;
}

gdFont * IMAGE::GifTextSize(int s) {
  switch(s) { 
  case 12 : return gdFontLarge; 
	      break;
	    case 10 : return gdFontSmall;
	      break;
	    case 9 : return gdFontTiny;
	      break;
	    }
  return NULL;

}
int IMAGE::GifTextWidth(int s) {
  switch(s) { 
  case 12 : return 8; 
	      break;
	    case 10 : return 6;
	      break;
	    case 9 : return 5;
	      break;
	    }
  return -1;
}
int IMAGE::GifTextHeight(int s) {
  switch(s) { 
  case 12 : return 16; 
	    break;
	  case 10 : return 12;
	    break;
	  case 9 : return 8;
	      break;
	    }
  return -1;
}


 Color * IMAGE::getColor( char * c) {
  Color * tmp = colors;
  
  while( strcmp( tmp->Name, c ) ) {
    tmp = tmp->next;
    if (tmp==NULL) return NULL;
  }
  return tmp;
}

int IMAGE::getTextWidth( char * t, int s) {
  return ( strlen(t) * GifTextWidth(s) );
}
int IMAGE::getTextHeight( char * t, int s) {
  return ( strlen(t) * GifTextHeight(s) );
}
  



