#ifndef IMAGE_H
#define IMAGE_H

//#define DEBUG 


#include <stdlib.h>
#include <iostream.h> 
#include <fstream.h>
#include <string.h>

extern "C" {
  #include <gd.h>
#include "gdfontg.h"
#include "gdfontl.h"
#include "gdfontmb.h"
#include "gdfonts.h"
#include "gdfontt.h"
}

#ifndef GRAPHICUNIT_H
#include <GraphicUnit.h>
#endif
#include <Color.h>



class IMAGE {
 private: int nbobj;
          int MaxX;
	  int MaxY;
	  GraphicUnit * objects;
	  GraphicUnit * obj;
	  Color * colors;
	  int colorIndex;

 public:
	  // 
	  IMAGE  ( void );
	  ~IMAGE ( void );
	  //
	  void addObject( GraphicUnit * unit );
	  //
	  void Gif( char * f );

	  int gifColor( char * c );
	   Color* getColor( char * c );

   // TEXT
     gdFont * GifTextSize(int);
     int GifTextWidth(int);
     int GifTextHeight(int);
     int getTextWidth(char *, int );
     int getTextHeight(char *, int );
	  
#ifdef DEBUG
	  void Debug( void );
#endif	  
};

#include <Point.h>
#include <Line.h>
#include <PointDraw.h>
#include <PolyLine.h>
#include <Box.h>
#include <Circle.h>
#include <Arc.h>
#include <Text.h>
#include <UText.h>

#endif  
