#include <Image.h>
#include <GraphicUnit.h>


Line::Line( IMAGE *& img, int x1, int y1, int x2, int y2 ) {
  addPoint(x1,y1);
  addPoint(x2,y2);
  img->addObject ( this );
  imgDst = img;
}

Line::Line( IMAGE *& img, int x1, int y1, int x2, int y2, char * c ) {
  addPoint(x1,y1);
  addPoint(x2,y2);
  setPenColor(c);
  img->addObject ( this );
  imgDst = img;
}


Line::Line( IMAGE *& img, int x1, int y1, int x2, int y2 , char * c, int s) {
  addPoint(x1,y1);
  addPoint(x2,y2);
  setPenColor(c);
  setSize(s);
  img->addObject ( (Line *) this );
  imgDst = img;
}

Line::Line( IMAGE *& img, int x1, int y1, int x2, int y2 , char * c, int s, int d) {
  addPoint(x1,y1);
  addPoint(x2,y2);
  setPenColor(c);
  setSize(s);
  setDash(d);
  img->addObject ( this );
  imgDst = img;
}

Line::Line( IMAGE *& img, 
	    int x1, 
	    int y1, 
	    int x2, 
	    int y2 , 
	    char * c, 
	    int s, 
	    int d, 
	    char * u) {
  addPoint(x1,y1);
  addPoint(x2,y2);
  setPenColor(c);
  setSize(s);
  setDash(d);
  setURL(u);
  img->addObject ( this );
  imgDst = img;
}

#ifdef DEBUG
void Line::Debug ( void ) {
  cout << "Line " << endl;
  cout << "From " << points->X << "," << points->Y << endl;
  cout << "To   " << points->next->X << "," << points->next->Y << endl;
  printAttribut();
}
#endif

void Line::Gif( gdImagePtr imOut ) {

  GifDash(imOut, imgDst->getColor(pencolor));

  gdImageLine(imOut, points->X, points->Y, 
	      points->next->X, points->next->Y, gdStyledBrushed);
}
