#include <Image.h>
#include <GraphicUnit.h>
#include <gd.h>

PolyLine::PolyLine( void ) { }

PolyLine::PolyLine( IMAGE *& img, int * Table) {
  setPoints(Table);
  img->addObject ( this );
  imgDst = img;
}

PolyLine::PolyLine( IMAGE *& img, int * Table,  char * c ) {
  setPoints(Table);
  setPenColor(c);
  img->addObject ( this );
  imgDst = img;
}

PolyLine::PolyLine( IMAGE *& img, int * Table,  char * c, int s) {
  setPoints(Table);
  setPenColor(c);
  setSize(s);
  img->addObject ( (PolyLine *) this );
  imgDst = img;
}

PolyLine::PolyLine( IMAGE *& img, int * Table, char * c, int s, char * c2 ) {
  setPoints(Table);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  img->addObject ( this );
  imgDst = img;
}

PolyLine::PolyLine( IMAGE *& img, int * Table, char * c, int s, char * c2, int d) {
  setPoints(Table);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);
  img->addObject ( this );
  imgDst = img;
}

PolyLine::PolyLine( IMAGE *& img, 
		    int * Table,
		    char * c, 
		    int s, 
		    char * c2, int d, 
		    char * u) {
  setPoints(Table);
  setPenColor(c);
  setFillColor(c2);
  setSize(s);
  setDash(d);
  setURL(u);
  img->addObject ( this );
  imgDst = img;
}

void PolyLine::setPoints(int * Table) {
  short i=0;
  
  nbPoints = 0;
  
  while ( Table[i] != -1 ) {
    nbPoints ++;
    addPoint(Table[i], Table[i+1]);
    i+=2;
  }
    
}

#ifdef DEBUG
void PolyLine::Debug ( void ) {
  cout << "PolyLine " << endl;
  Point * tmp = points;
  
  while ( tmp != NULL ) {
    cout << "(" << tmp->X << "," << tmp->Y << ")" <<endl;
    tmp = tmp->next;
  }
  printAttribut();
}
#endif


void PolyLine::Gif( gdImagePtr imOut ) {

  Point * tmp = points;
  gdPoint *p;


  int i=0;

  //  gdPoint p[nbPoints+1];
  
  p = new gdPoint[nbPoints+1];

  while ( tmp != NULL ) {
    if ( filled ) {
      p[i].x = tmp->X - MinX + 5;
      p[i].y = tmp->Y - MinY + 5;
    }
    else {
      p[i].x = tmp->X;
      p[i].y = tmp->Y;
    }
    i++;
    tmp = tmp->next;
  }

  if ( filled ) {
    p[i].x = points->X - MinX + 5;
    p[i].y = points->Y - MinY + 5;
  }
  else {
    p[i].x = points->X;
    p[i].y = points->Y;
  }


  if ( filled ) {
    int DecX = 20; 
    int DecY = 20;
    
    gdImagePtr buff = gdImageCreate(MaxX-MinX+DecX,
				    MaxY-MinY+DecY);
    int pcolor = 0;
    Color * col = imgDst->getColor(fillcolor);

    if ( !strcmp(fillcolor, pencolor) ) {
      pcolor=1;
    }
    gdImageColorAllocate(buff, col->Red, col->Green, col->Blue + pcolor );
    col = imgDst->getColor(pencolor);
    int fgd = gdImageColorAllocate(buff, col->Red, col->Green, col->Blue);
    int trans = gdImageColorAllocate(buff, 255, 255, 255 );

    gdImageColorTransparent(buff, trans);
    gdImagePolygon(buff, p, nbPoints+1, fgd );
    gdImageFill(buff, MaxX - MinX+DecX-1,
		      MaxY-MinY+DecY-1, trans);
    gdImageCopyResized(imOut, buff, MinX, MinY, 5, 5,
		       MaxX-MinX, MaxY-MinY, MaxX-MinX, MaxY-MinY);
  }
  else {
    GifDash(imOut, imgDst->getColor(pencolor));
    gdImagePolygon(imOut, p, nbPoints+1, gdStyledBrushed);
  }
  delete[] p;
}
