#include <CDS.h>
#include <Image.h>
#include <Box.h>



CDS::CDS( char * n, int st, int sp, int se, int fonc ) : Feature (n, st, sp, se ) {
  strcpy(type,"Cds");
  LGFleche  = 5;
  HTFleche  = 2;

  if ( sens == 1 ) strcpy(color,"Magenta3"), strcpy(fillColor,"Magenta3");
  else strcpy(color,"Magenta3"), strcpy(fillColor,"Magenta3");
  fonction=fonc;
//  Jump = 1;
}
CDS::CDS( char * n, int *st, int *sp, int ni, int se, int fonc ) 
  : Feature (n, st, sp, ni, se ) {
  strcpy(type,"Cds");
  LGFleche  = 5;
  HTFleche  = 2;

  if ( sens == 1 ) strcpy(color,"Magenta3"), strcpy(fillColor,"Magenta3");
  else strcpy(color,"Magenta3"), strcpy(fillColor,"Magenta3");
  fonction=fonc;
//  Jump = 1;
}

CDS::CDS( char * n, int st, int sp, int se, int fonc , char *couleur) : Feature (n, st, sp, se ) {
  strcpy(type,"Cds");
  LGFleche  = 5;
  HTFleche  = 2;

  if ( sens == 1 ) strcpy(color, couleur), strcpy(fillColor, couleur);
  else strcpy(color, couleur), strcpy(fillColor,couleur);
  fonction=fonc;
//  Jump = 1;
}
CDS::CDS( char * n, int *st, int *sp, int ni, int se, int fonc, char *couleur) 
  : Feature (n, st, sp, ni, se ) {
  strcpy(type,"Cds");
  LGFleche  = 5;
  HTFleche  = 2;

  if ( sens == 1 ) strcpy(color,couleur), strcpy(fillColor,couleur);
  else strcpy(color,couleur), strcpy(fillColor,couleur);
  fonction=fonc;
//  Jump = 1;
}


CDS::~CDS( ) {  } 

void CDS::print()
{
  Feature::print();
  cout <<  " fonction " << fonction << endl;
} // fin CDS::print
   
/*==========================================================================*/
/*     Fonction                                                             */
/*==========================================================================*/
void CDS::Draw( IMAGE *& Im, SequenceGraph *& Sg,
                int Begin, int End, Xaxe * GFXaxe) {
 /*........... Variables internes ........................................*/
  int X1, X2, Y1, Y2, Yintron ;
  int   XStart=0, YStart=0,  Width=0, BpLine=0;

  Sg->getAttributes(XStart, YStart,  Width, BpLine);

  int line ; 
  int Before = 0;    //indique si il y a un morceau d'element avant Begin
  int After = 0;     //indique si il y a un morceau d'element apres End
  int FinLine ;      //fin de la ligne courante
  int Xname;         //abscisse du debut du nom du gene
  int lgname;        //longueur en pixel du nom du gene
  int itr=0 ;        //indice du 1er intron ou du 1er exon a tracer 
  int iex;           //indice d'intron ou d'exon courant
  int debiex, finiex ;  //debut et fin de l'intron ou exon courant ;
  int firstpos;         //position de debut du 1er element dessine
  int lastpos ;         //position de fin du dernier element dessine 
  int largeuriex ;      //largeur de l'intron ou exon courant
  int *Tab ;           

/*........... Algorithme ...................................................*/
  firstpos = debiex = Start ;
  lastpos = finiex = Stop ;

 /*........... Trace des introns .........................................*/
  if (nintron > 0) {
    //start[itr+1]-1 correspond au stop de l'intron d'indice itr
    while (itr < nintron && start[itr+1]-1 < Begin) itr++ ;
    firstpos = stop[itr]+1 ;
    
    for (iex = itr; iex < nintron; iex++) {
      if (stop[iex]+1 <= End && start[iex+1]-1 >= Begin) {
	Before = 0 ;
	After = 0 ;
	debiex = stop[iex]+1 ;
	finiex = start[iex+1]-1 ;
	
	// Morceau d'intron avant Begin?
	if ( debiex <= Begin && finiex >= Begin)  {
	  Before = 1;
	  debiex = firstpos = Begin ;
	} /* fin if */
	// Morceau d'intron apres End?
	if ( finiex >= End) {
	  After = 1 ;
	  finiex = End ;
	  iex = nintron ;
	} /* fin if */
	
	line = Sg->WhichLine(debiex, Begin);
	FinLine = Begin + (line+1) * BpLine;    
	largeuriex = finiex - debiex ;
      
	if (( debiex + largeuriex) > FinLine) {
	  // Plusieurs Morceaux	
	  Y1 = (line * GFXaxe->decal) + YStart + Pos;
	  Y2 = Y1 + haut;
	  Yintron = Y1 + ((Y2-Y1)/2) ;
	  if (debiex > Begin)
	    X1 = Sg->InPixels( debiex-1, line, Begin, GFXaxe );
	  else
	    X1 = Sg->InPixels( debiex, line, Begin, GFXaxe );
	  X2 = XStart + Width;
	  if ( Before == 1 ) {
	    if (sens == 1)  //barre verticale de debut
	      new Line(Im, X1, Y1 - 5, X1, Y2 + 5, color, 1 );
	    else {    //la fleche
	      X1 = X1 - sens * LGFleche;
	      int T2[7] = { X1, Y1 - HTFleche, 
			    X1 + sens * LGFleche , Y1 + ((Y2-Y1)/2),
			    X1, Y2 + HTFleche, -1 };
	      Tab = &T2[0];
	      if (this->fonction==0)
		new PolyLine(Im, Tab, color, 1);
	      else
		new PolyLine(Im, Tab, color, 1, fillColor);
	    } /* fin else fleche */
	  } /* fin if Before */
	  new Line(Im, X1, Yintron, X2, Yintron, color) ;
	  
	  largeuriex = largeuriex - ( FinLine - debiex );
	  debiex = FinLine + 1;
	  line ++;
	  FinLine = Begin + ( line + 1 ) * BpLine;
	
	  while ( (debiex < End ) && ( finiex > FinLine )) {
	    Y1 = (line * GFXaxe->decal) + YStart + Pos;
	    Y2 = Y1 + haut;
	    Yintron = Y1 + ((Y2-Y1)/2) ;
	    new Line(Im, XStart, Yintron, XStart+Width, Yintron, color) ;
	    largeuriex = largeuriex -(FinLine-debiex);
	    debiex = FinLine + 1;
	    line ++;
	    FinLine = Begin + ( line + 1 ) * BpLine;
	  } /* fin while */
	  
	  // REgarde si ca deborde.
	  if ( debiex < End ) {
	    // Afficher le Dernier
	    Y1 = (line * GFXaxe->decal) + YStart + Pos;
	    Y2 = Y1 + haut;
	    Yintron = Y1 + ((Y2-Y1)/2) ;
	    if (finiex < End)
	      X2 = Sg->InPixels(finiex+1, line, Begin, GFXaxe);
	    else 
	      X2 = Sg->InPixels(finiex, line, Begin, GFXaxe);
	    X1 = XStart;
	    if ( After == 1 ) {
	      if (sens == -1)  //barre verticale de debut
		new Line(Im, X2, Y1 - 5, X2, Y2 + 5, color, 1 );
	      else {    //la fleche
		X2 = X2 - sens * LGFleche;
		int T2[7] = { X2, Y1 - HTFleche,
			      X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
			      X2, Y2 + HTFleche, -1};
		Tab = &T2[0];
		if (this->fonction==0)
		  new PolyLine(Im, Tab, color, 1);
		else
		  new PolyLine(Im, Tab, color, 1, fillColor);
	      } /* fin else fleche */
	    } /* fin if After */
	    new Line(Im, X1, Yintron, X2, Yintron, color) ;
	  } /* fin if debiex */
	} /* fin if plusieurs morceaux */

	else { 
	  // Un seul morceau
	  
	  Y1 = (line * GFXaxe->decal) + YStart + Pos;
	  Y2 = Y1 + haut;
	  if (debiex > Begin)
	    X1 = Sg->InPixels(debiex-1,line, Begin, GFXaxe);
	  else 
	    X1 = Sg->InPixels(debiex,line, Begin, GFXaxe);
	  if (finiex < End)
	    X2 = Sg->InPixels(finiex+1,line, Begin, GFXaxe);
	  else
	    X2 = Sg->InPixels(finiex,line, Begin, GFXaxe);
	  Yintron = Y1 + ((Y2-Y1)/2) ;
	  if ( Before == 1 ) {
	    if (sens == 1)  //barre verticale de debut
	      new Line(Im, X1, Y1 - 5, X1, Y2 + 5, color, 1 );
	    else {    //la fleche
	      X1 = X1 - sens * LGFleche;
	      int T2[7] = { X1, Y1 - HTFleche, 
			    X1 + sens * LGFleche , Y1 + ((Y2-Y1)/2),
			    X1, Y2 + HTFleche, -1 };
	      Tab = &T2[0];
	      if (this->fonction==0)
		new PolyLine(Im, Tab, color, 1);
	      else
		new PolyLine(Im, Tab, color, 1, fillColor);
	    } /* fin else fleche */
	  } /* fin if Before */
	  if ( After == 1 ) {
	    if (sens == -1)  //barre verticale de debut
	      new Line(Im, X2, Y1 - 5, X2, Y2 + 5, color, 1 );
	    else {    //la fleche
	      X2 = X2 - sens * LGFleche;
	      int T2[7] = { X2, Y1 - HTFleche,
			    X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
			    X2, Y2 + HTFleche, -1};
	      Tab = &T2[0];
	      if (this->fonction==0)
		new PolyLine(Im, Tab, color, 1);
	      else
		new PolyLine(Im, Tab, color, 1, fillColor);
	    } /* fin else fleche */
	  } /* fin if After */
	  new Line(Im, X1, Yintron, X2, Yintron, color) ;
	} /* fin else */
      } /* fin if stop[iex] */
    } /* fait itr */
  } /* fin if nintron > 0 */
  lastpos = finiex ;
  
 /*........... Trace du CDS ou des exons .................................*/
  itr = 0 ;
  while (itr < nintron+1 && stop[itr] < Begin) itr++ ;
    
  for (iex = itr; iex < nintron+1; iex++) {
    if (start[iex] <= End && stop[iex] >= Begin) {
      Before = 0 ;
      After = 0 ;
      debiex = start[iex] ;
      finiex = stop[iex] ;
      
      if ( debiex < Begin && finiex >= Begin)  {
	Before = 1;
	debiex = Begin ;
	firstpos = Begin ;
      } /* fin if */
      if ( finiex > End) {
	After = 1 ;
	finiex = End ;
	iex = nintron ;
      } /* fin if */
      if (debiex < firstpos)  
	firstpos = debiex ;
      if (finiex > lastpos)  
	lastpos = finiex ;
      
      line = Sg->WhichLine(debiex, Begin);
      FinLine = Begin + (line+1) * BpLine;    
      largeuriex = finiex - debiex ;
      
      int * Tab;
      
      if (( debiex + largeuriex) > FinLine) {
	// Plusieurs Morceaux
	Y1 = (line * GFXaxe->decal) + YStart + Pos;
	Y2 = Y1 + haut;
	X1 = Sg->InPixels( debiex, line, Begin, GFXaxe );
	X2 = XStart + Width;
	if (debiex > firstpos) {
	  int T1[9] = { X1, Y2, 
			X2, Y2, 
			X2, Y1, 
			X1, Y1, -1 };
	  Tab = &T1[0];
	}  /* fin if debiex */
	else {
	  if ( sens == 1 ) { //la barre de debut
	    int T1[9] = { X1, Y2, 
			  X2, Y2, 
			  X2, Y1, 
			  X1, Y1, -1 };
	    Tab = &T1[0];
	    new Line(Im, X1, Y1 - 5, X1, Y2 + 5, color, 1 );
	  } /* fin if sens */
	  else { 
	    // La fleche
	    X1 = X1 - sens * LGFleche;
	    int T2[15] = { X2, Y1, 
			   X1, Y1, 
			   X1, Y1 - HTFleche, 
			   X1 + sens * LGFleche , Y1 + ((Y2-Y1)/2),
			   X1, Y2 + HTFleche,
			   X1, Y2,
			   X2, Y2, -1 };
	    Tab = &T2[0];
	  } /* fin else fleche */
	} /* fin else debiex */
	if (this->fonction==0)
	  new PolyLine(Im, Tab, color, 1);
	else
	  new PolyLine(Im, Tab, color, 1, fillColor);
	
	largeuriex = largeuriex - ( FinLine - debiex );
	debiex = FinLine + 1;
	line ++;
	FinLine = Begin + ( line + 1 ) * BpLine;
	
	while ( (debiex < End ) && ( finiex > FinLine )) {
	  Y1 = (line * GFXaxe->decal) + YStart + Pos;
	  Y2 = Y1 + haut;
	  if (this->fonction==0)
	    new Box( Im, XStart, Y1, Width+XStart, Y2, color, 1);
	  else
	    new Box( Im, XStart, Y1, Width+XStart, Y2, color, 1, fillColor);
	  largeuriex = largeuriex -(FinLine-debiex);
	  debiex = FinLine + 1;
	  line ++;
	  FinLine = Begin + ( line + 1 ) * BpLine;
	} /* fin while */
	
	// REgarde si ca deborde.
	if ( debiex < End ) {
	  // Afficher le Dernier
	  Y1 = (line * GFXaxe->decal) + YStart + Pos;
	  Y2 = Y1 + haut;
	  X2 = Sg->InPixels(finiex, line, Begin, GFXaxe);
	  X1 = XStart;
	  if (finiex < lastpos) {
	    int T1[9] = { X2, Y2,
			  X1, Y2,
			  X1, Y1,
			  X2, Y1, -1};
	    Tab = &T1[0];
	  }  /* fin if finiex */
	  else {
	    if ( sens == -1 ) {  //la barre verticale
	      int T1[9] = { X2, Y2,
			    X1, Y2,
			    X1, Y1,
			    X2, Y1, -1};
	      Tab = &T1[0];
	      new Line(Im, X2, Y1 - 5, X2, Y2 + 5, color, 1 );
	    } /* fin if sens */
	    else {  //la fleche
	      X2 = X2 - sens * LGFleche;
	      int T2[15] = { X1, Y1,
			     X2, Y1, 
			     X2, Y1 - HTFleche,
			     X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
			     X2, Y2 + HTFleche,
			     X2, Y2,
			     X1, Y2 , -1};
	      Tab = &T2[0];
	    } /* fin else fleche*/
	  } /* fin else finiex*/
	  
	  if (this->fonction==0)
	    new PolyLine(Im, Tab, color, 1);
	  else
	    new PolyLine(Im, Tab, color, 1, fillColor);
	} /* fin if debiex */
      } /* fin if plusieurs morceaux */
      
      else { 
	// Un seul morceau
	Y1 = (line * GFXaxe->decal) + YStart + Pos;
	Y2 = Y1 + haut;
	X1 = Sg->InPixels(debiex,line, Begin, GFXaxe);
	X2 = Sg->InPixels(finiex,line, Begin, GFXaxe);
	if (sens == 1) {
	  if (finiex < lastpos) {
	    int T1[9] = { X1, Y2, 
			  X2, Y2, 
			  X2, Y1, 
			  X1, Y1, -1 };
	    Tab = &T1[0];
	  } /* fin if finiex */
	  else {
	    X2 = X2 - sens * LGFleche;
	    int T2[15] = { X1, Y1,
			   X2, Y1, 
			   X2, Y1 - HTFleche,
			   X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
			   X2, Y2 + HTFleche,
			   X2, Y2,
			   X1, Y2 , -1};
	    Tab = &T2[0];
	  } /* fin else finiex */
	  if (debiex <= firstpos) 
	    new Line(Im, X1, Y1 - 5, X1, Y2 + 5, color, 1 );
	} /* fin if sens==1 */
	
	else { //sens == -1
	  int Mem = X1 ; X1 = X2 ; X2 = Mem;
	  if (debiex > firstpos) {
	    int T1[9] = { X1, Y2, 
			  X2, Y2, 
			  X2, Y1, 
			  X1, Y1, -1 };
	    Tab = &T1[0];
	  } /* fin if debiex */
	  else {
	    X2 = X2 - sens * LGFleche;
	    int T2[15] = { X1, Y1,
			   X2, Y1, 
			   X2, Y1 - HTFleche,
			   X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
			   X2, Y2 + HTFleche,
			   X2, Y2,
			   X1, Y2 , -1};
	    Tab = &T2[0];
	  } /* fin else debiex */
	  if (finiex >= lastpos) 
	    new Line(Im, X1, Y1 - 5, X1, Y2 + 5, color, 1 );
	} /* fin else sens == -1 */
	if (this->fonction==0)
	  new PolyLine(Im, Tab, color, 1);
	else
	  new PolyLine(Im, Tab, color, 1, fillColor);
      } /* fin else 1 seul morceau */
    } /* fin if (start[iex] < End ) */
  } /* fait iex */

  /*........... Trace du nom du gene .....................................*/
  if ( sens == 1 )
    { 
      Y1 = Y1 + haut + 7; // on ecrit le nom du CDS en dessous
    }
  else 
    { 
      Y1 -=5; // on ecrit le nom du CDS au-dessus
    }
  // on ecrit le nom du CDS sur la derniere ligne du gene
  int l = Sg->WhichLine(firstpos, Begin);
  if (l < line)  X1 = XStart ;
  else  X1 = Sg->InPixels(firstpos,line, Begin, GFXaxe);
  X2 = Sg->InPixels(lastpos,line, Begin, GFXaxe);

  if ( strcmp(this->type , "Repeat"))
    {
      lgname = strlen(name)*6 ;
      //char tmp[50] ;
      
      // Il faut de la place pour ecrire le nom si en fin de ligne
      //if ( Xname  <= (Width-20) )
      if (lgname > (X2 - X1)) {
        int ncar = (int)((X2-X1)/6) ;
	if (ncar >= 2) {
	  //strncpy(name, name, ncar-2) ;
	  name[ncar-2] = '\0' ;
	  strcat(name, "..\0") ;
	}
	else
	  strcpy(name, "..") ;
      }	
      Xname =X1+(X2-X1)/2-strlen(name)*6/2 ;
      if (Xname < X1 && sens == -1) Xname = X1 ;
      new Text(Im, Xname,Y1,name,color,10);
    } /* fin if */


} /* fin CDS::Draw() */


void CDS::simpleDraw( IMAGE *& Im, int X1, int Y1, int X2 ) {
  int Y2 = Y1 + haut;
  
  int Tab[15] = { X1, Y2,
		  X2, Y2,
		  X2, Y2 + HTFleche,
		  X2 + sens * LGFleche, Y1 + ((Y2-Y1)/2),
		  X2, Y1 - HTFleche,
		  X2, Y1,
		  X1, Y1, 
		  -1};
  int * T = &Tab[0];
  new Line(Im, X1, Y1-5,X1,Y2+5,color,1);
  if (fonction==0)
    new PolyLine(Im,T,color,1);
  else
    new PolyLine(Im,T,color,1,fillColor);
}

void CDS::simpleDrawIntron( IMAGE *& Im, int *Xst, int Y1, int *Xsp , int ni) {
  int Y2 = Y1 + haut;
  int Yintron = Y1 + ((Y2-Y1)/2) ;

  new Line(Im, Xst[0], Y1-5,Xst[0],Y2+5,color,1);
  for (int i = 0; i < ni; i++) {
    new Box( Im, Xst[i] , Y1, Xsp[i], Y2, color, 1, fillColor);
    new Line(Im, Xsp[i]+1, Yintron,Xst[i+1]-1, Yintron, color, 1);
  } /* fait i */

  int Tab[15] = { Xst[ni], Y2,
		  Xsp[ni], Y2,
		  Xsp[ni], Y2 + HTFleche,
		  Xsp[ni] + sens * LGFleche, Y1 + ((Y2-Y1)/2),
		  Xsp[ni], Y1 - HTFleche,
		  Xsp[ni], Y1,
		  Xst[ni], Y1, 
		  -1};
  int * T = &Tab[0];
  new PolyLine(Im,T,color,1,fillColor);
}
