#include <Etat.h>

/* ........................................................................ */
/* ........ Fonction : Construit un objet de la classe Etat                */
/* ........................................................................ */
Etat::Etat (int _XStart, int _YStart, int _Width, int _Begin, int _End, 
	    int _Nlignes, int _Bpline, int _Graduation, int _Decal, int _Ecart,
	    int _Ygraph, char **_couleuretat, int _nchaine)
  : nchaine(_nchaine), couleuretat(_couleuretat), XStart(_XStart), YStart(_YStart), Width(_Width), Begin(_Begin), End(_End), Nlignes(_Nlignes), BpLine(_Bpline), Graduation(_Graduation), Decal(_Decal), Ecart(_Ecart), Ygraph(_Ygraph)
{
  FirstUnitSize = 3;
  SecondUnitSize = 1;
  textSize = 10;
  XMax = XStart + Width;
  strcpy(axecolor, "Black");
  strcpy(tcolor, "Black");
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
 Dessine le graphe des petats de chaque site
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void Etat::Draw( IMAGE *& Im, ifstream &ific)
{
  /*............. variables locales ............................*/
long compteur=0;
long compteur2=0;
  int Stop;
  char textEnd[10];
  char textBegin[10]; 
  char textSeq[10]; 

  Scale = (float)BpLine / ((float)XMax - (float)XStart);

  int beginLine = 0; 
  int endLine = Begin;
  int x;

  //int j = Begin;
  int Ygrad = (int)(Ygraph / 5);  //taille d'une graduation sur l'axe Y
  int Y_axeX = YStart - Ecart;  //Y de l'axe des abscisses
  int deltax = 3; //ecart entre debut de l'axe x et le debut de la sequence
  int deltay = 3; //ecart entre debut de l'axe y et le zero de l'axe

  /*............. Dessin ............................*/
  for(int i = 0; i < (Nlignes+1) ; i++)
   {
     beginLine = endLine;
     endLine += BpLine; // la base en fin de ligne, celle-ci non incluse

     if ( (endLine-1) >  this->End)
       {
	 endLine=this->End+1;
	 XMax = XStart + int ( ( this->End - Begin - i * BpLine) / Scale );
       }

     /*... trace des axes du graphe ...*/
     this -> DessineAxes(Im, Y_axeX, i, beginLine, endLine, Ygrad, deltax, 
			 deltay);

     /*... ecriture des bases ...*/
     if ( i == Nlignes)
       {
	 /* Ecriture du no de base en fin de sequence */
	 Stop = this->End;

	 sprintf(textSeq,"%d",(Stop));
	 x = XStart + int ( ( Stop - Begin - i * BpLine) /Scale );

	 new Text( Im, x - (strlen(textSeq)/2 * 6), Y_axeX + 8 , 
		   &(textSeq[0]) , tcolor, textSize);
       } /* fin if ( i == Nlignes) */
     else
       {
	 /* Ecriture du no de base en fin de ligne */
	 sprintf(textEnd,"%d",(endLine-1));
	 new Text( Im, XMax - (strlen(textEnd)/2 * 6), Y_axeX + 8 , textEnd, tcolor, textSize);
       } /* fin else */


     /* Ecriture du no de base en debut de ligne */
     /* ne pas chevaucher les nos de bases si on a ecrit celui de la fin de seq */
     sprintf(textBegin,"%d",beginLine);

     if ( (i != Nlignes) || 
	  ( (XStart - (strlen(textBegin)/2 * 6)) > x + (strlen(textSeq)/2 * 6)) ||
	  ( (XStart + (strlen(textBegin)/2 * 6) < x)))
       {
	 new Text( Im, XStart - (strlen(textBegin)/2 * 6), Y_axeX +8 , &(textBegin[0]) , tcolor, textSize);
       }
     
     this -> DrawPoints(Im, Y_axeX, ific, beginLine, endLine, deltay, compteur,
			compteur2);
     
     YStart += Decal;
     Y_axeX += Decal;

  } /* fin for (i */
  //cout << "Nbre de points en moins a dessiner : "<<compteur<<endl;
  //cout << "Nbre de points testes : "<<compteur2<<endl;
} /* fin Etat::Draw */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Fonction : Dessin des axes du graphe                             */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Etat::DessineAxes(IMAGE *& Im, int Y_axeX, int i, int beginLine, 
		       int endLine, int Ygrad, int deltax, int deltay)
{
  /* .......... variables locales ...............*/
  int x;
  //char textGrad[5];

  /*... trace des axes Y ...*/
  new Line ( Im, XStart-deltax, Y_axeX, XStart-deltax, Y_axeX-Ygraph-deltay);
  new Line ( Im, XMax+deltax, Y_axeX, XMax+deltax, Y_axeX-Ygraph-deltay);
  
  // trace des graduations sur l'axe Y
  // trace du texte
  new Text( Im, XStart - 20-deltax, Y_axeX-deltay, "0.0", tcolor, textSize);
  new Text( Im, XStart - 20-deltax, Y_axeX - Ygraph-deltay, "1.0", tcolor, textSize);
  // trace des graduations intermediaires
  for (int k = 0; k < 6; k++)
    {
      new Line ( Im, XStart - SecondUnitSize-deltax, Y_axeX - k * Ygrad-deltay, 
		 XStart + SecondUnitSize-deltax, Y_axeX - k * Ygrad-deltay);
      new Line ( Im, XMax - SecondUnitSize+deltax, Y_axeX - k * Ygrad-deltay, 
		 XMax + SecondUnitSize+deltax, Y_axeX - k * Ygrad-deltay);
    }
  
  /*... Trace de l'axe X ...*/
  new Line ( Im, XStart-deltax, Y_axeX, XMax+deltax, Y_axeX, axecolor);
  
  // Les autres barres verticales
  for ( int j = beginLine; j < endLine; j += Graduation)
    {
      x = XStart + int ( ( j - Begin - i * BpLine) /Scale );
      new Line( Im, x, Y_axeX - SecondUnitSize,
		x, Y_axeX + SecondUnitSize, axecolor);
    } /* fin for ( j = beginLine */
  // derniere barre verticale
  new Line ( Im, XMax,  Y_axeX - SecondUnitSize, XMax, Y_axeX + SecondUnitSize,
	     axecolor );
  
} /* fin DessineAxes */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Fonction : Dessin des points du graphe                           */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Etat::DrawPoints(IMAGE *& Im, int Y_axeX, ifstream &ific, int beginLine,
		      int endLine, int Yecart, long &compteur, long &compteur2)
{
  /*.......... variables locales ..............*/
  int etat;                       //indice d'etat
  float petat;                    //valeur du petat lu
  int Ypetat;                     //ordonnee du petat
  int Xpetat;                     //abscisse du petat
  int nbase;                      //indice de base relative au debut de la ligne
  int deltaX=0;
  int deltaY=0;
  short signe=1;                  //boulen : 1=positif, 0=negatif
  short *signePreced = new short[nchaine];  
                                  //boulen : 1=positif, 0=negatif
  double penteMin=1e-50;          //minimum de invpente
  int maxbase;                    //nb de base max sur la ligne courante
  int *Xpreced = new int[nchaine];//abscisse du point precedant de l'etat
  int *Ypreced = new int[nchaine];//ordonnee du point precedant de l'etat
  double *invpente = new double[nchaine];//pente inverse de la droite entre 2 points
  int *Xori = new int[nchaine];//abscisse du point d'origine de la droite
  int *Yori = new int[nchaine];//ordonnee du point d'origine de la droite

  /*........... dessin des points ...............*/
  maxbase = endLine - beginLine + 1;
  nbase = 1;

  //lecture des  points de la premiere base de la ligne et initialisation
  for ( etat = 0; etat < nchaine; etat++)
    {
      Litpetat(ific, petat);
      Xpreced[etat] = XStart + (int)(Width * nbase / BpLine);
      Ypreced[etat] = Y_axeX - (int)(petat * Ygraph) - Yecart;
      Xori[etat] = Xpreced[etat] ;
      Yori[etat] = Ypreced[etat] ;
      signePreced[etat] = 1 ;
      invpente[etat] = (double) 0 ;
    } /* fin for etat */

  //lecture des autres points
  for (nbase = 2; nbase < maxbase; nbase++)
    {
      for ( etat = 0; etat < nchaine; etat++)
	{
	  Litpetat(ific, petat);
	  Xpetat = XStart + (int)(Width * nbase / BpLine);
	  Ypetat = Y_axeX - (int)(petat * Ygraph) - Yecart;
	  deltaX = Xpetat - Xpreced[etat] ;
	  deltaY = Ypetat - Ypreced[etat] ;
	  signe = getSigne(deltaX, deltaY) ;
	  if (deltaX == 0 && deltaY == 0)
	    /*... le nouveau point est le meme que le precedant ...*/
	    /*.. on ne le dessine pas .............................*/
	    {
	      compteur++;
	    }
	  else
	    {
	      /*.. on regarde la pente inverse de la droite entre les 2 pts .*/
	      /*. si elle est identique a la pente precedante, pas de ligne .*/
	      if (deltaY == 0)
		{
		  if (invpente[etat] != penteMin)
		    {
		      new Line(Im, Xori[etat], Yori[etat], Xpreced[etat], 
			       Ypreced[etat], couleuretat[etat]);
		      Xori[etat] = Xpreced[etat] ;
		      Yori[etat] = Ypreced[etat] ;
		      invpente[etat] = penteMin ;
		    } /* fin if */
		  else compteur2++;
		} /* fin if */
	      else if(((double) (deltaX) / (double) (deltaY) != invpente[etat])
		      || (signe != signePreced[etat]))
		{
		  new Line(Im, Xori[etat], Yori[etat], Xpreced[etat], 
			   Ypreced[etat], couleuretat[etat]);
		  Xori[etat] = Xpreced[etat] ;
		  Yori[etat] = Ypreced[etat] ;
		  invpente[etat] = (double) (deltaX) / (double) (deltaY);
		} /* fin else if */
	      else
		{
		  //compteur2++;
		} /* fin else */
	      //new Line(Im, Xpreced[etat], Ypreced[etat], Xpetat, Ypetat, 
	      //   couleuretat[etat]);
	    } /* fin else */
	  Xpreced[etat] = Xpetat;
	  Ypreced[etat] = Ypetat;
	  signePreced[etat] = signe;
	} /* fin for etat */
    } /* fin for nbase */

  /*...... trace des dernieres lignes .....*/
  for ( etat = 0; etat < nchaine; etat++)
    {
      new Line(Im, Xori[etat], Yori[etat], Xpreced[etat], Ypreced[etat], 
	       couleuretat[etat]);
    } /* fin for etat */
  delete[] Xpreced ;
  delete[] Ypreced ;
  delete[] Xori ;
  delete[] Yori ;
  delete[] invpente ;
} /* fin DrawPoints */


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Fonction : Lit la valeur d'un petat                              */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Etat::Litpetat(ifstream &ific, float &petat)
{
  ific >> petat;
  if (ific.eof())
    {
      cerr << "Etat::Litpetat: Fin du fichier"
	   << endl;
      exit(1);
    }
} /* fin Litpetat */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Fonction : renvoie le produit des signes de 2 nombres            */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
short Etat::getSigne(int a, int b)
{
  short signe;

  if (a >= 0) {
    if (b >= 0)  signe = 1 ;
    else         signe = 0 ;
  } /* fin if */
  else  {
    if (b >= 0)  signe = 0 ;
    else         signe = 1 ;
  } /* fin if */

  return signe ;
} /* fin getSigne */

