#include <iomanip.h>
#include <Plage.h>
#include <Image.h>

/* ........................................................................ */
/* ........ Fonction : Construit un objet de la classe Plage                */
/* ........................................................................ */
Plage::Plage ( int _Yplage, int _Yecart, int _Yseqpl, int _Ylin_esc)
  :  Yecart(_Yecart), Yplage(_Yplage),
     Yseqpl (_Yseqpl), Ylin_esc(_Ylin_esc)
  /* on ne tient plus compte du seuil ! */
{}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 Fonction : lit le fichier des sorties principales de R'HOM,
            (les valeurs des petats), dtermine les plages
            et appelle Draw1Plage pour dessiner chacune
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

int Plage::Draw( IMAGE *& Im, SequenceGraph *& Sg, int begin, int end, 
		 Xaxe *axe, ifstream &ific, int printP, int dessinPl,
		 ofstream &ofic, int nchaine, char **couleuretat)
{
  /*............. variables locales ..................................*/
  int etat, etatpred, debut, fin, certain, certainpred;
  int nbase=0, i, ibase, retour;
  double petatmax, petatmaxpred, petatminpred;
  int debvertical=0, finvertical=0;
  //les variables ci-dessous servent a diminuer le nombre d'objets a dessiner
  int *X1preced ;
  int *X2preced ;
  int *Ypreced ;
  int X1Preced=0 ;
  int X2Preced=0 ;
  int YPreced=0 ;
  int compteur=0 ;

 /*............. Algorithme .........................................*/
  marche = new int[nchaine];
  X1preced = new int[nchaine];
  X2preced = new int[nchaine];
  Ypreced = new int[nchaine];

  // Determination du decalage en Y des differentes lignes des etats
  for (i = 0; i < nchaine; i++)
    {
      marche[i] = i * (Yecart + Yplage) ;
      X1preced[i] = 0 ;
      X2preced[i] = 0 ;
      Ypreced[i] = 0 ;
    } /* fin for */

  retour=this->LitEtats(ific, nchaine, etatpred, certainpred, petatmaxpred);
  if (retour!=0)
    {
      cerr << "Plage::Draw: Erreur en lisant les 1iers petats sur le fichier des sorties de R'HOM "
	   << endl;
      return(1);
    }
  debut = begin; // bases numerotes a partir de 1
  if (debut ==0) debut++;
  ibase=debut;
  petatminpred= petatmaxpred;

/*............ Ecriture des en-tete pour l'ecriture des plages ...........*/
  if (printP==1)
    {
      // Ecrire l'en-tete des impressions
      cout << endl;
      cout.width(7);
      cout.setf(ios::left, ios::adjustfield); 
      cout << "Debut";
      cout << " ";
      cout.width(7);
      cout.setf(ios::right, ios::adjustfield); 
      cout << "Fin" << "   ";
      cout.width(6);
      cout.setf(ios::right, ios::adjustfield); 
      cout << "Regime" << " ";
      cout.width(9);
      cout.setf(ios::left, ios::adjustfield); 
      cout << "Couleur";
      cout << " ";
      cout.width(11);
      cout.setf(ios::left, ios::adjustfield); 
      cout << "Petat_min" << " ";
      cout.width(11);
      cout.setf(ios::left, ios::adjustfield); 
      cout << "Petat_max" << endl << endl;

    }
  if (ofic !=NULL)
    /* on ecrit l'en tete du fichier des plages */
    {
      ofic.width(7);
      ofic.setf(ios::left, ios::adjustfield); 
      ofic << "Debut";
      ofic << " ";
      ofic.width(7);
      ofic.setf(ios::right, ios::adjustfield); 
      ofic << "Fin" << "   ";
      ofic.width(6);
      ofic.setf(ios::right, ios::adjustfield); 
      ofic << "Regime" << " ";
      ofic.width(7);
      ofic.setf(ios::left, ios::adjustfield); 
      ofic << " ";
      ofic << " ";
      ofic.width(11);
      ofic.setf(ios::left, ios::adjustfield); 
      ofic << "Petat_min" << " ";
      ofic.width(11);
      ofic.setf(ios::left, ios::adjustfield); 
      ofic << "Petat_max" << endl << endl;
    } /* fin if */

  while (ibase <= end)
    {
      ibase++;
      retour=this->LitEtats(ific, nchaine, etat, certain, petatmax);
      if (retour!=0)
	{
	  cerr << "Plage::Draw: Erreur en lisant les "
	       << ibase
	       << "imes petats sur le fichier des sorties de R'HOM "
	       << endl;
	  return(1);
	}
      
      // Pour information: la valeur max et min de l'etat sur la plage

      if ((etat==etatpred)  && (certain==certainpred))
      {
	if (petatmax > petatmaxpred)
	  petatmaxpred= petatmax;
	if (petatmax < petatminpred)
	  petatminpred= petatmax;
	continue;
      }
      else
	{
	  fin=ibase-1;
	  nbase++; 
	  // Affichage de la plage
	  if (printP==1)
	    this->print( cout, debut,  fin, 
			 etatpred,  couleuretat[etatpred],
			 certainpred,
			 petatminpred, petatmaxpred);
	  // Ecrire les plages dans un fichier
	  if (ofic !=NULL)
	    {
	      this->print( ofic, debut,  fin, 
			   etatpred, " ",
			   certainpred,
			   petatminpred, petatmaxpred);
	    }
	  
	  // Dessiner les plages
	  if (dessinPl !=0)
	    {
	      if (etat==etatpred)
		finvertical=0;
	      else
		finvertical=1;
	      this->Draw1Plage( Im,  Sg, begin, end, axe,  debut, fin, 
				etatpred, certainpred, debvertical, 
				finvertical, couleuretat, X1preced, X2preced,
				Ypreced, X1Preced, X2Preced, YPreced,compteur);
	      debvertical=finvertical;
	    } /* fin if (dessinPl !=0) */

	  debut=ibase;
	  etatpred=etat;
	  certainpred=certain;
	  petatminpred=petatmaxpred=petatmax;
	}
    } /* fin while */
  
  if (debut <  end)
    {
      // Affichage de la dernire plage
      // car on ne l'a ecrit que si elle debute en end
      nbase++;
      if (printP==1)
	this->print( cout, debut,end, etat,  couleuretat[etat], certain,
		     petatminpred, petatmaxpred);
      
      if (ofic !=NULL)
	{
	  this->print( ofic, debut,end, etat,  " ", certain, petatminpred, 
		       petatmaxpred);
	}
      if (dessinPl !=0)
	{
	  if (etat==etatpred)
	    finvertical=0;
	  else
	    finvertical=1;
	  
	  this->Draw1Plage( Im,  Sg, begin, end, axe,  debut, end , etat, 
			    certain, debvertical, finvertical, couleuretat, 
			    X1preced, X2preced, Ypreced, X1Preced, X2Preced, 
			    YPreced, compteur);
	} /* fin if (dessinPl !=0) */
      
    }
  
  //cout << "nb de plages a dessiner en moins : " << compteur << endl ;
  cout << endl << endl<< "Nombre de plages: " << nbase << endl;
  if (ofic !=NULL)
    ofic << endl << endl<< "Nombre de plages: " << nbase << endl;

  return(0);
} /* fin Plage::Draw */



/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
FinLigne renvoie l'indice de la base   en fin de la ligne
ou il y a position
position: indice de base a partir de 1
ligne: indice de ligne a partir de 0
start: indice de la 1iere base de la sequence considre a partir de 1
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

int Plage::FinLigne(int position, int ligne, int bpl, int start)
{
int retour;

retour =  (ligne + 1 ) *bpl +start -1;

return(retour);

}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
 dessine la portion de la ligne des plages de basedebut a basefin
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void Plage::Draw1Plage( IMAGE *& Im, SequenceGraph *& Sg, int begin, int end, 
			Xaxe *axe, int basedebut, int basefin, int etat, 
			int certain, int debvertical, int finvertical,
			char **couleuretat, int *&X1preced, int *&X2preced,
			int *&Ypreced, int &X1Preced, int &X2Preced, 
			int &YPreced, int &compteur)
{
  // Les indices de lignes sont numrotes  partir de 0
  // Les indices de bases sont numrotes  partir de 1

  int X1; // debut courant (sur une ligne)  de la plage en pixels
  int X2; // fin courante (sur une ligne) de la plage en pixel
  int Y; // ordonnee de la ligne courante
  int Ylin1 ; //ordonnee de la plage lineaire 1
  int Ylin2 ; //ordonnee de la plage lineaire 2
  int Yesc1 ; //ordonnee de la plage en escalier 1
  int Yesc2 ; //ordonnee de la plage en escalier 2
  int line_fin_plage ; // indice a partir de 0 de la ligne de basefin
  int debut_cour; // base de debut de la page sur la ligne courante;
  int line_cour=-1; //  indice a partir de 0 de la ligne de debut_cour
  int fin_de_ligne_cour; // base de fin de la ligne de debut_cour
  int   XStart=0, YStart=0,  Width=0, BpLine=0;
   
  Sg->getAttributes(XStart, YStart,  Width, BpLine);


  debut_cour = basedebut;


  line_fin_plage = Sg->WhichLine(basefin, begin);
  if ((end-begin)%BpLine == 0 && line_fin_plage == (end-begin)/BpLine)
   line_fin_plage-- ;

  while (line_cour != line_fin_plage)
    { 

      line_cour = Sg->WhichLine(debut_cour, begin);
      if (line_cour == line_fin_plage)
	{
	  fin_de_ligne_cour = FinLigne(debut_cour, line_cour, BpLine, begin) ;
	  X2 = Sg->InPixels(basefin, line_fin_plage, begin, axe);
	}
      else
	{
	  fin_de_ligne_cour = FinLigne(debut_cour, line_cour, BpLine, begin) ;
	  X2 = Sg->InPixels(fin_de_ligne_cour, line_cour, begin, axe);
	}
      Y = (line_cour * axe->decal) + YStart;
      Ylin1 = Y - Yseqpl ;
      Yesc1 = Y - Yseqpl - Yplage - Ylin_esc - marche[etat] ;
      Ylin2 = Ylin1 - Yplage + 1 ;
      Yesc2 = Yesc1 - Yplage + 1 ;
      // Y correspond a l'emplacement de l'axe de base
      // On le decale selon la valeur de l'etat
      //YDecal = Y+ (int)this->marche[etat];


      X1 = Sg->InPixels(debut_cour, line_cour, begin, axe);
    
      //new Box(Im, X1,Y-Yseqpl-marche[etat], X2, Y-Yseqpl-marche[etat]-Yplage+1,
      //couleuretat[etat],0,couleuretat[etat]);
      /*..... representation en escalier .....*/
      if (X1preced[etat] != X1 || X2preced[etat] != X2 ||
	  Ypreced[etat] != Yesc1)
	new Box(Im,X1,Yesc1, X2,Yesc2, couleuretat[etat],0,couleuretat[etat]);
      else compteur ++ ;

      /*..... representation lineaire .....*/
      if (X1Preced != X1 || X2Preced != X2 || YPreced != Ylin1)
	new Box(Im, X1,Ylin1,X2,Ylin2, couleuretat[etat],0,couleuretat[etat]);
      else compteur ++ ;
      
      debut_cour = fin_de_ligne_cour + 1 ;
    } /* fin while (line_debut != line_fin) */

  X1preced[etat] = X1 ;
  X2preced[etat] = X2 ;
  Ypreced[etat] = Yesc1 ;
  X1Preced = X1 ;
  X2Preced = X2 ;
  YPreced = Ylin1 ;
} /* fin Plage::Draw1Plage */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
 lit les valeurs des petats correspondant a une position
et determine l'etat correspond  la proba max, 
et s'il est superieur a seuil
Att: etat numrot  partir de 0
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

int Plage::LitEtats( ifstream &ific, int nchaine, int & etat, int & certain,
		     double & petatmax)
{
double *petats ;
int j;

petats = new double[nchaine] ;
certain=1;
etat=-1;
petatmax=-1;

    for (j=0; j < nchaine ; j++)
      {
	ific >> petats[j];
	if  ( ific.eof())
	  {
	    cerr << "Plage::LitEtats: Fin du fichier"
		 << endl;
	    return(1);
	  }
	if (petats[j]> petatmax)
	  {
	  etat=j;
	  petatmax=petats[j];
	  }
      }

    //if (petatmax < seuil)
    //certain=0;

return(0);
} /* fin Plage::LitEtats */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
ecriture de la plage
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void Plage::print( ostream &ofic,int debut, int fin, 
		     int  etat, char * color,
		     int  certain,
		     double petatmin, double petatmax)
{
  ofic.width(7);
  ofic.setf(ios::left, ios::adjustfield); 
  ofic << debut;
  ofic << "-";
  ofic.width(7);
  ofic.setf(ios::right, ios::adjustfield); 
  ofic << fin << "   ";
  ofic.width(6);
  ofic.setf(ios::right, ios::adjustfield); 
  ofic << etat+1 << " ";
  ofic.width(9);
  ofic.setf(ios::left, ios::adjustfield); 
  ofic << color << " ";
  ofic.width(11);
  ofic.setf(ios::left, ios::adjustfield); 
  ofic << petatmin << " ";
  ofic.width(11);
  ofic.setf(ios::left, ios::adjustfield); 
  ofic << petatmax << endl;
  //<< setw(1) <<  certain << endl;
} /* fin Plage::print */



/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
Ecrit la legende
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void Plage::Legend( IMAGE *& Im, int XStart, int &Y, int ncpt, int nchaine, 
		    char **couleuretat, int yplage, int dessinPl, int dessinPr,
		    int Width)
{
/*.......... Variables internes .........................................*/
  char label[100];
  int X=XStart;
  char tmp[8]; 

/*.......... Algorithme .........................................*/
  if (ncpt > nchaine) {
    cerr << "(Plage::Legend) Erreur sur le fichier de configuration :" << endl;
    cerr << "le nombre de regimes autocomplementaires (" << ncpt
	 << ") doit etre inferieur ou egal au nombre de regimes total ("
	 << nchaine << ")." <<endl;
    exit (1) ;
  } /* fin if */
 
 /*.......... legende pour les plages .................................*/
  if (dessinPl != 0) {
    new Text(Im, X,Y,"Plages : regimes ", "Black",10); 
    X += (17*6);
  } /* fin if */
  else if (dessinPr != 0) {
    new Text(Im, X,Y,"Probabilites : regimes ", "Black",10); 
    X += (23*6);
  } /* fin else */

  for (int i=0; i<nchaine; i++)
    {
      sprintf(label,"%d " ,i+1);
      new Text(Im, X,Y,label, "Black",10); 
      X += (2*6);
      new Box(Im, X, Y+1, (X+6), Y+1-yplage, couleuretat[i],0,couleuretat[i]);
      X += (3*6);
    } /* fait i */

  /*..... legende si il y a des regimes autocomplementaires ...........*/
  if (ncpt > 0)
    {
      int Xsuiv = 26 * 6;
      /* on va a la ligne si la largeur ne permet pas de tout ecrire */
      if (X+Xsuiv-(4*6) > Width+XStart) {X= XStart; Y+=15;}
      X += 5;
      if (ncpt == 1)
	//strcpy(label, "Le regime 1 est autocomplementaire.");
	strcpy(label, "(1 est autocomplementaire)");
      else
	{
	  //strcpy(label, "Les regimes ");
	  strcpy(label, "(");
	  for (int i = 1; i < ncpt-1; i++)
	    {
	      sprintf(tmp, "%d, ", i);
	      strcat(label, tmp);
	    } /* fait i */
	  sprintf(tmp, "%d et %d", ncpt-1, ncpt);
	  strcat(label, tmp);
	  strcat(label, " sont autocomplementaires)");
	} /* fin else */
	new Text(Im, X, Y, label, "Black", 10) ; 
    } /* fin if */

Y += 15;

} // fin Plage::Legend
