#ifndef Plage_H
#define Plage_H

#include <stdlib.h>
#include <iostream.h> 
#include <fstream.h>
#include <string.h>

#include <SequenceGraph.h>
#include <Image.h>
#include <GraphicUnit.h>
#include <Color.h>
#include <const.h>


class Plage  {
  /*.......... membres prives ..................*/
private:
  int Pos;// hauteur entre l'axe et les lignes extremes des etats
  int Yecart;  //ecart de hauteur entre 2 plages d'etat successif
  int Yplage;  //epaisseur des plages
  int Yseqpl;  //hauteur entre la sequence et la plage du 1er etat
  int Ylin_esc;//hauteur entre la representation lineaire et en escalier des plages

  char * couleur[MAXNCHAINE] ; // les couleurs en char
  int *marche; // hauteur de la plage de l'etat i par rapport au 1er etat

  int FinLigne(int position, int ligne, int bpl, int begin);
  void Draw1Plage ( IMAGE *& , SequenceGraph *&, int begin, int end, Xaxe *axe,
		    int debut, int fin, int etat, int certain, int debvertical,
		    int finvertical, char **couleuretat, int *&X1preced, 
		    int *&X2preced, int *&Ypreced, int &X1Preced, 
		    int &X2Preced, int &YPreced, int &compteur);
  int LitEtats( ifstream &ific, int nchaine, int & etat, int & certain,
		double &petatmax);

  void print( ostream &ofic,int debut, int fin, int  etat, char * couleur,
	      int  certain, double petatmin, double petatmax);

  /*.......... membres publiques ..................*/
public: 
  Plage(int _Yplage, int _Yecart, int _Yseqpl, 
	int _Ylin_esc) ;
  inline ~Plage( void );
  inline char** Renvoie_couleur();

  int Draw( IMAGE *& Im,  SequenceGraph *&, int begin, int end, Xaxe *axe,
	    ifstream &ific, int printP, int dessinP, ofstream &ofic, 
	    int nchaine, char **couleuretat);

  void Legend( IMAGE *& Im, int X, int &Y, int ncpt, int nchaine, 
	       char **couleuretat, int yplage, int dessinPl, int dessinPr,
	       int Width);
};

/* ........................................................................ 
Renvoie les couleurs  qui correspondent aux tats
........................................................................ */

  inline char** Plage::Renvoie_couleur()
{
return(this->couleur);
}

/* ........................................................................ */
// Destructeur
/* ........................................................................ */

inline Plage::~Plage( ) {  

  delete[] marche;
  
} /* fin  Plage::~Plage( ) */



#endif
