#include <SequenceGB.h>

SequenceGB::SequenceGB( void ) {
}

SequenceGB::~SequenceGB( void ) {
#ifdef DEBUG
  cout << "Fermeture du Reader Genbank" << endl;
#endif
}

void SequenceGB::setSequence( SequenceGFX *seq ) { s = seq; }

/* --------------------------------------------------------
Lecture de la sequence GenBank 
----------------------------------------------------------- */

int SequenceGB::readSequence(ifstream &ific ) {

  if ( !isGenBank(ific) ) 
    { cerr << "Ce n'est pas un fichier GenBank" << endl; 
     return(-1); 
     }

  // Locus
  readSpace(ific);
  readName(ific);

  // Size
  readSpace(ific);
  readSize(ific);
  
  // Jump to Features.
  while ( strncmp(line,"FEATURES",8) ) ific.getline(line,80);

#ifdef DEBUG  
  cout << "Lecture des Features" << endl;
#endif
  readFeatures(ific);

return(0);
}

/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
bool SequenceGB::isGenBank( ifstream &ific ) {
  // Lecture du header pour verifier si genbank.
  ific.getline(line,80,' ');

  if ( strcmp(line, "LOCUS") ) { return false; }
  return true;
}

/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
void SequenceGB::readSpace( ifstream &ific ) {
  // Eliminer les blancs
  while ( ific.peek() == ' ' ) ific.get();
}
/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
void SequenceGB::readName( ifstream &ific ) {
  // Recuperation du nom de la sequence
  ific.getline(line,80,' ');
  char tmp[ 15 ];
  strcpy( tmp,line ); 

  s->setLocus( tmp );
  //  strcpy(seqName, line);
}
/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
void SequenceGB::readSize( ifstream &ific ) {
  // Recuperation de la Taille de la sequence
  ific.getline(line,80,' ');
  s->setSize( atoi(line) );
}

/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
void SequenceGB::readFeatures( ifstream &ific ) {
  // Ici dans line on a features... 
  
  bool cds = false;
  
  int nbblancs, fonction, start, stop, sens;
  int nintron ;                 //nb d'introns
  int *startex, *stopex ;       //debuts des exons et fins des introns

  // Traitement des Features 
  while ( ific.eof()==0 ) { 
    // Initialisation.
    start = 0; 
    stop = 0;
    sens = 1;
    fonction=0; // fonction inconnue
    nintron=0;
    // On lit jusqu'au 1ier car. non blanc
    nbblancs = 0;
    while ( ific.peek() == ' ' )
      {
	ific.get(); 
	nbblancs ++; 
      }

    // SI 5 blancs alors on a un Features
    // Sinon c'est un Qualifier ou la partie Feature est terminee.
    if ( nbblancs == 5 ) { 
      
      // Recuperation du type de feature.
      // On lit jusqu'au 1ier car. blanc
      ific.getline(line,80,' ');

      /* fl : l'instruction suivante supprime un bug lorsque le qualifier est 
         de 15 caracteres : danc cas ific.peek() == ' ' est faux et les 
         features suivantes ne sont pas dessinees */
      if (strlen(line) > 14)
	ific.getline(line,80,'\n');

#ifdef DEBUG
      cout <<" Recuperation du type de feature " << line << endl;      
#endif
      // Tester le type de feature.
      if ( !strncmp(line, "source", 6 )) { 
#ifdef DEBUG
	cout << "SOURCE Feature" << endl; 
#endif
      }
      // Traitement des CDS (ou assimil)
      // -----------------
      if ( !strncmp(line, "mRNA", 4 ) ) { 
	//Lecture du start (et du sens)
	if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != -1){
	  if (startex[0] == 94683)
	    {
	      cout << "hello" << endl ;
	    }

	  fonction = readGene(ific);
	  s->addFeature( new mRNA(&temp[0] , startex, stopex, nintron, sens, 
				  fonction)  );
	  delete[] startex ;
	  delete[] stopex ;
	}
	else { 
	  cout << "Feature mRNA too complex : "; 
	  readEndFeatures(ific);
	} /* fin else */
      } /* fin if mRNA */

      if ( !strncmp(line, "rRNA", 4 ) ) { 
	//Lecture du start (et du sens)
	if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != -1){
	  fonction = readGene(ific);
	  s->addFeature( new rRNA(&temp[0] , startex, stopex, nintron, sens, 
				  fonction)  );
	  delete[] startex ;
	  delete[] stopex ;
	}
	else { 
	  cout << "Feature rRNA too complex : "; 
	  readEndFeatures(ific);
	} /* fin else */
      } /* fin if rRNA */

      if ( !strncmp(line, "tRNA", 4 ) ) { 
	//Lecture du start (et du sens)
	if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != -1){
	  fonction = readGene(ific);
	  s->addFeature( new tRNA(&temp[0] , startex, stopex, nintron, sens, 
				  fonction)  );
	  delete[] startex ;
	  delete[] stopex ;
	}
	else { 
	  cout << "Feature tRNA too complex : "; 
	  readEndFeatures(ific);
	} /* fin else */
      } /* fin if tRNA */

      // CDS "purs"
      if ( !strncmp(line, "CDS", 3 ) )
	{
	  cds = true;
	  // Lecture du start (et du sens)
	  if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != 
	      -1){
	    fonction = readGene(ific);
	      s->addFeature( new CDS( &temp[0] , startex, stopex, nintron, 
				      sens, fonction));
	      delete[] startex ;
	      delete[] stopex ;
	    }
	  else { 
	    cout << "Feature CDS too complex : "; 
	    readEndFeatures(ific);
	  } /* fin else */
	} /* fin if ( !strncmp(line, "CDS", 3 ) ) */

      if ( !strncmp(line, "LTR", 3 ) ||
           !strncmp(line, "repeat_", 7) ||
           !strncmp(line, "satellite", 9))
	{
	  // Lecture du start (et du sens)
	  if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != 
	      -1){
	    fonction = readGene(ific);
	    s->addFeature( new Repet(&temp[0], startex, stopex, nintron, sens, 
				     fonction)  );
	    delete[] startex ;
	    delete[] stopex ;
	  }
	  else { 
	    cout << "Feature Repeat too complex : "; 
	    readEndFeatures(ific);
	  } /* fin else */
	} /* fin repetitions */
      // Fin des CDS

      if ( !strncmp(line, "promoter", 8 ) || 
	   !strncmp(line, "-10_signal", 10 ) || 
	   !strncmp(line, "-35_signal", 10 ) ) { 
	// Lecture du start (et du sens)
	if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != -1){
	  s->addFeature( new Promoter(&temp[0] , startex, stopex, nintron, 
				      sens));
	delete[] startex ;
	delete[] stopex ;
	}
	else { 
	    cout << "Feature Promoter too complex : "; 
	  } /* fin else */
      } /* fin promoteur */

      if ( !strncmp(line, "terminator", 10 ) ) { 
	// Lecture du start (et du sens)
	if ((start=readStartStop(ific, sens, nintron, startex, stopex)) != -1){
	  s->addFeature( new Terminator( &temp[0] , startex, stopex, nintron,
					 sens)  );
	  delete[] startex ;
	  delete[] stopex ;
	}
	else { 
	    cout << "Feature Terminator too complex : "; 
	  } /* fin else */
      } /* fin terminator */


    } /* fin nbblancs=5 */
    else 
      {
      // Suivant.
      if (nbblancs==0)
	{
	  break;
	}
      else
	{
	  // c'est un qualifier ignor
	  ific.getline(line,80);
	}
      } /* fin du else nbblancs=5 */
  } /* fin du while ific.eof */

if (ific.eof()!=0)
  {
  cerr << "SequenceGB::readFeatures: fin prmature du fichier Sequence" << endl;
  cerr << " Dernire ligne lue: " << line << endl;
  exit(1);
  }
} /* fin readFeatures */

/*=========================================================================*/
/*   Fonction                                                              */
/*   lit le debut et fin de chaque exon du gene. (pour les terminteur,     */
/*   les promoteurs et les repeat, on considere qu'il peut y avoir des     */
/*   introns, alors qu'il n'y en a jamais)                                 */ 
/*=========================================================================*/
int SequenceGB::readStartStop( ifstream &ific, int &sens , int &nintron,
			       int *&startex, int *&stopex) {
  /*......... Variables internes ..............................*/
  int St_tmp[50] ; //tampon des starts des exons
  int Sp_tmp[50] ; //tampon des stops des exons

  /*......... Algorithme .......................................*/
  readSpace(ific);
  if ((St_tmp[0] = readStart(ific, sens, nintron)) != -1){
    if (nintron != 0){
    /*...... cas ou il y a au moins 1 intron ............*/
      char *token ;
      char buf[201] ;

      ific.getline(buf, 200, '\n') ;
      // prise du premier stop
      token = strtok(buf, ".,)><") ;
      Sp_tmp[0] = atoi(token) ;
      if (Sp_tmp[0] <= St_tmp[0]) {
	cerr << "Erreur dans la squence : " << endl 
	     << "fin du gne (" << Sp_tmp[0] 
	     << ") infrieur au dbut du gne (" << St_tmp[0] << ")."
	     << endl ;
	exit(1) ;
      } /* fin if */
      token = strtok(NULL, ".,><)") ;
      while(token != NULL){
	// prise start suivant
	St_tmp[nintron] = atoi(token) ;
	// prise stop suivant
	token = strtok(NULL, ".,)><") ;
	Sp_tmp[nintron] = atoi(token) ;
	if (Sp_tmp[nintron] <= St_tmp[nintron]) {
	  cerr << "Erreur dans la squence : " << endl 
	       << "fin du gne (" << Sp_tmp[nintron] 
	       << ") infrieur au dbut du gne (" << St_tmp[nintron]  << ")."
	       << endl << endl ;
	} /* fin if */
	token = strtok(NULL, ".,)><") ;
	nintron++ ;
      } /* fin while */
      nintron-- ;
    } /* fin if */
    /*...... cas ou il n'y a pas d'intron ................*/
    else Sp_tmp[nintron] = readStop(ific) ;

    startex = new int[nintron+2] ;
    stopex = new int[nintron+2] ;
    for (int i=0; i <= nintron; i++){
      startex[i] = St_tmp[i] ;
      stopex[i] = Sp_tmp[i] ;
      if (stopex[i] <= startex[i]) {
	cerr << "Erreur dans la squence : " << endl 
	     << "fin du gne (" << stopex[i] 
	     << ") infrieur au dbut du gne (" << startex[i] << ")."
	     << endl << endl ;
      } /* fin if */
      if (i > 0 && startex[i] <= stopex[i-1]) {
	cerr << "Erreur dans la squence : " << endl 
	     << "dbut d'exon (" << startex[i] 
	     << ") infrieur  la fin de l'exon prcdent (" << stopex[i-1] 
	     << ")." << endl << endl ;
      } /* fin if */
    } /* fin for */
    return 0 ;
  } /* fin if */
  else return -1 ;
} /* fin readStartStop */

/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
int SequenceGB::readStart( ifstream &ific, int &sens , int &nintron) {
  readSpace(ific);
  
  // Recuperation du START
  ific.getline(line,80,'.');
  char * pt = &line[0];

  // Regarder le sens 
  if ( !strncmp(line, "complement(", 11 ) ) { 
    sens = -1; 
    pt+=11;
    if (!strncmp(line+11, "join(", 5 ) ) { 
      nintron = 1 ;
      pt+=5;
    } /* fin if */
  } /*fin if */

  if (!strncmp(line, "join(", 5 ) ) { 
      nintron = 1 ;
      pt+=5;
    } /* fin if */

  if ( pt[0] == '>' || pt[0] == '<' ) { pt++; }

  // Tester les cas simple complement(chiffre ou chiffre... 
  // Sinon on jette!
  if ( pt[0] >= '0' && pt[0] <= '9' ) return atoi(pt);

  return -1;
}
/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
int SequenceGB::readStop(ifstream &ific  ) {
  //Recuperation du Stop
  ific.getline(line,80);
  char * pt = &line[0];
  
  if ( pt++[0] == '.' ) { 
    //   i++;
    if ( pt[0] == '>' || pt[0] == '<' ) { pt++; }
    return atoi(pt);
  }
  return -1;
}

/*=========================================================================*/
/*   Fonction                                                              */
/*=========================================================================*/
int SequenceGB::readGene( ifstream &ific ) {
  char * gene;
  char * note ;
  char * token ;
  char c;
  int fonction=0, i, nbblancs;
  char notation[80]="" ;
  streampos     position ;    /* position dans le fichier sequence */

  strncpy(temp,"\0",5);

  while (ific.eof()==0)
    {
      nbblancs=0;
      // Lire jusqu'au 1ier car. non blanc
      while( (c=ific.peek() )==' ')
	{
	  ific.get();
	  nbblancs++;
	}
      
      if (nbblancs > 5 )
	{
	  // Lire le qualifier
	  ific.getline(line,80);
	  position = ific.tellg();

	  if ( strstr(line, "/function=\"" ) ) 
	    {
	      fonction=1;
	    }
	  
	  
	  if ( (gene = strstr(line, "/gene=\"" )) ) 
	    {
	      gene+=7;
	      gene[strlen(gene)-1] = '\0';
	      if (strlen(gene) >= 14) {
		token = strtok(gene, " ,;:.") ;
		strcat(token, "\0") ;
		if (strlen(token) >= 14)  token[14] = '\0' ;
		strcpy(temp, token) ;
	      }
	      else
		strcpy(temp,gene);
	    }  // fin du gene
	  
	  if ( (note = strstr(line, "/note=\"" )) ) 
	    {
	      // on recupere le champ note
	      note+=7;
	      note[strlen(note)-1] = '\0';
	      // on recupere le 1er token de note, en esperant que c'est le nom
	      token = strtok(note, " ,;:.") ;
	      strcat(token, "\0") ;
	      if (strlen(token) >= 14)  token[14] = '\0' ;
	      strcpy(notation, token) ;
	    }  // fin de note

	  
	} // fin if (nbblancs > 5 )
      else
	{
	  // on n'est plus sur un qualifier
	  // remettre  les nbblancs blancs
	  //for (i=0; i < nbblancs; i++) {
	  //ific.putback(' ');
	  //}

	  // putback abandonne car probleme indetermin sur un exemple
	  ific.seekg(position, ios::beg);
	  break;
	}
    } // fin while (ific.eof()==0)

  // si pas de gene, on prend ce qu'il y a dans note
  if (strlen(temp) == 0 && strlen(notation) != 0)
    strcpy(temp, notation) ;
  return(fonction);

} /* fin readGene */

/*==========================================================================*/
/*      Fonction : place le ifstream au debut d'une nouvelle feature.       */
/*                 Fonction appelee lorsqu'un CDS est "trop complex"        */
/*==========================================================================*/
void SequenceGB::readEndFeatures( ifstream &ific ) {
  /*................. Variables internes ..............................*/
  char * gene;
  char c;
  int i, nbblancs;

  /*................. Algorithme .......................................*/
  /* on termine la ligne courante */
  ific.getline(line,200,'\n');

  while (ific.eof()==0)
    {
      nbblancs=0;
      // Lire jusqu'au 1ier car. non blanc
      while( (c=ific.peek() )==' ')
	{
	  ific.get();
	  nbblancs++;
	}
      
      if (nbblancs > 5 )
	{  
	  // Lire le qualifier
	  ific.getline(line,300,'\n');	  
	  if ( (gene = strstr(line, "/gene=\"" )) ) 
	    {
	      gene+=7;
	      gene[strlen(gene)-1] = '\0';
	      strcpy(temp,gene);
	      cout << "gene " << temp << endl;
	    }  // fin du gene
	} // fin if (nbblancs > 5 )
      else
	{
	  // on n'est plus sur un qualifier
	  // remettre  les nbblancs blancs
	  for (i=0; i < nbblancs; i++)
	    ific.putback(' ');
	  break;
	}
    } // fin while (ific.eof()==0)
} /* fin readEndFeatures */
