#ifndef SequenceGB_H
#define SequenceGB_H

#include <stdlib.h>
#include <iostream.h> 
#include <fstream.h>
#include <string.h>

#include <Sequence.h>
#include <Feature.h>
#include <CDS.h>
#include <rRNA.h>
#include <tRNA.h>
#include <mRNA.h>
#include <Repet.h>
#include <Promoter.h>
#include <Terminator.h>
#include <GraphicUnit.h>
#include <ctype.h>

class SequenceGB {
 private: 
  SequenceGFX * s ;
  char line[500];
  char temp[50];

  bool isGenBank( ifstream &ific );
  void readSpace( ifstream &ific );
  void readName( ifstream &ific );
  void readSize( ifstream &ific );
  void readFeatures( ifstream &ific );
  int readStartStop( ifstream &ific, int &sens , int &nintron, int *&startex, 
		     int *&stopex) ;
  int  readStart( ifstream &ific, int &sens, int &nintron );
  int  readStop ( ifstream &ific );
  int readGene( ifstream &ific );
  void readEndFeatures( ifstream &ific );
 public:
  SequenceGB( void );
  ~SequenceGB( void );
  void setSequence( SequenceGFX * );
  int readSequence( ifstream &ific );

};


#endif
