#include <SequenceGFX.h>
#include <stdlib.h>
#include "Plage.h"
#include "Promoter.h"
#include "Terminator.h"
#include "CDS.h"
#include "tRNA.h"
#include "rRNA.h"
#include "mRNA.h"
#include "Repet.h"
#include "SequenceGraph.h"


SequenceGFX::SequenceGFX ()
/* ........ Initialisation : .............................................. */
  : Sequence()
{}

void SequenceGFX::setAttributes(int _begin, int _end)
{
this->begin=_begin;
this->end=_end;
}


 Xaxe * SequenceGFX::getAxe(void)
{ return axe; }



SequenceGFX::~SequenceGFX( void ) {

  delete axe;
} /* fin SequenceGFX::~SequenceGFX */
 
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Fonction: Draw                                                      */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void SequenceGFX::Draw( IMAGE *& Im, SequenceGraph *& Sg, int irhom, int iseq, 
			int printF, int printCDS, int printmRNA, int printtRNA,
			int printrRNA, int printR, int printP, int dessinF, 
			int dessinCDS, int dessinmRNA, int dessintRNA, 
			int dessinrRNA, int dessinR, int dessinPl,int dessinPr,
			double seuil, ifstream &ific, ofstream &ofic, 
			int *ydessin, long pos_fic, int _nchaine, int ncpt) 
{
/*......................... Variables locales .............................*/
  char * Title ;           //titre de la sequence
  char *titre_c;           //titre des caracteristiques du fichier rhom
  char **couleurs;
  int  nlignes, trace_axe;
  int X,Y,  XStart=0, YStart=0,  Width=0, BpLine=0;
  int Bool, SousTitre,  Graduation, Decal;
  char **couleuretat;     //couleur des etats
  char *titrecolor;       //couleur du titre
  int titreSize = 10;     //taille du titre
  int centrage;           //boolean pour centrer ou non le titre
  int i;
  char **nomCouleur ;     // noms des couleurs disponibles

  this -> nchaine = _nchaine;
  Sg->getAttributes(XStart, YStart,  Width, BpLine);
  Sg->getAttG( Bool, SousTitre,  Graduation, Decal);

  //allocation pour couleuretat
  nomCouleur = new char*[MAXNCHAINE] ;
  nomCouleur[0] = "Red";
  nomCouleur[1]= "Blue2";
  nomCouleur[2]= "Green4";
  nomCouleur[3]= "Magenta4";
  nomCouleur[4] = "Cyan";
  nomCouleur[5]= "Magenta2";
  nomCouleur[6]= "LightSlateGrey";
  nomCouleur[7]= "Pink";
  nomCouleur[8]= "Black";
  nomCouleur[9]= "Yellow";
  
  //nomCouleur[5]= "Magenta2";
  //nomCouleur[6]= "gold";
  //nomCouleur[7]= "LightSlateGrey";
  //nomCouleur[8]= "Black";
  //nomCouleur[9]= "Pink";


  couleuretat = new char*[nchaine];
  for( i=0; i < nchaine; i++)
    {
      couleuretat[i] = new char[strlen(nomCouleur[i])+1];
      strcpy(couleuretat[i], nomCouleur[i]) ;
    }

  titrecolor = new char[10];
  titrecolor = "Black";

  // nbre de lignes a dessiner: 0 etant considr comme 1 ligne
  nlignes = int( (end - begin)/BpLine); 

  if (((end - begin) % BpLine) == 0)
    nlignes -=1;

/*.......................... Trace du titre ...............................*/
  // Si Bool == 0 Alors Afficher le titre de la sequence
  if ( Bool == 0 ) 
    {
      //ecriture du nom de la sequence
      Title = Sg->getTitre();
      centrage = 1;
      DrawTitre( Im, YStart, Title, Width, XStart, titrecolor, titreSize,
		 centrage);

      //ecriture du titre autre que la sequence
      if (irhom == 1 || iseq == 1)
	{
	  titre_c = Sg->getTitre_c();
	  centrage = 0;
	  DrawTitre( Im, YStart, titre_c, Width, XStart, titrecolor, titreSize,
		     centrage);
	} /* fin if (irhom == 1) */

      if (SousTitre != 0)
	YStart += SousTitre;
      //else
      //{
      //  YStart += ydessin[10];
      //  for(int i = 3; i < 7; i++)
      //   YStart += ydessin[i];
      //} /* fin else */
      //Sg->setYStart(YStart);    
    } // fin if ( Bool == 0 ) 
  YStart += ydessin[10];
  for(i = 3; i < 7; i++)
    YStart += ydessin[i];
  Sg->setYStart(YStart);

/*......................... dessin des axes ...............................*/
  this->axe = new Xaxe(XStart, YStart, Width, begin, end, nlignes, BpLine, 
		       Graduation, Decal);
  trace_axe = 1;
  this->axe->Draw(Im, trace_axe);
/*........................ dessin des Features .............................*/
  if ((printF !=0) || (printCDS !=0) || (printmRNA !=0) || (printtRNA !=0) || 
      (printrRNA !=0) || (printR !=0) || (dessinF !=0) || (dessinCDS !=0) ||
      (dessinmRNA !=0) || (dessintRNA !=0) || (dessinrRNA !=0) || (dessinR !=0))
    {
      featTmp = features;
      // Afficher tous les features
      for ( int i=0; i < nbfeat; i++ ) 
	{
	  
	  if ( (featTmp->Start < end) && (featTmp->Stop  > begin) ) 
	    {
	      if ( (printF !=0) && (strstr(featTmp->type,"Terminator") || 
				    (strstr(featTmp->type,"Promoter"))))
		featTmp->print();
	      if ( (printCDS !=0) && strstr(featTmp->type,"Cds"))
		featTmp->print();
	      if ( (printmRNA !=0) && strstr(featTmp->type,"mRNA"))
		featTmp->print();
	      if ( (printtRNA !=0) && strstr(featTmp->type,"tRNA"))
		featTmp->print();
	      if ( (printrRNA !=0) && strstr(featTmp->type,"rRNA"))
		featTmp->print();
	      if ( (printR !=0) && strstr(featTmp->type,"Repeat"))
		featTmp->print();
	      
	      /* Restreindre le feature quand il dborde de la portion de la seq voulue */
	      if ((featTmp->Stop > end) || (featTmp->Start < begin))
		{

		  if (featTmp->Stop > end)
		    featTmp->Stop=end;
		  if (featTmp->Start < begin)
		    featTmp->Start=begin;
		  featTmp->largeur = featTmp->Stop - featTmp->Start;
		  if (featTmp->largeur< 1)
		    {
		      cerr << endl << " Feature non representable:" << endl;
		      featTmp->print();
		      featTmp = featTmp->next;
		      continue;
		    }

		}

	      if ( (dessinF !=0) && 
		   (strstr(featTmp->type,"Terminator") || (strstr(featTmp->type,"Promoter"))))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
	      if ( (dessinCDS !=0) && strstr(featTmp->type,"Cds"))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
	      if ( (dessinmRNA !=0) && strstr(featTmp->type,"mRNA"))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
	      if ( (dessintRNA !=0) && strstr(featTmp->type,"tRNA"))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
	      if ( (dessinrRNA !=0) && strstr(featTmp->type,"rRNA"))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
	      if ( (dessinR !=0) && strstr(featTmp->type,"Repeat"))
		featTmp->Draw(Im, Sg, this->begin, this->end, axe );
       // Pourquoi CDS en majuscules, ici? Le type n'est jamais CDS mais Cds!

	    }
	  featTmp = featTmp->next;
	}
    } /* fin du trace des features */

//repositionnement dans le fichier 
 ific.seekg(pos_fic, ios::beg);
 Plage * myPlage;
 myPlage = NULL;

if ( (ific != NULL) &&
( (printP!=0) || (dessinPl !=0) || (ofic != NULL)))

  {
/*........................ Trace des plages ................................*/
    myPlage = new Plage( ydessin[7], ydessin[8], ydessin[6], ydessin[11]);
    // Lecture du fichier des plages et dessin au fur et a mesure

    if( myPlage->Draw(Im, Sg , this->begin, this->end, axe, ific, printP, 
		      dessinPl, ofic, nchaine, couleuretat) !=0)
      exit(1);
    couleurs= myPlage->Renvoie_couleur();
  } /* fin  Trace des plages */

 if (dessinPr != 0)
   {
/*..................... dessin des graphes des petats ......................*/
     //repositionnement dans le fichier rhom au niveau des petats
     ific.seekg(pos_fic, ios::beg);
	
     int Ecart = ydessin[4]+ydessin[5]+ydessin[6];
     Etat *Ptr_Etat;
     Ptr_Etat = new Etat(XStart, YStart, Width, begin, end, nlignes, BpLine,
			 Graduation, Decal, Ecart, ydessin[3], couleuretat, 
			 nchaine);
     Ptr_Etat -> Draw( Im, ific);
     //delete Ptr_Etat ;
   } /* fin  if dessinPr */
// } /* fin  Trace des plages */

/*.......................... Trace de la legende ...........................*/
// Determiner la position de la derniere ligne
//int line = Sg->WhichLine(this->end, this->begin);
     this->Legend(Im, nlignes, XStart, YStart, dessinF, dessinCDS, dessinmRNA, 
		  dessintRNA, dessinrRNA, dessinR, X, Y, ydessin, Width);
 
 if  ((ific != NULL) && ((dessinPl !=0) || (dessinPr !=0)))
   {
     myPlage->Legend(Im, XStart,Y, ncpt, nchaine, couleuretat, ydessin[7],
		     dessinPl, dessinPr, Width);
   }
 // trace de l'echelle
 X = XStart ;
 double lg_echelle ;  // taille en pixel de l'echelle
 char grad_c[15] ;  //graduation en char
 sprintf(grad_c, "%d bases",Sg->Graduation) ;

 if (Sg->Graduation < BpLine) {
   lg_echelle = Sg->Graduation * Width / BpLine ;
   sprintf(grad_c, "%d bases",Sg->Graduation) ;
 } /* fin if */
 else {
   lg_echelle = Width / 10 ;
   sprintf(grad_c, "%d bases", BpLine/10) ;
 } /* fin else */
 new Line(Im,X,Y,X+lg_echelle,Y, "Black") ;
 new Line(Im,X,Y-1,X,Y+1, "Black") ;
 new Line(Im,X+lg_echelle,Y-1, X+lg_echelle,Y+1, "Black") ;
 X += 15 + (int)(lg_echelle) ;
 new Text(Im, X,Y,grad_c, "Black",10);
 Y += 15 ;

 // Rajout d'une ligne blanche
 new Text(Im,XStart ,Y," ", "White",12);

/*.............. Desallocation ..........................*/
 delete[] couleuretat;
 if (myPlage != NULL) delete myPlage;
} /* fin SequenceGFX::Draw */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Fonction : Legend                                              */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void SequenceGFX::Legend( IMAGE *& Im, int line, int XStart, int YStart,
			  int dessinF, int dessinCDS, int dessinmRNA, 
			  int dessintRNA, int dessinrRNA, int dessinR, 
			  int &X, int &Y, int *ydessin, int Width)
{
  int Xsuiv;   // taille en pixel de l'element suivant de la legende

  X= XStart;
  Y = line * this->axe->decal + YStart;

  // Le dernier argument definit la fonte (12 ou 10)
  //  new Text(Im, X,Y,"legend :","Black",10);

 
  //Y+=this->axe->decal;
  //on place la legende 
  Y += ydessin[9];

  if  ((dessinF != 0) || (dessinCDS != 0) || (dessinmRNA != 0) || 
       (dessintRNA != 0) || (dessinrRNA != 0) || (dessinR != 0) )
    {

  //if (dessinF!=0)
  //{
      new Text(Im, X,Y,"Promoteur : ", "Black",10);
      Promoter *feat;
      feat = new Promoter("bidon", 1,2,1);
      X += (12*6);
      feat->simpleDraw(Im, X,(Y-4));
      X += (1*6);
      new Text(Im, X,Y,"(5'->3')", "Black",10);
      Promoter *feat2;
      feat2 = new Promoter("bidon", 1,2,-1);
      X += (10*6);
      feat2->simpleDraw(Im, X,(Y-4));
      X += (1*6);
      new Text(Im, X,Y,"(3'->5')", "Black",10);
      X += (10*6);

      Xsuiv = (14*6) + (1*6) + (10*6) + (1*6) + (8*6) ;
      if (X+Xsuiv-(4*6) > Width+XStart) {X= XStart; Y+=15;}
      new Text(Im, X,Y,"Terminateur : ", "Black",10);
      Terminator *featt;
      featt = new Terminator("bidon", 1,2,1);
      X += (14*6);
      featt->simpleDraw(Im, X,(Y-4));
      X += (1*6);
      new Text(Im, X,Y,"(5'->3')", "Black",10);
      Terminator *featt2;
      featt2 = new Terminator("bidon", 1,2,-1);
      X += (10*6);
      featt2->simpleDraw(Im, X,(Y-4));
      X += (1*6);
      new Text(Im, X,Y,"(3'->5')", "Black",10);

      // On va a la ligne pour la suite:
      X= XStart;
      Y+=15;
      //}

  //if (dessinCDS !=0)
  //{
      new Text(Im, X,Y,"CDS : ", "Black",10);
      CDS *cds;
      X += (8*6);
      cds = new CDS("", 1,2,1,1);
      cds->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);
      //}


      //if (dessinmRNA !=0)
      //{
      new Text(Im, X,Y,"ARNm : ", "Black",10);
      mRNA *mrna;
      mrna = new mRNA("", 1,2,1,1);
      X += (8*6);
      mrna->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);
      //}

      //if (dessintRNA !=0)
      //{
      new Text(Im, X,Y,"ARNt : ", "Black",10);
      tRNA *tRna;
      tRna = new tRNA("", 1,2,1,1);
      X += (8*6);
      tRna->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);
      //}

      //if (dessinrRNA !=0)
      //{   
      Xsuiv = (8*6) + 6 ;
      if (X+Xsuiv-(4*6) > Width+XStart) {X= XStart; Y+=15;}
      new Text(Im, X,Y,"ARNr : ", "Black",10);
      rRNA *rRna;
      rRna = new rRNA("", 1,2,1,1);
      X += (8*6);
      rRna->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);
      //}

      //if (dessinR !=0)
      //{
      Xsuiv = (14*6) + 6 ;
      if (X+Xsuiv-(4*6) > Width+XStart) {X= XStart; Y+=15;}
      new Text(Im, X,Y,"Repetitions : ", "Black",10);
      Repet *repet;
      repet = new Repet("", 1,2,1,1);
      X += (14*6);
      repet->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);
      //}

      //if ((dessinCDS!=0) || (dessinmRNA !=0)
      //|| (dessintRNA !=0) || (dessinrRNA !=0) || (dessinR !=0) )
      //{
      // on va a la ligne
      Y += 15;
      X= XStart;
      //CDS *cds;
      new Text(Im, X,Y,"Fonction : inconnue ", "Black",10);
      X += (20*6);
      cds = new CDS("", 1,2,1,0,"DimGrey");
      cds->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);

      new Text(Im, X,Y,"connue ", "Black",10);
      X += (7*6);
      cds = new CDS("", 1,2,1,1,"DimGrey");
      cds->simpleDraw(Im,X,Y,(X+6));
      X += (4*6);

      Xsuiv = (21*6) + 30 ;
      if (X+Xsuiv-(4*6) > Width+XStart) {X= XStart; Y+=15;}
      new Text(Im, X,Y,"Genes avec introns : ", "Black",10);
      X += (21*6);
      cds = new CDS("", 1,2,1,1,"DimGrey");
      int Xst[2] = {X, X+16} ;
      int Xsp[2] = {X+6, X+22} ;
      cds->simpleDrawIntron(Im,Xst,Y,Xsp,1);
      X += 30;
      Y += 15;
      //}
    } /* fin if */
} /* fin SequenceGFX::Legend */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Fonction : Draw titre                                          */
/*             dessine le titre de l'image gif                     */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void SequenceGFX::DrawTitre( IMAGE *& Im, int &YStart, char *Title, int Width,
			     int XStart, char *titrecolor, int titreSize,
			     int centrage)
{
  if (Title == NULL)
    {
      cerr << " Probleme dans SEQUENCE::Draw: pas de titre!!! " << endl;
      exit(1);
    } /* fin if (Title == NULL) */

  /*.......... variables locales ................*/
  int lgtitre = strlen(Title);        //longueur du titre
  //int largeurp = (Width - XStart);  // largeur disponible en nbre de pixels
  int largeurp = Width ;
  //int largeurp = Width - 4;
  int largeurc ;                      // largeur disponible en nbre de car.
  int pixcar;                         //nb de pixel par caractere
  int nblig = 0;
  char **tab_titre;
  int ilig;

  if (titreSize == 10)
    pixcar = 6;
  else
    pixcar = 8;

  largeurc = largeurp/pixcar;

  /*.......... dessin du titre ................*/
  if (lgtitre > largeurc)
    {
      decoupeChaine(Title, largeurc, tab_titre, nblig);
      for(ilig = 0; ilig < nblig; ilig++)
	{	
	  if (centrage != 0)
	    /* on centre le titre */
	    new Text(Im, XStart+largeurp/2-strlen(tab_titre[ilig])*pixcar/2, 
		     YStart, tab_titre[ilig], titrecolor, titreSize);
	  else
	    /* on ne centre pas le titre */
	    new Text(Im, XStart, YStart, tab_titre[ilig],titrecolor,titreSize);

	  YStart += 3 + titreSize;
	} /* fin for */

    }
   else
    {
      //if (centrage != 0)
	/* on centre le titre */
	new Text(Im, XStart + largeurp/2 - lgtitre*pixcar/2 , YStart, Title , 
		 titrecolor, titreSize);
	//else
	/* on ne centre pas le titre */
	//new Text(Im, XStart, YStart, Title, titrecolor, titreSize);

      YStart += 3 + titreSize;
    } /* fin else */
} /* fin DrawTitre() */

/*===========================================================================*/
/* Fonction : decoupeChaine                                                  */
/*            decoupe une chaine de caractere en plusieurs chaine de         */
/*            caractere de longueur lg et les range dans un char**           */
/*===========================================================================*/
void SequenceGFX::decoupeChaine(char * chaine, int lglig, char **&tab_chaine, 
				int &nblig)
{
/*................... Variables locales .....................................*/
  char *token;
  char *suiv;
  char *suivsuiv;
  char *ligne;
  char **tmp;
  int lgligne = 0;
  int nbligtmp;
  int i;

  ligne = new char[lglig+1];
  nblig = 0;
  nbligtmp = 2*strlen(chaine)/lglig;

  tmp = new char*[nbligtmp];
  for (i = 0; i < nbligtmp; i++)
    tmp[i] = new char[lglig+1];

/*......................... Algorithme .....................................*/
  token = strtok(chaine, " \n\r\t");
  suiv = strtok(NULL, " \n\r\t");
  suivsuiv = strtok(NULL, " \n\r\t");

  while (strlen(token) != 0)
    {
/*.............. cas ou on complete la ligne courante  ..............*/
      if ((strlen(token)+lgligne+1 < lglig && strcmp(suiv, ":") != 0) ||
	  (strcmp(suiv, ":") == 0 && strlen(token)+lgligne+
	   strlen(suivsuiv)+4 < lglig))
	{
	  if(lgligne != 0)
	    {
	      strcat(ligne, " ");
	      strcat(ligne, token);
	      lgligne = strlen(ligne);
	    } /* fin if ligne*/

	  else
	    {
	      strcat(ligne, token);
	      lgligne = strlen(ligne);
	    } /* fin else */
	} /* fin if strlen(token) */

/*.............. cas ou on commence une nouvelle ligne  ..............*/
      else if(strlen(token) < lglig)
	{
	  /* on copie la ligne courante dans tmp */
	  strcat(ligne, "\0");
	  strcpy(tmp[nblig], ligne);
	  strcpy(ligne, "\0");
	  nblig++;

	  /* et on commence une nouvelle ligne */
	  strcpy(ligne, token);
	  lgligne = strlen(ligne);
	} /* fin else if */

/*.................. cas ou le token est superieur a lglig ................*/
      else 
	{
	  int lglu = 0;
	  int lgreste = strlen(token);

	  while(lgreste > 0)
	    {
	      if(nblig == 0 && lgligne == 0)
		{
		  strncpy(ligne, token, lglig-1);
		  strcat(ligne, "-");
		  lgligne = strlen(ligne);
		  lgreste = lgreste - (lglig-1);
		  lglu += lglig-1 ;
		}

	      else 
		{
		  strcat(ligne, "\0");
		  strcpy(tmp[nblig], ligne);
		  strcpy(ligne, "\0");
		  delete[] ligne;
		  ligne = new char[lglig+1];
		  lgligne = 0;
		  if (lgreste > lglig)
		    {
		      strncpy(ligne, token+lglu, lglig-1);
		      strcat(ligne, "-");
		      lgligne = strlen(ligne);
		      lgreste = lgreste - (lglig-1);
		      lglu += lglig-1;
		    } /* fin if */
		  else
		    {
		      strncpy(ligne, token+lglu, lgreste);
		      lgligne = strlen(ligne);
		      lgreste = 0;
		    } /* fin else */

		  nblig++;
		} /* fin else (nblig == 0) */
	   	
	    } /* fin while */
	} /* fin else */

      token = suiv;
      suiv = suivsuiv;
      if (strlen(suivsuiv) != 0)
	{
	  suivsuiv = strtok(NULL, " \n\r\t");
	  if (suivsuiv == NULL)
	    {
	      suivsuiv = new char[1];
	      strcpy(suivsuiv, "");
	    } /* fin if */
	} /* fin if suivsuiv */
    } /* fin while (token != NULL) */

/*.................. copie de la derniere ligne ................*/
  strcat(ligne, "\0");
  strcpy(tmp[nblig], ligne);
  delete ligne;
  nblig++;

/*.................. copie de tmp vers tab_chaine ................*/
  tab_chaine = new char*[nblig];
  for(i = 0; i < nblig; i++)
    {
      tab_chaine[i] = new char[strlen(tmp[i])+1];
      strcpy(tab_chaine[i], tmp[i]);
      delete[] tmp[i];
    } /* fait i */
  delete[] tmp;
} /* fin decoupeChaine() */
