/* +++++++++++++++++++++++++++++++++++++++++++++++++
 Programme principal pour un trace graphique des sequences d'ADN,
des annotations GENBANK, des plages d'ADNet des probabilites associes
otenues avec le logiciel R'HOM

Bouvier: fevrier 1999
Lepage : janvier 2000

Fonction:
--------
Cre une image en format GIF reprsentant une squence d'ADN, avec:
(l'une des deux options -seq et -rhom est obligatoire)

1) s'il y a l'option -seq:

- des symboles  ( PolyLine bleu) pour les Promoteurs:
 "promoter",  "-10_signal",  "-35_signal"
ATTENTION: ne sont pas inclus les sig_peptide, CATT_signal, GC_signal, misc_signal, polyA_signal, TATA_signal
- des symboles (Circle rouge) pour les Terminateurs:
terminator 
- des flches orientes pour les CDS :
tRNA: vertes claires
mRNA: gris bleu 
rRNA: jaune or
squences rptes (LTR, repeat_, satellite): rose
Les autres CDS: violet

Flches pleines pour ceux de fonction connue, vides pour les autres.
Les couleurs disponibles, ainsi que leur nom sont prsents dans le fichier 
echantillon.gif

2) S'il y a l'option -rhom

Les plages d'tats dtermines par R'HOM sont reprsentes de deux manires
au dessus de la squence :
- une reprsentation linaire, o toutes les plages sont dessines  la mme 
hauteur,
- une reprsentation en escalier, o chaque rgion est dessine  une auteur 
diffrente.
Elles sont dessines si l'option dessinPl = 1 dans le fichier de configuration
(1 par defaut).

Les probabilits sont dessines si l'option dessinPr = 1 dans le fichier de 
configuration (1 par defaut). Elles sont reprsentes au dessus des plages 
si celles-ci sont dessines, au dessus des plages sinon.

3) S'il y a l'option -plage
Un fichier des plages est cre. Il contient pour chacune des plages trouves :
- les indices de dbut et de fin de la plage,
- les petat minimum et maximum de la plage.

 Arguments obligatoires:
------------------------
 -gif <fichier-resultat-en-sortie-format-gif>
 Arguments facultatifs:
----------------------
 -conf[ig] <fichier-de-configuration-en entree>
 -rhom < fichier-de-sortie-de rhom>
 -seq <fichier-seq-format-genbank>
 -plage <fichier-des-plages-en-sorties>

Il faut au moins un argument parmi  -rhom, -seq

4)  S'il y a l'option -conf
# Fichier de configuration: (-conf)
# ------------------------
# Celui-ci est facultatif
# Il peut contenir dans n'importe quel ordre les mots-cles suivants, 
# suivis de la valeur souhaite:
# (entre parenthses, est indique la valeur par dfaut)

# start: indice de la 1iere base a considerer (celle-ci incluse) (1)
# stop:  indice de la dernire base a considerer (celle-ci incluse) (la dernire)
# bpl:   nombre de bases par ligne (10000)
# nlig:  nombre de lignes (s'il y a bpl, c'est nlig qui prime et bpl est ignore)
#        (determine en fonction de bpl)
# width: largeur de la page  (en pixels) (par defaut : 400, format A4)
# dessinF,  dessinmRNA, dessintRNA, dessinrRNA, dessinR, dessinCDS, dessinPl,
dessinPr: 
# 0 si on ne veut pas reprsenter, respectivement:
# les Promoter et Terminator, les RNA , les Repeat, les autres CDS, les plages,
les probabilits.
# (par defaut, 1)
# (Rque: dessinPl a sa justification car on peut vouloir imprimer ou sauvegarder
# les plages sans les dessiner)

Autres mots-cles , d'utilisation certainement moins frequente:
(cf le fichier const.h pour les valeurs par dfaut)

#  printF, printmRNA, printtRNA, printrRNA, printR, printCDS, printP,
#  printO
# 0 si on ne veut pas afficher, respectivement: (!=0 ,sinon)
# les Promoter et Terminator, les RNA , les Repeat, les autres CDS, les plages,
# notitle: 1 si on ne veut pas de titre sur la figure, 0 sinon (0)
# title: le titre voulu (sur une ligne, la meme que "title" ou la suivante)
#        (ignor si notitle=1) (par defaut, le nom du locus ou le titre lu sur le
#          fichier R'HOM)
# ut:    hauteur (en pixels) sous le titre, quand il y  a un titre
#        par defaut, la meme hauteur qu'il y a entre 2 axes (voir: ys)
# grad:  echelle de graduation des bases
# ys:    hauteur entre 2 lignes (en pixels) 
# mx:    marge a droite
# my:    marge en haut

# Les commentaires sur ce fichier:
# Sont considrs comme commentaires ce qui est introduit par n'importe quel caractre
# non-alphanum. jusqu'au reste de la ligne
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <stdlib.h>
#include <iostream.h> 
#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <iomanip.h>
#include <math.h>
#include <unistd.h>

// Fichier a inclure pour gerer les Sequences et les Images.
#include <Sequence.h>
#include <SequenceGB.h>
#include <Image.h>


// Fichier a inclure pour specifier des valeurs min et max 
// intervenant dans les controles du fichier d'entre
#include <const.h>

// Les mots-cles des options entieres
  // sur le fichier de config (dans l'ordre):
#define noptions 27
char *motscle[noptions]={
"start", "stop", "bpl", "nlig","notitle","ut",
"grad","ys","mx","my","width",
"printF", "printCDS", 
"printmRNA", "printtRNA", "printrRNA", "printR",
"printP",
 "dessinF", "dessinCDS",
"dessinmRNA", "dessintRNA", "dessinrRNA", "dessinR",
 "dessinPl", "dessinPr", "title"};

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Programme principal                                          */
/*                                                              */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

int main (int argc, char* argv[], char*[] ) 
{
/*...................... Variables locales .....................*/
  int i,    num_arg=1 ;
  char * giffile=NULL, *conffile=NULL, *rhomfile=NULL, *outfile=NULL,
    *seqfile=NULL;
  int lgseq;
  // Les valeurs par defaut sont dans const.h
  // En ce qui concerne l'ordre et la signification des options,
  // voir le tableau motscle ci-dessus

  int options[noptions]={
    1, 0, DEFBPL, DEFNLIG, 0, 0, 0,
    0, DEFMX, DEFMY, DEFWIDTH, 
    0,0,0,0,0,0,0,
    1,1,1,1,1,1,1,1};

  int y2lig=0 ;       // hauteur entre 2 lignes
                      // depend des options et de ydessin

  int ydessin[12]={0,0,0,0,0,0,0,0,0,0,0,0};
  //tableau des hauteurs des objets a dessiner
  //ydessin[0], hauteur reservee aux features 
  //ydessin[1], hauteur entre features et sequence
  //ydessin[2], hauteur entre features et graphe des etats
  //ydessin[3], hauteur du graphe des etats
  //ydessin[4], hauteur entre graphe des etats et les plages
  //ydessin[5], hauteur des plages
  //ydessin[6], hauteur entre les plages et la sequence
  //ydessin[7], epaisseur des plages
  //ydessin[8], hauteur entre les plages
  //ydessin[9], hauteur entre le dernier objet dessine et la legende
  //ydessin[10], hauteur entre le titre et le premier objet dessine
  //ydessin[11], hauteur entre les representations lineaires et en escalier des
               //plages

  int ititle=0; // indicateur de prsence d'un titre
  int irhom=0; // indicateur de prsence d'un fichier rhom
  int iout=0;// indicateur de prsence d'un fichier des plages en sortie
  int iseq=0; // indicateur de prsence d'un fichier de sequence

  double  seuil=0;// seuil des proba des plages
  long pos_fic; //position dans le fichier rhomfile
  char *title = NULL; // titre de la sequence

  // Les attributs lus sur le fichier des sorties de R'HOM
  int type;
  int nmodal;
  int model;
  int nchaine = 0; //nombre de regimes
  int algo;
  char version;
  int ncpt;        //nombre de regimes autocomplementaires
  int typefic;
  int taille=0;
  char *titre;   //titre de la sequence
  char *titre_c=NULL;  //carateristiques des sorties rhom : algo, modele...

  int size; // lgueur de la seq sur le fichier genbank

/* ......... Declaration des fonctions appeles ...................... */
  int LireDebRhom(ifstream &ific, char *titre, int &taille);
  int LitDebut(ifstream &rhomfic,  int &type, int &nmodal,int &model,
	       int &nchaine, int &algo, char &version, int &ncpt,int &typefic);
  int LitDebutPetat(ifstream &rhomfic, int debut, int nchaine) ;
  void Printoptions(int *options, double seuil);
  int LireConfig(ifstream &ific, int *options, int&ititle, double &seuil, 
		 char *title, int *ydessin);
  int VerifConfig(int *options, double seuil, int ititle, char* title);
  int CalculNlig(int lgseq , int bpl);
  int CalculBpl(int lgseq , int nlig);
  void erreur(char *);
  void initYdessin(int *ydessin, int nchaine, int *options, int iseq, int irhom);
  void getTitre_c(int type, int nmodal, int model, int nchaine, int algo,
		  char *&titre_c, int *options, int iseq, int irhom);
/* ........ Decodage des arguments : ...................................... */
   while (num_arg < argc)
   {
      if ((strcmp (argv[num_arg], "-gif") == 0) && (num_arg + 1 < argc))
      {
       num_arg++ ;
       giffile = argv[num_arg] ;
       num_arg++ ;
       continue;
      }  /* fin alors */

      if ((strncmp (argv[num_arg], "-conf", 5) == 0) && (num_arg + 1 < argc))
         {
          num_arg++ ;
          conffile = argv[num_arg] ;
          num_arg++ ;
          continue;
         }  /* fin alors */

      if ((strcmp (argv[num_arg], "-rhom") == 0) && (num_arg + 1 < argc))
         {
          num_arg++ ;
          rhomfile = argv[num_arg] ;
          irhom = 1;
          num_arg++ ;
          continue;
         }  /* fin alors */

      if ((strcmp (argv[num_arg], "-plage") == 0) && (num_arg + 1 < argc))
	      {
		 num_arg++ ;
		 outfile = argv[num_arg] ;
		 iout=1;
		 num_arg++ ;
                 continue;
	       }  

      if ((strcmp (argv[num_arg], "-seq") == 0) && (num_arg + 1 < argc))
		   {
		     num_arg++ ;
		     seqfile = argv[num_arg] ;
		     iseq=1;
		     num_arg++ ;
                     continue;
		   }

      erreur(argv[0]);
   } /* fin while */


  if (giffile==NULL)
    {
      cerr << "Le fichier de sortie de l'image est obligatoire (argument -gif)" 
	   << endl << endl;
      erreur(argv[0]);
    } /* fin (giffile==NULL) */

  if ((irhom==0) && (iseq==0))
    {
      cerr << "L'une au moins des 2 options -seq ou -rhom est obligatoire" << endl << endl;
      erreur(argv[0]);
    }

  /* Ouverture du fichier des sorties de R'HOM */
  /* ----------------------------------------- */
   ifstream rhomfic (rhomfile);


   if (!rhomfic && (irhom ==1))
     {
       cerr << endl << "Lecture du fichier R'HOM "
	    << rhomfile
	    << " impossible" << endl;
       exit(1);
     }

   if (irhom !=0)
     {
       /*... Lecture du debut du fichier RHOM: titre et taille ...*/
       titre = new char[301];
       if (LireDebRhom(rhomfic,titre, taille)!=0)
	 {
	   cerr << endl << "Pas de titre ou de taille sur le fichier R'HOM,"
		<< rhomfile << endl;
	   exit(1);
	 }

       /*... Lecture des caracteristiques utilisees dans l'algorhitme ...*/
       if (LitDebut(rhomfic, type, nmodal, model, nchaine, algo,
		    version, ncpt, typefic) !=0)
	 {
	   cerr << "Plage::Draw: Erreur en lisant l'en-tte du fichier des sorties de R'HOM "
		<< endl;
	   return(1);
	 }
       pos_fic = rhomfic.tellg();

     } /* fin (irhom !=0) */


   /* Initialisation de la sequence */
   /* ----------------------------- */

   // Creation de l'image temporaire en memoire.
   IMAGE * myImg = new IMAGE;

   // Initialisation de la sequence.

   SequenceGFX * seq = new SequenceGFX();
   
   // Object charge de la lecture de la sequence
   SequenceGB seqReader;

   // Dire a l'object "lecture" quel object Sequence il doit remplir.
   //  seqReader.setSequence( &seq );
   seqReader.setSequence( seq );

   // Lecture du fichier sequence et remplissage de l'object "seq"
   // -----------------------------------------------------------
   if (iseq !=0)
     {
       /* Ouverture du fichier sequence*/
       ifstream seqfic (seqfile);


       if (!seqfic && (iseq ==1))
	 {
	   cerr << endl << "Lecture du fichier squence "
		<< seqfile
		<< " impossible" << endl;
	   exit(1);
	 }
       if (seqReader.readSequence(seqfic )!=0)
	 {
	cerr << "Lecture du fichier squence "
	     << seqfile
	     << " impossible" << endl;
	exit(1);
	 }
       if ( (taille !=0) && ( (size=seq->getSize()) != taille))
	 {
	   cerr << "Remarque: la longueur de la squence est "
		<< size
		<< " sur le fichier " << seqfile << endl
		<< " et " 
		<< taille 
		<< " sur le fichier -rhom" << endl << endl;
	 }
       
       title = new char[strlen(seq->getLocus())+17];
       strcpy(title, "");
       title = strcat(seq->getLocus(), " Physical Map.\0");
       
     } /* fin iseq !=0 */
   else
     {
       // Quand il n'y a pas de fichier GenBank, on prend la taille et le titre
       // sur le fichier RHOM
       seq->setSize(taille);
       title = titre;
     }


   /* Determination de la config par defaut  
      ( a faire apres avoir lu la taille de la seq)*/
   /* -------------------------------------- */

   options[1]= seq->getSize(); // indice de la derniere base a partir de 1, celle-ci comprise
   /* Fin de determination de la config par defaut   */


 
   /* Lecture du fichier de config */
   /* ---------------------------- */
   if (conffile != NULL)
     {
       ifstream ific (conffile);
       
       if (!ific)
	 {
	   cerr << "Lecture du fichier de configuration "
		<< conffile
		<< " impossible" << endl;
	   exit (1) ;
	 }
       else
	 {
	   if( LireConfig(ific,  options, ititle, seuil, title, ydessin) !=0)
	     exit(1) ;
	   if( LitDebutPetat(rhomfic, options[0], nchaine) != 0) 
	     exit(1) ;
	   pos_fic = rhomfic.tellg();
	 } /* fin else  if (!ific) */
     } /* fin conffile != NULL */
   /* Fin lecture du fichier de configuration */

   if (irhom == 1 || iseq == 1)
     getTitre_c(type, nmodal, model, nchaine, algo, titre_c, options, iseq, 
		irhom);

   /*... etablir la hauteur entre 2 lignes de la sequence .....*/
   initYdessin(ydessin, nchaine, options, iseq, irhom);
   y2lig += options[7] ;
   for(i = 0 ; i < 9 ; i++ )
     {
       y2lig += ydessin[i];
     } /* fin for i */
   
   lgseq = options[1]-options[0]+1;
   

   /* calcul du bpl en fonction de nlig quand l'utilisateur a precise une nlig */
   if (options[3] != DEFNLIG)
     {
       int nouvbpl = CalculBpl( lgseq , options[3]);
       if (options[2] != DEFBPL)
	 {
	   cerr << endl
		<< " Remarque: la valeur de bpl indique ("
		<< options[2]
		<< ") est change en fonction de nlig ("
		<< options[3] << ")" << endl
		<< "bpl= " <<  nouvbpl << endl;
	 }

       options[2]= nouvbpl;
     }  /* fin (nlig != DEFNLIG) */

   else
     {
       /* L'utilisateur n'a pas indiqu de nlig 
	  on  calcule nlig en fction du bpl qu'il a mis, ou de celui par defaut
	  sauf si celui-ci dpasse la longueur de la sequence */
       
       if (options[2] <= lgseq)
	 {
	   /* calcul de nlig en fonction de bpl */
	   options[3]= CalculNlig( lgseq , options[2]);
	 }
       else
	 {

	   if (options[2] != DEFBPL)
	     {
	       cerr << endl
		    << " Remarque: la valeur de bpl ("
		    << options[2]
		    << ") tant suprieure  la longueur de la squence ("
		    << lgseq
		    <<"), on la fixe  celle-ci"
		    << endl << endl;
	     }
	   options[3]=1; // nlig
	   options[2]= CalculBpl( lgseq , options[3]);
	   
	 }
     }

   if (options[3] > MAXNLIG)
     {
       cerr << endl
	    << " Remarque: la valeur de nlig (" << options[3]
	    << ")" 
	    << " tant suprieure au maximum (" << MAXNLIG;
       options[3]= MAXNLIG; // nlig
       options[2]= CalculBpl( lgseq , options[3]);
       cerr << ") on la fixe  " <<  options[3]
	    << " et bpl  " << options[2] << endl << endl;
     }

   /* Calcul de grad en fonction de bpl, quand aucun grad donn */
   if (options[6]==0)
     {
       options[6]= int(options[2]/10);
       cerr << " Remarque: par dfaut, la graduation des axes est bpl/10, soit: "
	    << options[6]
	    << endl;
     }

   if ( VerifConfig(options, seuil, ititle, title) !=0)
     {
       cerr << endl
	    <<" Erreur dans le fichier de configuration." << endl << endl;
       exit(1);
     }

   /* Verification de out */
   if ((irhom==0) && (iout==1))
     {
       cerr << endl << "Le fichier -plage " <<
	 outfile << " est ignor car il n'y a pas de fichier -rhom :"
	    << endl
	    << " on ne peut pas calculer des plages d'tat."
	    << endl;
       outfile=NULL;
       iout=0;
     }

   /* Ouverture du fichier des sorties des plages */
      /* ----------------------------------------- */
   ofstream outfic (outfile);
   
   if (!outfic && (iout ==1))
     {
       cerr << endl << "Ouverture du fichier de sortie des plages  "
	    << outfile
	    << " impossible" << endl;
       exit(1);
     }
   if (outfile != NULL && iout ==1)
     {
       outfic << titre << endl << titre_c << endl << endl;
     } /* fin if */
/*
REMARQUE: on ne peut pas creer l'objet Plage
dans le main, car sinon, il y a bouclage dans les fichiers
include de Sequence.h et Plage.h,
C'est Sequence::Draw qui le creera 
*/


   if (irhom ==0)
     {
       //Pas de plages possibles: printP,dessinPl,dessinPr
       options[17]=options[24]=options[25]=0;
     }

   if (iseq==0)
     {
       // pas de features 
       // printF, printCDS, printmRNA, printtRNA, printrRNA, printR
       options[11]=options[12]=options[13]=options[14]=options[15]=options[16]=0;
       // dessinF, dessinCDS,dessinmRNA, dessintRNA, dessinrRNA, dessinR
       options[18]=options[19]=options[20]=options[21]=options[22]=options[23]=0;
     }

   // Printoptions(options, seuil);
   // Mise-a-jour du debut et fin de la sequence a considerer
   seq->setAttributes(options[0], options[1]);

   // Creation des options graphiques
   SequenceGraph * Sg = new SequenceGraph(options[8], options[9], options[10], 
					  options[2], options[4], options[5], 
					  options[6], y2lig, title, titre_c);

   // cout << endl << endl << "*** Cration de l'image temporaire " << endl << endl;
   // Creation de l'image temporaire

   seq->Draw(myImg, Sg, irhom, iseq, options[11], options[12], options[13],
	     options[14], options[15], options[16], options[17], 
	     options[18], options[19], options[20], options[21], 
	     options[22], options[23], options[24], options[25],
	     seuil, rhomfic, outfic, ydessin, pos_fic, nchaine, ncpt);

   cout << endl
	<< "*** Cration de l'image rsultat au format GIF:"
	<< " fichier " << giffile << endl;

  
   // Creation de l'image resultat au format GIF
   myImg->Gif(giffile);

   //cout << "*** Affichage de l'image cre ***" << endl;
   //char xv[100]="xv ";
   //strcat(xv, giffile);
   //strcat(xv, "&");
   //system(xv);
   //delete(myImg);
   cout << endl;
  
   cout << "*** Fin d'excution" << endl << endl;

} /* fin du main */

/* ------------------------------------------------------------
Ecrit les options de  configuration
--------------------------------------------------------------*/
void Printoptions(int *options, double seuil)
{
  cout << endl  << "Options de configuration " << endl 
       << " -----------------------" << endl << endl;
for (int i=0; i<noptions; i++)
  {
    cout << setw(15) << motscle[i]
	 << " " << options[i] << endl;
  }
cout << setw(8) << " seuil " 
     << seuil  << endl;
} /* fin Printoptions */


/* ------------------------------------------------------------
Verifie la coherence du fichier de config
--------------------------------------------------------------*/
int VerifConfig(int *options, double seuil, int ititle, char* title)
{

if (options[0] <= 0)   
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " start doit tre suprieur ou gal  0 " << endl;
    return(1);
  }

if (options[1] < (options[0]+2)) 
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " stop ("
	 << options[1] << ") doit tre suprieur ou gal  (start+2), ( "
	 << (options[0]+2) 
	  << ")" << endl;
    return(1);
  }

if ( (options[2] % 100) !=0)
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " bpl (" 
	 << options[2] << ") doit etre multiple de 100 " << endl;
    return(1);
  }

if ( (options[3] <= 0) || (options[3] > MAXNLIG))   
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " nlig ("
	 << options[3] 
	 << ") doit tre suprieur  0 et infrieur  "
	 << MAXNLIG << endl;
  return(1);
  }

if ( (options[4] !=0) && (options[4] !=1))
  {
  cerr << endl << " notitle doit tre  0 ou 1 " << endl;
  return(1);
  }

if ( (options[4]==0) && (options[5]!=0) &&
       ( (options[5] < MINUT) || (options[5] > MAXUT)))
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " ut ("
	 << options[5]
	 << ") doit tre suprieur   "
	 << MINUT 
	 << " et infrieur  "
	 << MAXUT << endl;
  return(1);
  }

if ( (options[8] <= MINMX) || (options[8] > MAXMX))   
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " mx ("
	 << options[8] 
	 << ") doit tre suprieur  "
	 << MINMX
	 << " et infrieur  "
	 << MAXMX << endl;
  return(1);
  }

if ( (options[9] <= 0) || (options[9] > MAXMY))   
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " my ("
	 << options[9] 
	 << ") doit tre suprieur  0 et infrieur  "
	 << MAXMY << endl;
  return(1);
  }

if ( (options[10] > 1200))   
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " width ("
	 << options[10] 
	 << ") doit tre infrieur  1200."
	 << endl;
    cerr << "(Pour crer des images plus larges, modifiez dans le fichier "
	 << "'Text.h' la taille de la variable 'text' : "
	 << "taille max = (width max) / 6 )" << endl ;
  return(1);
  }

if (options[2] <= options[6])
  {
    cerr << endl << "Remarque: " 
	 << " grad ("
	 << options[6]
	 << ") est suprieur  bpl (" 
	 << options[2] << endl ;
	 //"), on le fixe  bpl/10, soit: " 
	 //<< int(options[2]/10)  << endl;
	 //options[6]= int(options[2]/10);
  }


/* si pas de titre ou titre par defaut, il faut une limite inf a width
si on donne un titre , il n'en faut pas! */

if ((options[4]==1) || (ititle==0))
  {
  if (options[10]<MINWIDTH) 
    {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << " width ("
	 << options[10]
	 << ") ne peut tre infrieure  200 quand aucun titre n'est donn." 
	 << endl;
    return(1);
    }
  }

  if ( (options[7] < MINYS) || (options[7] > MAXYS))
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << "  ys ("
	 << options[7]
	 << ") doit tre suprieur ou gal  "
	 << MINYS
	 << " et infrieur  " 
	 << MAXYS << endl;
    return(1);
  }

  if ( (seuil < 0) || (seuil > 1))
  {
    cerr << endl << " Erreur sur le fichier de configuration:" << endl;
    cerr << "  seuil ("
	 << seuil
	 << ") doit tre suprieur ou gal  0  et infrieur  1 " 
          << endl;
    return(1);
  }


if ( (options[4] !=0) && (ititle ==1))
  {
    cerr << endl << "Remarque: notitle tant fix  1, le titre:"
	 << endl
	 << title  << endl
	 << " est ignor. " << endl;
  }

return(0);
} /* fin VerifConfig */

/* ------------------------------------------
Calcul de nlig en fonction de bpl
--------------------------------------------- */
int CalculNlig(int lgseq , int bpl)
{
int nlig;
div_t d;

  if (bpl > lgseq)
   bpl=lgseq;
  d = div( lgseq , bpl);
  if (d.rem != 0)
     nlig = d.quot+1;
  else
    nlig = d.quot;
return(nlig);
} /* fin CalculNlig */

/* ------------------------------------------
Calcul de bpl en fonction de nlig
--------------------------------------------- */

int CalculBpl(int lgseq , int nlig)
{
int bpl;
div_t d, q;

if (nlig==0)
  nlig=1;

  d = div( lgseq , nlig);
  q = div(d.quot, 100);
  if (q.rem != 0)
    {
     bpl = (q.quot+1) * 100 ;
    }
  else
    bpl=  d.quot;
  if (d.rem >0)
     {
      bpl = bpl+100;
     }

return(bpl);
} /* fin CalculBpl */


/* ------------------------------------------
Lecture du titre et de la taille de la seq sur le fichier RHOM
--------------------------------------------- */

int LireDebRhom(ifstream &ific, char *titre, int &taille)
{
  /*........ variables locales ...........*/
  int i=0;
  char c;

  /*.......... lecture du titre ..........*/
 while (!ific.eof() && ific.get(c) && (c != '#'))
   {
     titre[i++]=c;
   }
 titre[i] = '\0';

 if (ific.eof())
    return(1);

 ific >> taille;
 if (ific.eof())
   return(1);
 return(0);
} /* fin LireDeb */

/* ------------------------------------------
Lecture du fichier de config
--------------------------------------------- */
int LireConfig(ifstream &ific, int *options, int &ititle, double &seuil,
	       char *title, int *ydessin)
{
  char nom[132],  c ;
  int i;
  int trouve;
  int titrepred=0; 
  double valeurdp=0;
  char tmp[101] ;
  int badmot=0 ;
  int badvaleur=0 ;

  while(ific.eof () ==0)
    {
      ific >> nom  ;
      if (isalpha(nom[0]))
	{
	  // ce n'est pas un commentaire
	  trouve = 0;
	  if ( strcmp(nom, "title")==0)
	    {
	      while (ific.get(c) && isspace(c))
		{;}
	      ific.putback(c);
	      ific.getline(title, TITREMAX);
	      trouve=1;
	      ititle =1;
	      titrepred=1;
	    } // fin title

	  if ( (titrepred !=1)){
	    ific.getline(tmp, 100, '\n') ;
	    valeurdp = atoi(tmp) ;
	    //ific >> valeurdp ;
	  }
	  titrepred=0;
	  
	  if(strcmp(nom, "start") == 0)
	    {
	      if (valeurdp >= options[0] && valeurdp <= options[1]) 
		{
		  options[0]= int ( valeurdp);
		} /* fin if valeurdp */
	      else {
		cerr << " start doit etre compris entre les bornes " 
		     << options[0] << " et " << options[1] << endl;
		badvaleur = 1 ;
	      } /* fin else */
	      trouve=1;
	    } /* fin if start */

	  else if(strcmp(nom, "stop") == 0)
	    {
	      if (valeurdp >= options[0] && valeurdp <= options[1]) 
		{
		  options[1]= int ( valeurdp);
		} /* fin if valeurdp */
	      else {
		cerr << " stop doit etre compris entre les bornes " 
		     << options[0] << " et " << options[1] << endl;
		badvaleur = 1 ;
	      } /* fin else */
	      trouve=1;
	    } /* fin if stop */

	  else
	    {
	      for (i=0 ; i<noptions; i++)
		{
		  if ( strcmp(nom, motscle[i]) == 0)
		    {
		      options[i]= int ( valeurdp);
		      trouve=1;
		    } /* fin if strcmp */
		} /* fin for i */
	    } /* fin else de pas seuil ni dessinPr*/
	
	  if (trouve == 0 )
	    {
	      cerr << " Le mot " << nom 
		   << " n'est pas reconnu sur le fichier de configuration " 
		   << endl;
	      badmot = 1 ;
	      break ;
	    } /* fin if (trouve==0) */
	} /* fin (isalpha(nom[0])) */
      else
	{
	  while ( ific.get(c) && (c !='\n'))
	    {
	    }
	} /* fin du comment */


    } /* fin while(ific.eof () ==0) */

  if (badmot == 1) {
    cerr << " Erreur sur le fichier de configuration. " << endl;
    cerr << endl << "Liste des mots reconnus: " << endl << endl;
    for (i=0; i<noptions; i++)
      {
	cerr <<  motscle[i] << endl;
      }
    return(1);
  }
  if (badvaleur == 1) {
    cerr << " Erreur sur le fichier de configuration. " << endl;
    return(1);
  }
  return(0);

} /* fin LireConfig */

/* ------------------------------------------
Ecrire la syntaxe et arreter
--------------------------------------------- */
void erreur(char * cde)
{
	   cerr << "Usage : " << cde
		<< " -gif <gif-filename> [-seq <GenBank-file>] "
		<< " [-conf[ig] <config-filename>] "
		<<" [-rhom <rhom-filename> -plage <out-filename>]"
		<< endl;
exit(1);

} /* fin erreur */


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* lit le debut du fichier des sorties principales de R'HOM,          */
/* a partir du type inclus                                            */
/* jusqu'aux 1eres valeurs des petats                                 */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

int LitDebut( ifstream &ific, int &type, int &nmodal, int &model, 
	      int &nchaine, int &algo, char &version, int &ncpt, int &typefic)
{
  /*....... variables locales ...............*/
  int niter ;
  char tmp[8] ; //tampon contenant soit version soit niter

  /*.......... lecture des caracteristiques ............*/
  ific  >> type;
  //cout << " Type de codage des bases: " << type << endl;
  ific >> nmodal;
  //cout << " Nombre de modalits des bases: " << nmodal << endl;
  ific >> model;
  //cout << " Ordre de la chane de Markov du modle: " << model << endl;
  ific >> nchaine ;
  //cout << " Nombre de modalits des tats cachs: " <<
  //      nchaine  << endl;

  ific >> algo ;
  if ((algo < 0) || (algo > 5))
    {
      cerr << "L'algorithme " 
	   << algo << " lu sur le fichier est incorrect!"
	   << endl;
      return(1);
    }
  ific >> tmp ;
  if (isalpha(tmp[0]))
    {
      // fichier recent : version = A ou N
      version = tmp[0] ;
      ific >> ncpt ;
      ific >> niter ;
    } /* fin if */
  else 
    {
      // fichier ancien : pas de version ni de ncpt
      version = 'N' ;
      ncpt = 0;
      niter = atoi(tmp) ;
    } /* fin else */

  ific >> typefic ;
  if (typefic < 0)
    {
      cerr << "Le fichier doit contenir les sorties principales de R'HOM"
	   << endl;
      return(1);
    }
  else if (typefic > 0) 
    {
      //fichier .iter
      double logvrais ;
      ific >> logvrais ;
    } /* fin else */

  /* cas des algorithmes non deterministes */
  if (algo !=0 && typefic == 0)
    {
      int deb_cumul_iter ;
      ific >> deb_cumul_iter ;
      //    cout << " Itration de dbut de cumul: " << deb_cumul_iter << endl;
    }
  
  cout << endl;

  if ( nchaine> MAXNCHAINE)
    {
      cerr << "Le nombre de chaines, " 
	   << nchaine << " doit tre infrieur  "
	   << MAXNCHAINE << endl;
      return(1);
    }
  // Ici, on est positionn sur le fichier au debut des petats

  return(0);
} /* fin Plage::litDebut */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Fonction : Lit les petats jusqu'a debut 
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int LitDebutPetat(ifstream &ific, int debut, int nchaine)
{
 /*....... variables locales ....................................*/
  int j ;
  double *petats ;

 /*....... Algorithme ...........................................*/
  petats = new double[nchaine] ;
  // Lire jusqu'a celui qui correspond a debut
  for (int ibase =0; ibase < (debut-1); ibase++)
    {
      for (j=0; j < nchaine ; j++)
	{
	  ific >> petats[j];
	  if  ( ific.eof())
	    {
	      cerr << "Fin du fichier  la "
		   << (ibase+1) << "ime valeur"
		   << endl;
	      return(1);
	    }
	}
    }

  return(0);
} /* fin Plage::litDebut */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Fonction : initialise le tableau ydessin
++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void initYdessin(int *ydessin, int nchaine, int *options, int iseq, int irhom)
{
  /*....... variables locales ...............*/
  int feat = 0;  //indique si des features sont dessinees

  /*....... initialisation de ydessin ...............*/ 
  
  //ydessin[0], hauteur reservee aux features 
  //ydessin[1], hauteur entre features et sequence
  //ydessin[2], hauteur entre features et graphe des etats
  //ydessin[3], hauteur du graphe des etats
  //ydessin[4], hauteur entre graphe des etats et les plages
  //ydessin[5], hauteur des plages
  //ydessin[6], hauteur entre les plages et la sequence
  //ydessin[7], epaisseur des plages
  //ydessin[8], hauteur entre les plages
  //ydessin[9], hauteur entre le dernier axe dessine et la legende
  //ydessin[10], hauteur entre le titre et le premier objet dessine
  //ydessin[11], hauteur entre les representations lineaires et en escalier des
               //plages

  ydessin[9] = 50;
  ydessin[10] = 50;
  /*... si on dessine au moins un type de feature .........*/
  if((options[18] != 0 || options[19] != 0 || options[20] != 0 || 
     options[21] != 0 || options[22] != 0 || options[23] != 0) && iseq != 0 )
    {
      //on prevoie la place pour toutes les features
      feat = 1;
      ydessin[0] = 50;
      ydessin[1] = 30;
      ydessin[9] += ydessin[0];
    } /* fin if options[18] */

  if(options[24] != 0 && irhom != 0)
    {
      ydessin[7] = 7;
      ydessin[8] = 0;
      /*ydessin[8] = -ydessin[7];*/
      ydessin[6] = 20;
      ydessin[11] = 10;
      ydessin[5] = nchaine * (ydessin[8] + ydessin[7]) - ydessin[8] + 
	ydessin[11] + ydessin[7];
      if(feat == 0)
	ydessin[4] = 30;     
    } /* fin if options[24] */


  if (options[25] != 0)
    {
      ydessin[4] = 20;
      ydessin[3] = 50;
      if (feat == 0)
	ydessin[2] = 30;
    } /* fin if options[25] */

} /* fin initYdessin */
  
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* fonction :                                                      */
/*           remplit titre_c qui contient le titre de l'image      */
/*           autre que la sequence.                                */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void getTitre_c(int type, int nmodal, int model, int nchaine, int algo,
		char *&titre_c, int *options, int iseq, int irhom)
{
/*.................... variables locales ..........................*/
  char tmp[2000] = ""; //tampon contenant les caracteristiques
  char nchaine_c[2];  //nchaine en char
  char debut_c[15];   //debut en char
  char fin_c[15];     //fin en char
  char model_c[2];   //model en char
  char type_c[2];   //type en char

  sprintf(nchaine_c,"%d", nchaine);
  sprintf(debut_c,"%d", options[0]);
  sprintf(fin_c,"%d", options[1]);
  sprintf(model_c,"%d", model);
  sprintf(type_c,"%d", type);

/*.................... remplissage de tmp ..........................*/
  if(irhom == 1 && (options[24] != 0 || options[25] != 0))
    {
      if (options[25] != 0)
	strcat(tmp, "Probabilites ");
      if (options[24] != 0 && options[25] != 0)
	strcat(tmp, "et plages homogenes ");
      else if (options[24] != 0 && options[25] == 0)
	strcat(tmp, "Plages homogenes ");
      strcat(tmp, "des ");
      strcat(tmp, nchaine_c);
      strcat(tmp, " regimes caches. ") ;

      strcat(tmp, "Algorithme ");
      switch(algo)
	{
	case 0:
	  strcat(tmp, "EM, ");
	  break;
	case 1:
	  strcat(tmp, "MCEM-1, ");
	  break;
	case 2:
	  strcat(tmp, "MCEM-2, ");
	  break;
	case 3:
	  strcat(tmp, "GIBBS, ");
	  break;
	case 4:
	  strcat(tmp, "BAYES-COND, ");
	  break;
	case 5:
	  strcat(tmp, "BAYES-CONJ, ");
	  break;
	default:
	  cerr << "L'algorithme " 
	       << algo << " lu sur le fichier est incorrect!"
	       << endl;
	  exit(1);
	} /* fin switch algo */
      
      strcat(tmp, "modele M1-M");
      strcat(tmp, model_c);
      strcat(tmp, ", type ");
      strcat(tmp, type_c);
      strcat(tmp, ". ");
    } /* fin if irhom */
  if ((iseq == 1) && (options[18] != 0 || options[19] != 0 || options[20] != 0
		      || 
		      options[21] != 0 || options[22] != 0 || options[23] != 0
		      ))
    {
      strcat(tmp, "Annotations GENBANK.");
    } /* fin if options */

  strcat(tmp, "\0");

  titre_c = new char[strlen(tmp)+1];
  strcpy(titre_c, tmp);

} /* fin getTitre_c() */
