/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Programme qui cre la squence complementaire d'une squence
donne
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//#include "const.h"
//#include "types.h"
#include "masequence.h"
/* On n'utilise pas la classe SEQUENCE de R'MES car
les lettres qui ne sont pas A,G,C,T y sont transformes en Z:
Ici, comme on ne sait pas l'utilisation que l'on va faire de
la sequence cre, on les laisse telles qu'elles sont sur la
squence origine */



/* L'option indiquant si les messages sont en anglais ou francais */
LOGIC        french=VRAI  ; /* indicateur de l'option french */

main (int argc, char *argv[])
{
/* ........ Variables internes : .......................................... */
   int          num_arg=1 ;
   char       * nom_ficseq=NULL ; /* nom du fichier de la sequence */
   long         i ;
/* ........ Algorithme : .................................................. */
/* ........ Decodage des arguments : ...................................... */
   while (num_arg < argc)
     {
       if ((strcmp (argv[num_arg], "-seq") == 0) && (num_arg + 1 < argc))
	 {
	   num_arg++ ;
	   nom_ficseq = argv[num_arg] ;
	   num_arg++ ;
	 }  /* fin -seq */
     else  if (strncmp (argv[num_arg], "-english",3)==0) 
	 {
	  num_arg++ ;
	  french = FAUX;
	 }
       else
	 {
	   cerr << "Usage : " << endl
		<< argv[0]
		<< " -seq <sequence-file> "
                << " [-eng[lish]] "
		<< endl << endl ;
	   return (1) ;
	 }  /* fin sinon */
     }  /* fin while */

/* ........ Coherence de la commande : .................................... */
   if (nom_ficseq == NULL)
   {
      if (french == VRAI)
        {
         cerr << "L'argument -seq <sequence-file> est obligatoire !!!" << endl ;
        }
      else
        {
        cerr << "The argument -seq <sequence-file> is required  !!!" << endl ;
        }
      return (1) ;
   }  /* finsi */


/* ........ Declaration de l'objet seq : .................................. */
   MASEQUENCE seq (nom_ficseq);
   if (seq.OK () == FAUX)
   {
      if (french == VRAI)
         cerr << "Sequence incorrecte !!!" << endl ;
      else
         cerr << "The sequence is not correct !!!" << endl ;
      return (1) ;
   }  /* finsi */


/* ........ Ecriture du titre de la sequence seq : .................. */
   if (french == VRAI)
     cout << "Squence complmentaire de la squence " <<endl;
   else
     cout << "Complementary sequence of the sequence " << endl ;
   cout << seq.TITRE() << endl;

   for (i=seq.LONGUEUR()-1 ; i>=0 ; i--)
     {
       if ((seq.LONGUEUR()-i+1)%50 == 0) cout << endl ;

         switch (seq[i])
         {
            case 'A' :
	      cout << 'T' ;
               break ;
            case 'G' :
	      cout << 'C' ;
               break ;
            case 'C' :
	      cout << 'G' ;
               break ;
            case 'T' :
	      cout << 'A' ;
               break ;
            case 'Z' :
	      cout << 'Z' ;
               break ;
            default :
	      cout << seq[i] ;
              break ;
         }  /* fin switch */       
     }
   cout << endl ;


   return (0) ;
}  /* fin main */
