#ifndef MASEQUENCEH
#define MASEQUENCEH

#include "const.h"
#include "types.h"

/* ........ Longueur des lignes de bases : ................................ */
#define LGRLIGNE 1000

/* ........................................................................ */
/* ........ Description : Sequences considerees comme des suites de bases.  */
/* ........................................................................ */
class MASEQUENCE
{
/* ........ Donnees : ..................................................... */
private :
   char *   _nomficseq ; /* nom du fichier ou est la sequence */
   long     _longueur ;   /* longueur de la sequence */
                          /* = nombre de bases + trous */
   char  ** _contenu ;    /* bases + trous constituant la sequence, */
                          /* stockees par series de LGRLIGNE bases + trous */
                          /* consecutives */
   char     _titre[300] ; /* titre de la sequence (eventuellement tronque) */
   LOGIC    _ok ;         /* indique si la sequence est correcte ou pas */
/* ........ Methodes : .................................................... */
private :
           inline char & operator () (const long ibase) ;
public :
                         MASEQUENCE    (char *nomfic) ;
           inline       ~MASEQUENCE    () ;
           inline long   LONGUEUR    (void)                           const ;
           inline LOGIC  OK          (void)                           const ;
           inline const  char* TITRE (void)                           const ;
           inline char   operator [] (const long ibase)               const ;
} ; /* fin class MASEQUENCE */


/* ........................................................................ */
/* ........ Fonction : Donne acces a une base d'une sequence.               */
/* ........................................................................ */
inline char& MASEQUENCE::operator () (const long ibase)
{
   return (this->_contenu[ibase/LGRLIGNE][ibase%LGRLIGNE]) ;
}  /* fin MASEQUENCE::operator () */


/* ........................................................................ */
/* ........ Fonction : Detruit une sequence (en fait, cette fonction ne     */
/* ........            detruit rien pour respecter le fonctionnement du     */
/* ........            constructeur par copie).                             */
/* ........................................................................ */
inline MASEQUENCE::~MASEQUENCE ()
{
}  /* fin MASEQUENCE::~MASEQUENCE */

/* ........................................................................ */
/* ........ Fonction : Fournit la longueur d'une sequence.                  */
/* ........................................................................ */
inline long MASEQUENCE::LONGUEUR (void) const
{
   return (this->_longueur) ;
}  /* fin MASEQUENCE::LONGUEUR */

/* ........................................................................ */
/* ........ Fonction : Fournit l'indicateur de correction d'une sequence.   */
/* ........................................................................ */
inline LOGIC MASEQUENCE::OK (void) const
{
   return (this->_ok) ;
}  /* fin MASEQUENCE::OK */

/* ........................................................................ */
/* ........ Fonction : Fournit le titre d'une sequence.                     */
/* ........................................................................ */
inline const char* MASEQUENCE::TITRE (void) const
{
   return (&this->_titre[0]) ;
}  /* fin MASEQUENCE::TITRE */

/* ........................................................................ */
/* ........ Fonction : Fournit une base d'une sequence.                     */
/* ........................................................................ */
inline char MASEQUENCE::operator [] (const long ibase) const
{
   return (this->_contenu[ibase/LGRLIGNE][ibase%LGRLIGNE]) ;
}  /* fin MASEQUENCE::operator [] */

#endif
