#include <ctype.h>

/* L'option indiquant si les messages sont en anglais ou francais*/
extern LOGIC        french  ; /* indicateur de l'option french */

/* ........................................................................ */
/* ........ Fonction : Construit une sequence par lecture sur l'entree      */
/* ........            standard.                                            */
/* ........................................................................ */
MASEQUENCE::MASEQUENCE (char * nomfic)
/* ........ Initialisation : .............................................. */
: _nomficseq(nomfic), _longueur (0), _contenu (NULL)
{
/* ........ Variables internes : .......................................... */
   char  caractere ;   /* caractere lu courant */
   long  erreur=FAUX ; /* code d'erreur : FAUX (0) ou numero du caractere */
                       /* non admis ou UNDEF (-1) en cas de titre sans fin */
   LOGIC fini=FAUX ;   /* indique si la lecture du titre est terminee */
   short ic=0 ;        /* indice du caractere courant du titre */
   LOGIC lu=FAUX ;     /* indique si une base vient ou non d'etre lue */
   char  base ;        /* code de la derniere base lue */
   char  **temp ;      /* stocke temporairement les pointeurs de ligne du */
                       /* contenu de la sequence lorsque leur nombre doit */
                       /* etre incremente */
   long  iligne ;      /* indice de la ligne courante */
   char line[80];
   int  i, lg ;

/* ........ Algorithme : .................................................. */
   /* Ouverture du fichier */
   ifstream ific_seq (nomfic) ;
 if (ific_seq == NULL)
   {
     if (french == VRAI)
       cerr << "On ne peut pas ouvrir en lecture le fichier de la sequence : " 
	    << nomfic
          << endl ;
     else
       cerr << "The sequence-file cannot be opened in read mode : " 
	 << nomfic
          << endl ;
     this->_ok= FAUX ;
     return ;
   }

 /* On se place au debut du fichier */
 ific_seq.seekg(0) ;

/* ........ Determination si la sequence est en format FASTA ou GENBANK  .. */
  for (i=0; i<5; i++)
    {
    if (ific_seq.eof())
        {
         if (french)
          cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	       << nomfic
	       << endl
	       << " La fin du fichier "
	       << " est decelee avant la lecture des 5 premiers caracteres"
	       << endl
	       << " Sequence sans titre (format FASTA) ou sans LOCUS (format GenBank)?" << endl ;
         else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl
	     << " The end of the file "
	     << " is encountered before the first 5 characters "
	     << endl
             << " Sequence without title (format FASTA) other without LOCUS (format GenBank)?" << endl ;
         erreur = VRAI ;
         exit(1);
        } /* fin ific_seq.eof() */
    ific_seq.get (line[i]);
    } /* fin for (i=0; i<5; i++) */

  if ( strncmp(line, "LOCUS",5 ) ==0 )
      {

      /* ... format GENBANK .... */
      /* Le nom du Locus va servir de titre */
   ific_seq.get (caractere) ;
   while ( isspace(caractere) && (ific_seq.eof () == 0))
     {
     ific_seq.get (caractere) ;
     }
   if (ific_seq.eof())
     {
     if (french)
           cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	     << nomfic
	     << endl
	     << " La fin de fichier est rencontree apres le mot LOCUS."
	     << endl;
     else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl 
		<< " The end of file is encountered after the word LOCUS."
	     << endl;
      erreur = VRAI ;
      exit(1);
     } /* fin ific_seq.eof() */
 
   while ((fini == FAUX) && (ific_seq.eof () == 0))
   {
      if (ic < 299)
      {
         this->_titre[ic] = caractere ;
         ic++ ;
      }  /* finsi */
      if (!isspace(caractere))
      {
         ific_seq.get (caractere) ;
         if (ific_seq.eof())
            {
            if (french)
           cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	     << nomfic
	     << endl
              << " La fin de fichier est rencontree en lisant le mot introduit pas LOCUS."
	     << endl;
            else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl 
	<< " The end of file is encountered when reading the word introduced by LOCUS."
	     << endl;

            erreur = VRAI ;
            exit(1);
            } /* fin ific_seq.eof() */
      }  /* fin (caractere != ' ') */
      else
      {
         fini = VRAI ;
      }  /* fin sinon */
   }  /* fin while */

   /* Rajout du dieze precede et suivi d'un blanc */
   this->_titre[ic++] = ' ' ;
   this->_titre[ic++] = '#' ;
   this->_titre[ic++] = ' ' ;
   this->_titre[ic++] = '\0' ;

  /* Se positionner au dbut de la squence 'brute' */
   fini = FAUX ;
   while ((fini == FAUX) && (ific_seq.eof () == 0))
   {
    ific_seq.getline(line,80);

    if (ific_seq.eof())
        {

         if (french)
           cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	     << nomfic
	     << endl
              << " Le mot ORIGIN n'est pas trouve."
	     << endl;
            else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl 
	<< " The word ORIGIN is not found."
	     << endl;
         erreur = VRAI ;
         exit(1);
        } /* fin ific_seq.eof() */


  if ( strncmp(line, "ORIGIN",6 ) ==0 )
    {
      fini = VRAI ;
      /* Remettre ventuellement ce qui suit ORIGIN sur la meme ligne */
      lg = ific_seq.gcount();

      if ((lg-7)>0)
        {
        for (i=(lg-1); i>7; i--)
          {
          if (isalpha(line[i]))
            {
            ific_seq.putback(line[i]);
            }
          } /* fin for (i= */

        } /* fin if ((lg-7)>0) */

    }
  } /* fin while */

  } /* fin du cas genbank */
else
      {
      /* On remet ce qu'on a lu pour determiner si c'est un format GenBank */
        for (i=4 ; i >=0; i--)
           ific_seq.putback(line[i]);

/* ........ Lecture du titre de la sequence (termine par #) : ............. */
   ific_seq.get (caractere) ;
   while ((fini == FAUX) && (ific_seq.eof () == 0))
   {
      if (caractere != '#')
      {
         if (ic < 297)
         {
            this->_titre[ic] = caractere ;
            ic++ ;
         }  /* finsi */
         ific_seq.get (caractere) ;
      }  /* fin alors */
      else
      {
         fini = VRAI ;
      }  /* fin sinon */
   }  /* fin while */
   if (ic == 0)
   {
      this->_titre[ic]   = '#' ;
      this->_titre[ic+1] = ' ' ;
      this->_titre[ic+2] = '\0' ;
   }  /* fin alors */
   else if (this->_titre[ic-1] == ' ')
   {
      this->_titre[ic]   = '#' ;
      this->_titre[ic+1] = ' ' ;
      this->_titre[ic+2] = '\0' ;
   }  /* fin sinon si alors */
   else
   {
      this->_titre[ic]   = ' ' ;
      this->_titre[ic+1] = '#' ;
      this->_titre[ic+2] = ' ' ;
      this->_titre[ic+3] = '\0' ;
   }  /* fin sinon */
} /* fin du cas pas GENBANK */


   if (fini == FAUX)
   {
      erreur = UNDEF ;
   }  /* fin alors */
   else
   {
      ific_seq.get (caractere) ;
      while ((erreur == FAUX) && (ific_seq.eof () == 0))
      {
         lu = FAUX ;
         switch (caractere)
         {
            case ' ' :
            case '\t' :
            case '\n' :
            case '0' :
            case '1' :
            case '2' :
            case '3' :
            case '4' :
            case '5' :
            case '6' :
            case '7' :
            case '8' :
            case '9' :
               base = caractere  ;
               break ;
            case 'a' :
            case 'A' :
               lu = VRAI ;
               base = 'A' ;
               break ;
            case 'g' :
            case 'G' :
               lu = VRAI ;
               base = 'G' ;
               break ;
            case 'c' :
            case 'C' :
               lu = VRAI ;
               base = 'C' ;
               break ;
            case 't' :
            case 'T' :
               lu = VRAI ;
               base = 'T' ;
               break ;
/* ........ Prise en compte de trous eventuels : .......................... */
            case 'r' :
            case 'R' :
            case 'y' :
            case 'Y' :
            case 'w' :
            case 'W' :
            case 's' :
            case 'S' :
            case 'm' :
            case 'M' :
            case 'k' :
            case 'K' :
            case 'h' :
            case 'H' :
            case 'b' :
            case 'B' :
            case 'v' :
            case 'V' :
            case 'd' :
            case 'D' :
            case 'n' :
            case 'N' :
            case '.' :
            case 'z' :
            case 'Z' :
               lu = VRAI ;
               base = caractere ;
               break ;
            default :
               erreur = this->_longueur + 1 ;
               break ;
         }  /* fin switch */
         if (lu == VRAI)
         {
/* ........ Allocation d'une nouvelle ligne de bases, si necessaire : ..... */
            if (this->_longueur%LGRLIGNE == 0)
            {
               if (this->_longueur/LGRLIGNE == 0)
               {
                  this->_contenu = new char*[this->_longueur/LGRLIGNE + 1] ;
               }  /* fin alors */
               else
               {
                  temp = new char*[this->_longueur/LGRLIGNE + 1] ;
                  for (iligne = 0 ; iligne < this->_longueur/LGRLIGNE ;
                       iligne++)
                  {
                     temp[iligne] = this->_contenu[iligne] ;
                  }  /* fait (iligne) */
                  delete this->_contenu ;
                  this->_contenu = temp ;
               }  /* fin sinon */
               this->_contenu[this->_longueur/LGRLIGNE] = new char[LGRLIGNE] ;
            }  /* finsi */
            (*this)(this->_longueur) = base ;
            this->_longueur++ ;
         }  /* finsi */
         if (erreur == FAUX)
         {
            ific_seq.get (caractere) ;
         }  /* finsi */
      }  /* fin while */
   }  /* fin sinon */
   if (erreur == FAUX)
   {
      this->_ok = VRAI ;
   }  /* fin alors */
   else
   {
      this->_ok = FAUX ;
      if (erreur > 0)
      {
         if (french == VRAI)
           cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	     << nomfic
	     << endl
		<< "La base numero : "
              << erreur << " est incorrecte ---> " << caractere << endl ;
         else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl 
             << "The basis number : "
              << erreur << " is wrong ---> " << caractere << endl ;

      }  /* fin alors */
      else
      {
         if (french == VRAI)
           cerr << "Erreur (MASEQUENCE::MASEQUENCE) sur le fichier : "
	     << nomfic
	     << endl
              << "Titre sans fin ou sequence sans titre ?" << endl ;
         else
           cerr << "Error (MASEQUENCE::MASEQUENCE) on the file : "
	     << nomfic
	     << endl 
              << "Title without end or sequence without title ?" << endl ;

      }  /* fin sinon */
   }  /* fin sinon */
}  /* fin MASEQUENCE::MASEQUENCE */
