# -*-Makefile-*-
# $Id: Makefile.inc,v 1.3 1998/04/21 13:29:49 matt Exp $

# NOTE: Makefiles including this need to define PACKAGE and ROOT
# first.

PACKAGES_DIR = $(HOME)/java

ifndef JGL_HOME
  JGL_HOME = $(PACKAGES_DIR)
endif

ifndef SWING_HOME
  SWING_HOME = $(PACKAGES_DIR)
endif

ifndef JAVADEPEND_HOME
  JAVADEPEND_HOME = $(PACKAGES_DIR)/JavaDepend
endif

ifndef JAVA_HOME
  JAVA_HOME = /usr/local/java
endif

ifndef CLASSPATH
  CLASSPATH=.:$(SWING_HOME)/swingall.jar:$(JAVA_HOME)/lib/classes.zip:$(PSE_HOME)/pse.jar:$(JGL_HOME)/jgl.zip:$(STRUTLAYOUT_HOME)/classes
endif

ifndef JCC
  JCC = javac
endif

BASE_CLASSES_DIR = $(ROOT)/../classes
CLASSES_DIR = $(BASE_CLASSES_DIR)/$(subst .,/,$(PACKAGE))
JAVA_FILES = $(wildcard *.java)
CLASS_FILES = $(patsubst %.java,$(CLASSES_DIR)/%.class,$(JAVA_FILES))
DEP_FILES = $(patsubst %.java,%.d,$(JAVA_FILES))

all: Subpackages Root

Subpackages:
	set -e; for i in $(SUBPACKAGES); do \
	  mkdir -p $(CLASSES_DIR)/$$i; \
	  $(MAKE) -C $$i; \
	done

Root: $(CLASS_FILES)

clean:
	set -e; for i in $(SUBPACKAGES); do $(MAKE) -C $$i clean; done
	/bin/rm -f *.d

# load dependencies
ifneq ($(DEP_FILES),)
  ifndef NO_DEPS
    -include $(DEP_FILES)
  endif
endif

# Java compile rule
$(CLASSES_DIR)/%.class: %.java
	$(JCC) -d $(BASE_CLASSES_DIR) -classpath .:$(BASE_CLASSES_DIR):$(CLASSPATH) $<

# dependency file generation rule
%.d: %.java
	java -classpath $(BASE_CLASSES_DIR):$(JAVADEPEND_HOME)/WARREN.zip:$(CLASSPATH) \
	-Dpkgmnt=$(BASE_CLASSES_DIR) -Dfiles=$< WARREN.tools.JavaDepend | sed 's/^ *TYA 0.*//g' > $@

# RMI stub/skeleton generation rule
$(CLASSES_DIR)/%_Stub.class: $(CLASSES_DIR)/%.class
	rmic -classpath $(BASE_CLASSES_DIR):$(CLASSPATH) -d $(BASE_CLASSES_DIR) $(PACKAGE).$(basename $(notdir $<))
