
package splash;

import utils.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;


public class EditorSplashScreen
{
  	JLabel _statusBar;
  
	static final int SLEEP_TIME = 1000;	// 1 sec
	static final int MIN_SPLASH_TIME = 4 * 1000; // 5 seconds
    
 
  	Icon _splash;
  	JWindow _external = null;
	long _timer;
    
	//  JPanel _internal = null;
  
  /**
   * Create a splash screen
   *
   */
  public EditorSplashScreen (Icon pic) 
  {
	  if (pic != null) 
	  {
		_splash = pic;
        
		setupExternal();
		_timer = System.currentTimeMillis();
	  }
	}
    



  public void close()
  {
	try 
	{
			long currentTime = System.currentTimeMillis();
			while ((currentTime - _timer) < MIN_SPLASH_TIME) {
				Thread.sleep(SLEEP_TIME);
	 			currentTime = System.currentTimeMillis();
			}
	    
			SwingUtilities.invokeLater(new CloseSplashScreen());
	}
	catch (Exception ex) {
	 // MerlotDebug.exception(ex);
	}
          
  }

  public void showStatus(String status) 
  {
	try 
	{
		EditorDebug.msg("dans Splash :: status" + status );
		SwingUtilities.invokeLater(new UpdateStatus(status));
	}
	catch (Exception ex) {
	//  MerlotDebug.exception(ex);
	}
	  }
 
  
  protected void setupExternal() 
  {
	_external = new JWindow();
	_external.getContentPane().add(getPanel());
	_external.pack();
	Dimension windowSize = _external.getSize();
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	_external.setBounds((screenSize.width - windowSize.width) / 2,
						(screenSize.height - windowSize.height) / 2,
						windowSize.width,windowSize.height);
	_external.setVisible(true);
    
  }
  
  
  protected JPanel getPanel() 
  {
		JPanel p = new JPanel(new BorderLayout());
		_statusBar = new JLabel("...",SwingConstants.CENTER);
		p.add(new JLabel(_splash), BorderLayout.CENTER);
		p.add(_statusBar, BorderLayout.SOUTH);
		p.setBorder(new BevelBorder(BevelBorder.RAISED));
        
		return p;  
  }
  
  class UpdateStatus implements Runnable 
  {
		String new_status;
		public UpdateStatus(String status) 
		{
	 		 new_status = status;
		}
		public void run() 
		{
	  		_statusBar.setText(new_status);
		}
  }
  
  class CloseSplashScreen implements Runnable
  {
		public void run() 
		{
	  		// close the internal or external here
	  		if (_external != null) 
	  		{
				_external.setVisible(false);
				_external.dispose();
				_external = null;
        
	  		}   
		}
  }
}
