#!/usr/bin/perl

use CGI;

use strict;

use Getopt::Long; 

use Data::Dumper;

##########################################################################################
#											 #
#	       Pre-process : dealing with options, reading dictionary			 #
#											 #
##########################################################################################

my $DictionaryPath="/vh/pub/unites/mig/text/LLLChalenge05/data/dicos/dictionary_data_test.txt";
my $KeysPath="/htdocs/texte/LLLchallenge/keys-files/keys-paths-LLL.txt";
my $script;
my %options;
my $nameFile;

#############################
#Global conceptual variables#
#############################
my @ListOfFormsAndSyns;
my @ListOfCanonicalForms;
my @Responses;# Responses = Predictions
my %PathsToKeysFile;
my %Category;
my @LInfos=("N","Y");
my @CorefInfos=("all","with","without");
my @CatInfos=("all","action","bind","regulon","no_interaction");
my @Keys;
my %ResponseBlock;
my %ScoreBlock;
my $DigitsNumber=3;
my $beta=1;

my $ErrorEncounted=0;
my $TextError;


##########################################################################################
#											 #
#	       			       Main program					 #
#											 #
##########################################################################################

my $upload_dir = "./upload";

my $query = new CGI;

my $filename = $query->param("predictions-file");
my $upload_filehandle = $query->upload("predictions-file");
my @ResponsesLines=<$upload_filehandle>;


print $query->header ( );
print"<HTML>\n";
print" <HEAD>\n";
print" <TITLE>LLLchallenge - Score Table Page</TITLE>\n";
print" </HEAD>\n";
print" <BODY>\n";

#Reading Dictionary
if (not (open(DIC,$DictionaryPath))) {
	print "Servor Error<br> Please reporting this bug to Organization Team\n<br>Not able to open the dictionary\n";
	print" </BODY>\n";
	print" </HTML>\n";
	exit;
	};
my @dicLines=<DIC>;
close DIC;
foreach my $iRD (0..$#dicLines) {
	my @listOfOneFormAndSyns;
	if ($dicLines[$iRD]=~ s/^([^%|\r|\n|\t]+)[\r|\n|\t]//) {
		push(@ListOfCanonicalForms,$1);
		push(@listOfOneFormAndSyns,$1);
		while ($dicLines[$iRD]=~ s/^([^%|\r|\n|\t]+)[\r|\n|\t]//) {
			push(@listOfOneFormAndSyns,$1);
			};
		push (@ListOfFormsAndSyns,\@listOfOneFormAndSyns);
		};
	};


@Responses=readResponses(\@ResponsesLines);
%Category=readCategory(\@ResponsesLines);
%PathsToKeysFile=getPathsToKeysFile($options{'k'},\%Category);

foreach my $i (0..$#CatInfos) {
	@Keys=readKeys($PathsToKeysFile{$CatInfos[$i]});
	%{$ResponseBlock{$CatInfos[$i]}}=checkResponses(\@Responses,\@Keys);
	};

foreach my $i (0..5) {print "$ResponsesLines[$i]<br>\n"};
print "% $filename\n<br>\n";

%ScoreBlock=printScores(\%ResponseBlock,\%Category);

#logs
	my @WeekDays = ('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
	my @Months = ('Janvier','Fevrier','Mars','Avril','Mai','Juin','Juillet','Aout','Septembre','Octobre','Novembre','Decembre');
	(my $Sec,my $Min,my $Hour,my $Day,my $Month,my $Year,my $Week_Day) = (localtime); 
	$Year += 1900;
	if ($Sec  < 10) { $Sec = "0".$Sec; }
	if ($Min  < 10) { $Min = "0".$Min; }
	if ($Hour < 10) { $Hour = "0".$Hour; }
	if ($Day < 10) { $Day = "0".$Day; }

my $IP=$query->param('IP');


	open (LOGS,">>logs_ScoringService.txt");
	print LOGS $Day."\/".$Month."/".$Year."\t";
	print LOGS "$Hour:$Min\t";
	print LOGS "$filename\t";
print LOGS "$IP\t";
	print LOGS "PRE=";
	printf LOGS "%.1f",$ResponseBlock{'all'}{'PRE'};print LOGS "\t";
	print LOGS "REC=";
	printf LOGS "%.1f",$ResponseBlock{'all'}{'REC'};print LOGS "\t";
	print LOGS "F-M=";
	printf LOGS "%.1f",$ResponseBlock{'all'}{'FM'};print LOGS "\n";


print" </BODY>\n";
print" </HTML>\n";


##########################################################################################
#											 #
#	 		 Part I : Reading & checking keys				 #
#											 #
##########################################################################################

sub getPathsToKeysFile {
#extract the good path to keys-file

	if (not (open(FILE,$KeysPath))) {
		print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNot able to open the keys-paths file\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;
		};
	my @lines=<FILE>;#array of lines from response file
	close FILE;
	my $corefPTKF=$_[1]{'coref'};
	my %pathsToKeysFilePTKF;
	my $nbtrouves=-1;

	foreach my $iPTKF (0..$#lines) {
		foreach my $jPTKF (0..$#CatInfos) {
			my $catPTKF=$CatInfos[$jPTKF];
			if ($lines[$iPTKF] =~ /^$corefPTKF\t$catPTKF\t\"(.*)\"/) {
				$pathsToKeysFilePTKF{$catPTKF}=$1;
				$nbtrouves++;
				};
			};
		};

	if (not ($nbtrouves == $#CatInfos)) {
		print "Servor Error<br> Please reporting this bug to Organization Team<br>\nUnable to read all paths in the keys-paths file\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;
		};


	return %pathsToKeysFilePTKF;
	};

		
	

sub readKeys {
#read the key file, extract the IDs, targets, agents and interactions and check them

	my $nameFile=$_[0];
	if (not (open (FILE,$nameFile))) {
		print "Servor Error<br> Please reporting this bug to Organization Team<br>\nUnable to open a keys-file\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;
		};
	my @lines=<FILE>;#array of lines from response file
	close FILE;

	my @list;#list of keys, one per ID
	my $irK=0;
	while (not ($irK>$#lines)) {
	
		# jumping blank lines
		while (not ($lines[$irK] =~ /^ID/)) {
			$irK++;
			if ($irK>$#lines) {last;}
			};
		if ($irK>$#lines) {last;}
		
		my %key;#key is a hash with 1 ID, 1 list of agents, 1 list of targets, and 1 list of interactions
	
		# reading ID
		if (not ($lines[$irK] =~ /^ID\t([0-9|-]+) *[\r|\n]/)) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nFalse ID line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;}
			else {$key{'ID'}=$1};
		
		# jumping to next line
		$irK++;
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after an ID-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

		# jumping sentence
		if (not ($lines[$irK] =~ /^sentence\t/)) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNot a sentence-line after an ID-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			} else {$irK++;};
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after an ID-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

		# reading words and saving words
		my @wordsDeclared;
		if (not ($lines[$irK] =~ /^words\t/)) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNot a sentence-line after an ID-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			} else {
				while ($lines[$irK]=~ s/^words\t+word\([0-9]+,\'([^\']+)\'[^\t|\r|\n]+[\t|\r|\n]/words\t/){
					push (@wordsDeclared,$1);
					};
				$irK++;};
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after a Word-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};


		# jumping lemmas (optional)
		if ($lines[$irK] =~ /^lemmas\t/) {$irK++;};
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after a Lemma-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};


		# jumping syntactic_relations (optional)
		if ($lines[$irK] =~ /^syntactic_relations\t/) {$irK++;};
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after a Syntactic-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};


		#reading agents IDs, finding the correspondant word and taking the canonical form
		if (not ($lines[$irK] =~ /^agents/)) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNot an agents-line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			} else {
			my @listAgents;
			while ($lines[$irK] =~ s/^agents\t([^\t|\r|\n]+)[\t|\r|\n]/agents\t/) {
				if (not ($1=~ /^agent\(([0-9]+)\)/)) {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad agent declaration in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;}
					else {  my $canonicalForm=canonicalForm($wordsDeclared[$1]);
						if ($canonicalForm eq "") {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad agent declaration in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;} else {
							push (@listAgents,canonicalForm($wordsDeclared[$1]));
							};
						}
				};
			$key{'agents'}=\@listAgents;
			};
	
		# jumping to next line
		$irK++;
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after a Agent-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

	
		#reading targets, finding the correspondant word and taking the canonical form
		if (not ($lines[$irK] =~ /^targets/)) {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nMissing a target line in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;}
			else {
			my @listTargets;
			while ($lines[$irK] =~ s/^targets\t([^\t|\r|\n]+)[\t|\r|\n]/targets\t/) {
				if (not ($1=~ /^target\(([0-9]+)\)/)) {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad target declaration in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;}
					else {  my $canonicalForm=canonicalForm($wordsDeclared[$1]);
						if ($canonicalForm eq "") {					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad target declaration in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;} else {
							push (@listTargets,canonicalForm($wordsDeclared[$1]));
							};
						}
				};
			$key{'targets'}=\@listTargets;
			};
	
		# jumping to next line
		$irK++;
		if ($irK>$#lines) {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNothing after a Target-Line in $nameFile line ".($irK+1)."\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

	
		#reading interactions, checking if agents and target are declared
		if (not ($lines[$irK] =~ /^genic_interactions/)) {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nMissing an Interactions-line in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;}
			else {
			my @listInteractions;
			while ($lines[$irK] =~ s/^genic_interactions\t([^\t|\r|\n]+)[\t|\r|\n]/genic_interactions\t/) {
				if (not ($1=~ /^genic_interaction\(([0-9]+),([0-9]+)\)$/)) {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad interaction declaration in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;}
				else {
					my %interaction;
					$interaction{'agent'}=canonicalForm($wordsDeclared[$1]);
					if ($interaction{'agent'} eq "") {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nNot canonical form in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;};
					$interaction{'target'}=canonicalForm($wordsDeclared[$2]);
					if ($interaction{'target'} eq "") {
					print "Servor Error<br> Please reporting this bug to Organization Team<br>\nBad canonical form in $nameFile line ".($irK+1)."\n";
					print" </BODY>\n";
					print" </HTML>\n";
					exit;};
					push(@listInteractions,\%interaction);
					};
				};
			$key{'interactions'}=\@listInteractions;
			};
	
		#verifying key's coherence
		verifyCoherence(\%key,$nameFile,0);

		#saving key in list
		push (@list,\%key);
	
		};
	return @list;
	};


sub verifyCoherence{
#verify the coherence of the fields for 1 ID, and dying with a message if an error is found

	my %responsevC=%{$_[0]};
	my $nameFilevC=$_[1];
	my $isResponses=$_[2];

	#making a list of all entities mentionned in the interactions
	my @listOfAgentsUsedInInteractions;
	my @listOfTargetsUsedInInteractions;
 	foreach my $interactionvC (@{$responsevC{'interactions'}}) {
		
		if (not (myInclude($interactionvC->{'agent'},\@listOfAgentsUsedInInteractions))) {
			push (@listOfAgentsUsedInInteractions,$interactionvC->{'agent'});
			};
		if (not (myInclude($interactionvC->{'target'},\@listOfTargetsUsedInInteractions))) {
			push (@listOfTargetsUsedInInteractions,$interactionvC->{'target'});
			};
		};

	#verifying that each agent is a canonical form, and is used in a interaction
	my @listOfAgentsDeclared;
	foreach my $agentDeclared (@{$responsevC{'agents'}}) {
		#verify that the agent is used in an interaction
		if (not (myInclude($agentDeclared,\@listOfAgentsUsedInInteractions))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $agentDeclared : not used in interactions\n";
			} else {print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};
		#verify that the agent is in canonical form
		if (not (myInclude($agentDeclared,\@ListOfCanonicalForms))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $agentDeclared : not in canonical form\n";
			} else {print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;			};
		#making the list of agents or targets declared
		if (not (myInclude($agentDeclared,\@listOfAgentsDeclared))) {
			push (@listOfAgentsDeclared,$agentDeclared);
			};	
		};

	#verifying that each target is a canonical form, and is used in a interaction
	my @listOfTargetsDeclared;
	foreach my $targetDeclared (@{$responsevC{'targets'}}) {	
		#verify that the target is used in an interaction
		if (not (myInclude($targetDeclared,\@listOfTargetsUsedInInteractions))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $targetDeclared : not used in interactions\n";
			} else {print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;			};
		#verify that the target is in canonical form
		if (not (myInclude($targetDeclared,\@ListOfCanonicalForms))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $targetDeclared : not in canonical form\n";
			} else {print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;			};
		#making the list of agents or targets declared
		if (not (myInclude($targetDeclared,\@listOfTargetsDeclared))) {
			push (@listOfTargetsDeclared,$targetDeclared);
			};	
		};

	#verifying that agents and targets are coherent with interactions
	foreach my $agentUsed (@listOfAgentsUsedInInteractions) {
		if (not (myInclude($agentUsed,\@listOfAgentsDeclared))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $agentUsed : not declared\n";
			} else {print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;			};
		};
	foreach my $targetUsed (@listOfTargetsUsedInInteractions) {
		if (not (myInclude($targetUsed,\@listOfTargetsDeclared))) {
			if ($isResponses) {
			print "Error in your file<br>\n Coherence error for $targetUsed : not declared\n";
			} else {
			print "Servor Error<br> Please reporting this bug to Organization Team<br>\nCoherence error in $nameFilevC\n";};
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};
		};
	}

##########################################################################################
#											 #
#	 		 Part II : Reading & checking responses				 #
#											 #
##########################################################################################

sub readCategory {
#read the responses file, extract the category

	my %categoryrC;
	my @lines=@{$_[0]};#array of lines from response file

	if ($#lines<5) {
		print "Error : seems the file is the wrong one<br>\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (not ($lines[0] =~ /%[ ]*Participant name/)) {
		print "Error in headings of your file line 1<br>\nPlease verifying the format (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (not ($lines[1] =~ /%[ ]*Participant institution/)) {
		print "Error in headings of your file line 2<br>\nPlease verifying the format (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (not ($lines[2] =~ /%[ ]*Participant email/)) {
		print "Error in headings of your file line 3<br>\nPlease verifying the format (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (not ($lines[3] =~ /%[ ]*Format checked/)) {
		print "Error in headings of your file line 4<br>\nPlease verifying the format (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (not ($lines[4] =~ /%[ ]*Basic data.*([Y|N]+)/)) {
		print "Error in headings of your file line 5<br>\nMissing letter Y or N<br>\nPlease verifying the format (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	$categoryrC{'basic'}=$1;
	if (not ($lines[5] =~ /%[ ]*Coreference distinction.*[WITH|WITHOUT]/)) {
		print "Error in headings of your file line 6<br>\nMissing word WITH or/and WITHOUT<br>\nPlease verifying the format\n";
		print" </BODY>\n";
		print" </HTML>\n";
		exit;	
		};
	if (($lines[5]=~/WITH[^O]/) and ($lines[5]=~/WITHOUT/)) {$categoryrC{'coref'}="all";}
		else {
		if ($lines[5]=~/WITHOUT/) {$categoryrC{'coref'}="without";} else {
			if ($lines[5]=~/WITH[^O]/) {$categoryrC{'coref'}="with";}
			};
		};
	return %categoryrC;
	}
	


sub readResponses {
#read the responses file, extract the IDs, targets, agents and interactions and check them

	my @lines=@{$_[0]};#array of lines from response file

	my @list;#list of responses, one per ID
	my $irR=0;
	while (not ($irR>$#lines)) {
	
		# jumping blank lines
		while (not ($lines[$irR] =~ /^ID/)) {
			$irR++;
			if ($irR>$#lines) {last;}
			};
		if ($irR>$#lines) {last;}
		
		my %response;#response is a hash with 1 ID, 1 list of agents, 1 list of targets, and 1 list of interactions
	
		# reading ID
		if (not ($lines[$irR] =~ /^ID\t([0-9|-]+)[ ]*[\r|\n]/)) {
			print "Error in your file<br>\nBad ID-line, line ".($irR+1)."\n<br>Exemple of good ID-line is \"ID\t9253726-7\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
			else {$response{'ID'}=$1};
		
		# jumping to next line
		$irR++;
		if ($irR>$#lines) {
			print "Error in your file<br>\nNothing after an ID-line, line ".($irR+1)." (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

		#reading agents
		if (not ($lines[$irR] =~ /^agents/)) {
			print "Error in your file<br>\nBad agents-line, line ".($irR+1)."\n<br>Exemple of good agents-line is \"agents\tagent\(\'SigD\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
			else {
			my @listAgents;
			while ($lines[$irR] =~ s/^agents\t([^\t|\r|\n]+)[\t|\r|\n]/agents\t/) {
				if (not ($1=~ /^agent\(\'(.+)\'\)/)) {
			print "Error in your file<br>\nBad agents-line, line ".($irR+1)."\n<br>Exemple of good agents-line is \"agents\tagent\(\'SigD\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
}
					else {push (@listAgents,$1);}
				};
			$response{'agents'}=\@listAgents;
			};
	
		# jumping to next line
		$irR++;
		if ($irR>$#lines) {
			print "Error in your file<br>\nNothing after an agents-line, line ".($irR+1)." (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};

	
		#reading targets
		if (not ($lines[$irR] =~ /^targets/)) {
			print "Error in your file<br>\nBad targets-line, line ".($irR+1)."\n<br>Exemple of good targets-line is \"targets\ttarget\(\'genE\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
			else {
			my @listTargets;
			while ($lines[$irR] =~ s/^targets\t([^\t|\r|\n]+)[\t|\r|\n]/targets\t/) {
				if (not ($1=~ /^target\(\'(.+)\'\)/)) {
			print "Error in your file<br>\nBad targets-line, line ".($irR+1)."\n<br>Exemple of good targets-line is \"targets\ttarget\(\'genE\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
					else {push (@listTargets,$1);}
				};
			$response{'targets'}=\@listTargets;
			};
	
		# jumping to next line
		$irR++;
		if ($irR>$#lines) {
			print "Error in your file<br>\nNothing after an targets-line, line ".($irR+1)." (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)\n";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			};
	
		#reading interactions
		if (not ($lines[$irR] =~ /^genic_interactions/)) {
			print "Error in your file<br>\nBad interactions-line, line ".($irR+1)."\n<br>Exemple of good interactions-line is \"genic_interactions\tgenic_interaction\(\'SigD\',\'genE\'\)\tgenic_interaction\(\'SigA\',\'SpoA\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
			else {
			my @listInteractions;
			while ($lines[$irR] =~ s/^genic_interactions\t([^\t|\r|\n]+)[\t|\r|\n]/genic_interactions\t/) {
				if (not ($1=~ /^genic_interaction\(\'([^,]+)\',\'(.+)\'\)$/)) {
			print "Error in your file<br>\nBad interactions-line, line ".($irR+1)."\n<br>Exemple of good interactions-line is \"genic_interactions\tgenic_interaction\(\'SigD\',\'genE\'\)\tgenic_interaction\(\'SigA\',\'SpoA\'\)\" (see <a href=\"http://genome.jouy.inra.fr/texte/LLLchallenge/\#results\" target=\"_blank\">Challenge Home<a> for more precisions)";
			print" </BODY>\n";
			print" </HTML>\n";
			exit;
			}
				else {
					my %interaction;
					$interaction{'agent'}=$1;
					$interaction{'target'}=$2;
					push(@listInteractions,\%interaction);
					};
				};
			$response{'interactions'}=\@listInteractions;
			};
	
		#verifying response's coherence
		verifyCoherence(\%response,$nameFile,1);

		#saving response in list
		push (@list,\%response);
	
		};
	return @list;
	};


##########################################################################################
#											 #
#	 		 Part III : Comparing and Scoring				 #
#											 #
##########################################################################################


sub checkResponses{
#return a list of hashes (one per aligned ID) of COR, MIS & SPU

	my @responsescR=@{$_[0]};
	my @keyscR=@{$_[1]};

	#I use a list of boolean corresponding to ID responded, each initialized to 0. I check them to 1 when
	#I met the ID responded, in order to know at the end which aren't be treated (for warnings)
	my @listOfResponsesCheck;
	foreach my $icR (0..$#responsescR) {$listOfResponsesCheck[$icR]=0};
	#the same for keys
	my @listOfKeysCheck;
	my @listOfScores;#list of hashes with 'COR','MIS' and 'SPU', one hash per ID
	my %responseBlockcR;#hash with 'ID' the treated ID and 'listOfScores' the list of scores

	#for each ID in Keys...
	foreach my $icR (0..$#keyscR) {

		#finding the correspondant ID in responses
		my $jcR=-1;
		my $IDFound=0;
		while (($jcR<$#responsescR) and (not $IDFound)){
			$jcR++;
			if ($responsescR[$jcR]{'ID'} eq $keyscR[$icR]{'ID'}) {$IDFound=1};
			};

		#dealing with no correspondant ID (it will be a MIS)
		if ($IDFound==0) {
			$listOfKeysCheck[$icR]=0;
	     
				#force to count interactions for missing IDs
				my %scoreBlock;
				$scoreBlock{'ID'}=$keyscR[$icR]{'ID'};
				$scoreBlock{'COR'}=0;
				my @listOfKeysInteractions=@{$keyscR[$icR]{'interactions'}};
				$scoreBlock{'MIS'}=($#listOfKeysInteractions+1);
				$scoreBlock{'SPU'}=0;
				push (@listOfScores,\%scoreBlock);
				
			next;
			}#it will be a MIS

		#dealing with normal case
			#key and response are met, so they're checked
			else {$listOfKeysCheck[$icR]=1;$listOfResponsesCheck[$jcR]=1;};

		#copying keys and responses, creating ckeck files
		my @listOfKeysInteractions=@{$keyscR[$icR]{'interactions'}};
		#I use the same strategy for the interactions : a check list initialized to 0, and checked to 1 when
		#the interaction is treated. So I know which interactions aren't treated (which will be MIS)
		my @listOfKeysInteractionsCheck;
		my @listOfResponsesInteractions=@{$responsescR[$jcR]{'interactions'}};
		#the same strategy for responses (it will be SPU)
		my @listOfResponsesInteractionsCheck;
		foreach my $jcR (0..$#listOfResponsesInteractions) {$listOfResponsesInteractionsCheck[$jcR]=0};

		#for each interaction in key, finding the correspondant interaction and check them
		foreach my $jcR (0..$#listOfKeysInteractions) {
			my $kcR=-1;
			my $interactionFound=0;
			#for each interaction in response...
			while (($kcR<$#listOfResponsesInteractions) and (not $interactionFound)){
				$kcR++;
				#condition is : having same targets and agents, and response not already checked
				if ((($listOfResponsesInteractions[$kcR]{'agent'} eq $listOfKeysInteractions[$jcR]{'agent'})
				 and ($listOfResponsesInteractions[$kcR]{'target'} eq $listOfKeysInteractions[$jcR]{'target'}))
				and ($listOfResponsesInteractionsCheck[$kcR]==0))
					 {$interactionFound=1;};
				};
			#dealing with no correspondant interaction
			if ($interactionFound==0) {$listOfKeysInteractionsCheck[$jcR]=0;next}

			#dealing with normal case
				else {$listOfKeysInteractionsCheck[$jcR]=1;$listOfResponsesInteractionsCheck[$kcR]=1;};
			};

		#counting how many are checked or not in both camp
		my %scoreBlock;
		$scoreBlock{'ID'}=$keyscR[$icR]{'ID'};
		#counting corrects, ie how many keys checked 1
		#counting so missings, ie how many keys checked 0
		my $CORcount=0;
		my $MIScount=0;
		foreach my $jcR (0..$#listOfKeysInteractionsCheck) {
			if ($listOfKeysInteractionsCheck[$jcR]==0) {$MIScount++};
			if ($listOfKeysInteractionsCheck[$jcR]==1) {$CORcount++};
			};
		#counting spurious, ie how many responses checked 0
		my $SPUcount=0;
		foreach my $jcR (0..$#listOfResponsesInteractionsCheck) {
			if ($listOfResponsesInteractionsCheck[$jcR]==0) {$SPUcount++};
			};
		$scoreBlock{'COR'}=$CORcount;
		$scoreBlock{'MIS'}=$MIScount;
		$scoreBlock{'SPU'}=$SPUcount;
		push (@listOfScores,\%scoreBlock);
		};

	#computing scores
	my $COR=0;
	my $MIS=0;
	my $SPU=0;
	my $PRE;
	my $REC;
	my $FM;

	#compute them
	foreach my $icR (0..$#listOfScores) {
		$COR=$COR+$listOfScores[$icR]{'COR'};
		$MIS=$MIS+$listOfScores[$icR]{'MIS'};
		$SPU=$SPU+$listOfScores[$icR]{'SPU'};
		};
	$responseBlockcR{'COR'}=$COR;
	$responseBlockcR{'MIS'}=$MIS;
	$responseBlockcR{'SPU'}=$SPU;
	if ($COR+$SPU == 0) {$PRE=0} else {
		$PRE=$COR/($COR+$SPU);
		};
	if ($COR+$MIS == 0) {$REC=0} else {
		$REC=$COR/($COR+$MIS);
		};
	if ($PRE+$REC == 0) {$FM=0} else {
		$FM=($beta**2 + 1)*$PRE*$REC / ((($beta**2)*$PRE) + $REC);
		};
	#rounding them
	$PRE=(int($PRE*(10**$DigitsNumber)))/(10**$DigitsNumber);
	$REC=(int($REC*(10**$DigitsNumber)))/(10**$DigitsNumber);
	$FM=(int($FM*(10**$DigitsNumber)))/(10**$DigitsNumber);

	$responseBlockcR{'PRE'}=100*$PRE;
	$responseBlockcR{'REC'}=100*$REC;
	$responseBlockcR{'FM'}=100*$FM;

	return %responseBlockcR;
	};


sub printScores{

	my %responseBlockpS=%{$_[0]};
	my %categorypS=%{$_[1]};

	print "<pre>\n";
	print "+-------------------------------------------------------------------------------------------------------------------------------------------------------+\n";
	foreach my $ipS (0..$#LInfos) {
		if ($ipS==0) {
			print "|	With Linguistic	Informations															|\n";
			} else {
			print "|	Without Linguistic Informations															|\n";
			};
		print "+---------------+-----------------------+-----------------------+-----------------------+-----------------------+---------------------------------------+\n";
		print "|	Corefs	|	action		|	bind		|	regulon		|	no_interaction	|	all				|\n";
		print "+---------------+-----------------------+-----------------------+-----------------------+-----------------------+---------------------------------------+\n";

		foreach my $jpS (0..$#CorefInfos) {
			if (($categorypS{'basic'} eq $LInfos[$ipS]) and ($categorypS{'coref'} eq $CorefInfos[$jpS])) {
				print "|	".$CorefInfos[$jpS]."\t|	COR=".$responseBlockpS{'action'}{'COR'}."\t\t|	COR=".$responseBlockpS{'bind'}{'COR'}."\t\t|	COR=".$responseBlockpS{'regulon'}{'COR'}."\t\t|	COR=".$responseBlockpS{'no_interaction'}{'COR'}."\t\t|	COR=".$responseBlockpS{'all'}{'COR'}."\t\tPRE=";
				printf "%.1f",$responseBlockpS{'all'}{'PRE'};
				if ($responseBlockpS{'all'}{'PRE'}<10) {print "\t";};
				print "	|\n";

				my $TOTable=($responseBlockpS{'action'}{'MIS'}+$responseBlockpS{'action'}{'COR'});
				my $TOTu=$responseBlockpS{'action'}{'SPU'}+$responseBlockpS{'action'}{'COR'};
				print "|	"."\t|	MIS=".$responseBlockpS{'action'}{'MIS'}."\/".($responseBlockpS{'action'}{'MIS'}+$responseBlockpS{'action'}{'COR'});
				if (($responseBlockpS{'action'}{'MIS'}+$responseBlockpS{'action'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	MIS=".$responseBlockpS{'bind'}{'MIS'}."\/".($responseBlockpS{'bind'}{'MIS'}+$responseBlockpS{'bind'}{'COR'});
				if (($responseBlockpS{'bind'}{'MIS'}+$responseBlockpS{'bind'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	MIS=".$responseBlockpS{'regulon'}{'MIS'}."\/".($responseBlockpS{'regulon'}{'MIS'}+$responseBlockpS{'regulon'}{'COR'});
				if (($responseBlockpS{'regulon'}{'MIS'}+$responseBlockpS{'regulon'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	MIS=".$responseBlockpS{'no_interaction'}{'MIS'}."\/".($responseBlockpS{'no_interaction'}{'MIS'}+$responseBlockpS{'no_interaction'}{'COR'})."\t\t|	MIS=".$responseBlockpS{'all'}{'MIS'}."\/".($responseBlockpS{'all'}{'MIS'}+$responseBlockpS{'all'}{'COR'})."\tREC=";
				printf "%.1f",$responseBlockpS{'all'}{'REC'};
				if ($responseBlockpS{'all'}{'REC'}<10) {print "\t";};
				print "	|\n";

				print "|	"."\t|	SPU=".$responseBlockpS{'action'}{'SPU'}."\/".($responseBlockpS{'action'}{'SPU'}+$responseBlockpS{'action'}{'COR'});
				if (($responseBlockpS{'action'}{'SPU'}+$responseBlockpS{'action'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	SPU=".$responseBlockpS{'bind'}{'SPU'}."\/".($responseBlockpS{'bind'}{'SPU'}+$responseBlockpS{'bind'}{'COR'});
				if (($responseBlockpS{'bind'}{'SPU'}+$responseBlockpS{'bind'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	SPU=".$responseBlockpS{'regulon'}{'SPU'}."\/".($responseBlockpS{'regulon'}{'SPU'}+$responseBlockpS{'regulon'}{'COR'});
				if (($responseBlockpS{'regulon'}{'SPU'}+$responseBlockpS{'regulon'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	SPU=".$responseBlockpS{'no_interaction'}{'SPU'}."\/".($responseBlockpS{'no_interaction'}{'SPU'}+$responseBlockpS{'no_interaction'}{'COR'});
				if (($responseBlockpS{'no_interaction'}{'SPU'}+$responseBlockpS{'no_interaction'}{'COR'}) < 10) {print "\t\t"} else {print "\t"};
				print "|	SPU=".$responseBlockpS{'all'}{'SPU'}."\/".($responseBlockpS{'all'}{'SPU'}+$responseBlockpS{'all'}{'COR'})."\tF-M=";
				printf "%.1f",$responseBlockpS{'all'}{'FM'};
				if ($responseBlockpS{'all'}{'FM'}<10) {print "\t";};
				print "	|\n";

				} else {
				print "|	".$CorefInfos[$jpS]."\t|	X		|	X		|	X		|	X		|	X				|\n";
				print "|		|			|			|			|			|					|\n";
				print "|		|			|			|			|			|					|\n";
				};
		print "+---------------+-----------------------+-----------------------+-----------------------+-----------------------+---------------------------------------+\n";
			};
		};
	print "</pre>\n";
	};


##########################################################################################
#											 #
#		 		     Little scripts					 #
#											 #
##########################################################################################

sub canonicalForm{
#return the canonical form of the entity (1st parameter) if it exists
	my $entitycF=$_[0];
	my $returnedEntity="";

	#trying if it's is a canonical form
	if (myInclude($entitycF,\@ListOfCanonicalForms)) {$returnedEntity=$entitycF}

		else{

	#trying if it's a synonym
		foreach my $icF (0..$#ListOfCanonicalForms) {
			my @listOfOneFormAndSyns=@{$ListOfFormsAndSyns[$icF]};
			foreach my $jcF (1..$#listOfOneFormAndSyns) {
				if ($entitycF eq $listOfOneFormAndSyns[$jcF]) {
					$returnedEntity=$listOfOneFormAndSyns[0];last;
					};
				};
			if (not ($returnedEntity eq "")) {last;};
			};
		};

	return $returnedEntity;
	};

sub myInclude{
#return 1 if the element (1st parameter) is an element of the array (2nd parameter), 0 if not

	my $element=$_[0];
	my @array=@{$_[1]};
	
	my $found=0;
	my $imI=0;
	while ((not $found) and ($imI<=$#array)) {
		if ($element eq $array[$imI]) {$found=1};
		$imI++;
		};

	return $found;
	}
