#!/usr/bin/perl

use strict;

use CGI;
my $page=new CGI;

#Input
my $Input=$page->param('texte');
my @TabInput;

#Tableau des relations
my @Relations;

#Phrase
my $Phrase;

#Mots
my @Mots;

#Coordonnées des mots
my @MotsPos;

#Edition graphique
my @esc;
my @nBRels;
my @LignesParses;

#Récupération des noms de relations
open (TOTO,"nomsRels.txt");
my @Rels=<TOTO>;
foreach my $t (@Rels) {chomp $t};
close TOTO;

#########################################################################
#									#
#			   PROGRAMME PRINCIPAL				#
#									#
#########################################################################

print $page->header();
print $page->start_html();
print "<br>";

@TabInput=parseInput($Input);
my $iParse=-1;

#Vérification de la longueur de l'input
if ($#TabInput == -1) {
	print "<center>Aucune entr&eacute;e &agrave; visualiser</center>";
	print $page->end_html();
	exit;};

#Récupération de la phrase
my $trouve=0;
while (($iParse<$#TabInput) and (not $trouve)) {
	$iParse++;
	if ($TabInput[$iParse] =~ /^Sentence/) {$trouve=1};
	};
if (not $trouve) {
	print "<center>ligne \"Sentence n\" introuvable</center>";
	print $page->end_html();
	exit;
	};
$iParse++;
if ($iParse>$#TabInput) {
	print "<center>ligne de d&eacute;claration de la phrase introuvable</center>";
	print $page->end_html();
	exit;
	};
$Phrase=$TabInput[$iParse];
	
#Récupération des mots
my $trouve=0;
while (($iParse<$#TabInput) and (not $trouve)) {
	$iParse++;
	if ($TabInput[$iParse] =~ /^Words[\r|\n]/) {$trouve=1};
	};
if (not $trouve) {
	print "<center>ligne \"Words\" introuvable</center>";
	print $page->end_html();
	exit;
	};
$iParse++;
if ($iParse>$#TabInput) {
	print "<center>ligne de d&eacute;claration des mots introuvable</center>";
	print $page->end_html();
	exit;
	};
my $ligneTravail=$TabInput[$iParse];
$ligneTravail =~ s/^\(//;
$ligneTravail =~ s/\)\(/\@/g;
$ligneTravail =~ s/\)[ |\n|\r|\t]//;
@Mots = split /\@/, $ligneTravail;
if ($#Mots <=0) {
	print "<center>ligne de d&eacute;claration des mots mauvaise : aucun mot d&eacute;clar&eacute;</center>";
	print $page->end_html();
	exit;
	};

#Computation immédiate des coordonnées des mots
my $ligneTravail=$Phrase;
$ligneTravail=~ s/\(/@/g;
$ligneTravail=~ s/\)/%/g;
my $nbCarEnleves=0;
foreach my $iCM (0..$#Mots) {
	my $motTravail=$Mots[$iCM];
	$motTravail=~ s/\(/@/g;
	$motTravail=~ s/\)/%/g;
	if (not ($ligneTravail=~ /($motTravail)/)) {
		print "<center>erreur : impossible de trouver le mot $Mots[$iCM] dans la phrase</center>";
		print $page->end_html();
		exit;
		};
	#on récupère les indices grâce aux outils de matching de Perl
	$MotsPos[$iCM]{'ind1'}=$-[0]+$nbCarEnleves;
	$MotsPos[$iCM]{'ind2'}=$+[0]-1+$nbCarEnleves;
	$ligneTravail=~ s/($motTravail)//;
	$nbCarEnleves=$nbCarEnleves+length($motTravail);
	};

#Recherche et traitement des analyses
my $tolere=1;#sert à tolérer les lignes inscrites avant le premier Parse
while ($iParse<$#TabInput) {
	my $trouve=0;
	while (($iParse<$#TabInput) and (not $trouve)) {
		$iParse++;
		if ($TabInput[$iParse] =~ /^Parse/) {$trouve=1;next};
		if ((not $tolere) and ($TabInput[$iParse] =~ /[A-Z|a-z|0-9|-|_]/)) {
			print "ligne non attendue, ligne ".($iParse+1)." : $TabInput[$iParse]";
			print $page->end_html();
			exit;
			};
		};
	push(@LignesParses,$TabInput[$iParse]);
	$tolere=0;
	$iParse++;
	if ($iParse>$#TabInput) {
		last;
		};

	#pour stocker temporairement une analyse;
	my @relationsLocal;

	#pour stocker temporairement les catégories syntaxiques des mots
	my @tabNatures;
	foreach my $z (0..$#Mots) {$tabNatures[$z]=""};

	while ($TabInput[$iParse] =~ /^([^\(]+)\(([^,]+),([^\n|\r]+)\) *\(([^,]+),([^\)]+)\)/) {
		my %relat;
		$relat{'mot1'}{'texte'}=$2;
		$relat{'mot2'}{'texte'}=$3;
		$relat{'mot1'}{'ind'}=$4;
		$relat{'mot2'}{'ind'}=$5;
		$relat{'mot1'}{'ind1'}=$MotsPos[$4]{'ind1'};
		$relat{'mot1'}{'ind2'}=$MotsPos[$4]{'ind2'};
		$relat{'mot2'}{'ind1'}=$MotsPos[$5]{'ind1'};
		$relat{'mot2'}{'ind2'}=$MotsPos[$5]{'ind2'};

		my $natureTemp=$1;
		$natureTemp =~ s/ //g;
		$relat{'nature'}=$natureTemp;

		if (not($relat{'mot1'}{'texte'} eq $Mots[$relat{'mot1'}{'ind'}])) {
			print "ligne ".($iParse+1)." : premier argument incorrect<br>\n $LignesParses[$#LignesParses] : $TabInput[$iParse]";
			print $page->end_html();
			exit;};
		if (not($relat{'mot2'}{'texte'} eq $Mots[$relat{'mot2'}{'ind'}])) {
			print "ligne ".($iParse+1)." : deuxieme argument incorrect<br>\n $LignesParses[$#LignesParses] : $TabInput[$iParse]";
			print $page->end_html();
			exit;};

		my $natureTrouvee=0;
		foreach my $k (0..$#Rels) {if ($relat{'nature'} eq $Rels[$k]) {$natureTrouvee=1}};
		if (not($natureTrouvee)) {
			print "ligne ".($iParse+1)." : nature de la relation inconnue :$relat{'nature'}<br>\n $LignesParses[$#LignesParses] : $TabInput[$iParse]";
			print $page->end_html();
			exit;};

		if ($relat{'nature'}=~ /\:(.+)-(.+)/) {
			if ($tabNatures[$relat{'mot1'}{'ind'}] eq "") {$tabNatures[$relat{'mot1'}{'ind'}]=$1}
				else {if (not ($tabNatures[$relat{'mot1'}{'ind'}] eq $1)) {
					print "ligne ".($iParse+1)." : premier argument de categorie syntaxique incoherente \($1 et $tabNatures[$relat{'mot1'}{'ind'}]\)<br>\n $LignesParses[$#LignesParses] : $TabInput[$iParse]";
					print $page->end_html();
					exit;};
				};
			if ($tabNatures[$relat{'mot2'}{'ind'}] eq "") {$tabNatures[$relat{'mot2'}{'ind'}]=$2}
				else {if (not ($tabNatures[$relat{'mot2'}{'ind'}] eq $2)) {
					print "ligne ".($iParse+1)." : premier argument de categorie syntaxique incoherente \($2 et $tabNatures[$relat{'mot2'}{'ind'}]\)<br>\n $LignesParses[$#LignesParses] : $TabInput[$iParse]";
					print $page->end_html();
					exit;};
				};
			};
		push (@relationsLocal,\%relat);
		$iParse++;
		};
	push (@Relations,\@relationsLocal);

	if ($TabInput[$iParse]=~ /Parse/) {next;};
	if ($TabInput[$iParse] =~ /[A-Z|a-z|0-9|-|_]/) {
		print "ligne ".($iParse+1)." globalement incorrecte<br> $LignesParses[$#LignesParses] : $TabInput[$iParse]";
		print $page->end_html();
		exit;
		};
	};

#Impression des analyses
foreach my $i (0..$#Relations) {
	print "<br><br>\n";
	print "<h3>$LignesParses[$i]</h3>";

	my @esc;
	my @nBRels;
	my @relationsTravail=@{$Relations[$i]};
	foreach my $element (@relationsTravail) {caseRAuNiveauN ($element,0,\@esc,\@nBRels);};
	print "<pre>\n";
	sortDessin(0,\@esc,\@nBRels);
	my @lignePos=nouvelleLigneDeLongueur(length($Phrase));
	foreach my $m (0..$#Mots-1) {
		my %motEnCours;
		$motEnCours{'texte'}=$Mots[$m];
		$motEnCours{'ind1'}=$MotsPos[$m]{'ind1'};
		$motEnCours{'ind2'}=$MotsPos[$m]{'ind2'};
		inscritMotDansLigneACetIndice($m,\@lignePos,centreMot(\%motEnCours));
		};
	myPrintWeb(\@lignePos);
	print "</pre><br>\n";
	foreach my $i (0..$#relationsTravail) {
		print $relationsTravail[$i]{'nature'}." \(".$relationsTravail[$i]{'mot1'}{'texte'}.",".$relationsTravail[$i]{'mot2'}{'texte'}."\) \(".$relationsTravail[$i]{'mot1'}{'ind'}.",".$relationsTravail[$i]{'mot2'}{'ind'}."\)<br>";
		};
	};






#########################################################################
#									#
#			   						#
#									#
#########################################################################


sub parseInput {
#Lecture et vérification de l'entrée

	my $inputLocal=$_[0];
	$inputLocal=$inputLocal."\n";
	my @tabInputLocal;

	while ($inputLocal =~ s/^([^\n]+)[\n]+//) {
		push (@tabInputLocal,$1);
		};

	return @tabInputLocal;
	};

sub caseRAuNiveauN {my %r=%{$_[0]};my $niveau=$_[1];my @escRel=@{$_[2]};my @nbRPE=@{$_[3]};
if ($niveau>$#escRel) {%{$_[2][$niveau][0]}=%r;$_[3][$niveau]=1;}else {my $indiceVS=donneIndiceConcurrentDeAuNiveau(\%r,$niveau,\@escRel,\@nbRPE);my %rVS=%{$_[2][$niveau][$indiceVS]};if ($indiceVS==-1) {%{$_[2][$niveau][$_[3][$niveau]]}=%r;$_[3][$niveau]=$_[3][$niveau]+1;} else {if ((longueurArc(\%rVS)<longueurArc(\%r)) or ($indiceVS==-2)) {caseRAuNiveauN(\%r,$niveau+1,$_[2],$_[3]);} else {%{$_[2][$niveau][$indiceVS]}=%r;caseRAuNiveauN(\%rVS,$niveau+1,$_[2],$_[3]);};};};}
sub xEstStrictementDansIntervalleYZ{my $x=$_[0];my $y=$_[1];my $z=$_[2];my $valeurRetour=0;if (($y<$x) && ($x<$z)) {$valeurRetour=1};if (($z<$x) && ($x<$y)) {$valeurRetour=1};return $valeurRetour;}
sub conflit{my %r1c=%{$_[0]};my %r2c=%{$_[1]};my $centre11=centreMot($r1c{'mot1'});my $centre12=centreMot($r1c{'mot2'});my $centre21=centreMot($r2c{'mot1'});my $centre22=centreMot($r2c{'mot2'});my $valeurRetour=0;if (xEstStrictementDansIntervalleYZ($centre11,$centre21,$centre22)){$valeurRetour=1;};if (xEstStrictementDansIntervalleYZ($centre12,$centre21,$centre22)){$valeurRetour=1;};if (xEstStrictementDansIntervalleYZ($centre21,$centre11,$centre12)){$valeurRetour=1;};if (xEstStrictementDansIntervalleYZ($centre22,$centre11,$centre12)){$valeurRetour=1;};if (($centre11==$centre21) && ($centre12==$centre22)){$valeurRetour=1;};if (($centre11==$centre22) && ($centre12==$centre21)){$valeurRetour=1;};return $valeurRetour;}
sub donneIndiceConcurrentDeAuNiveau{my %rc1=%{$_[0]};my $valeurRetour=-1;my @escRelI=@{$_[2]};my @nbRPEI=@{$_[3]};for (my $i=0;$i<=$nbRPEI[$_[1]];$i++) {if ($escRelI[$_[1]][$i]{'nature'} eq "tintin") {my $milou};my %rc2=%{$escRelI[$_[1]][$i]};if (conflit(\%rc1,\%rc2)) {if (not ($valeurRetour==-1)) {$valeurRetour=-2;last;} else {$valeurRetour=$i;};};};return $valeurRetour;}
sub centreMot{return int(($_[0]{'ind1'}+$_[0]{'ind2'})/2);}
sub longueurArc{return (abs(centreMot($_[0]{'mot1'})-centreMot($_[0]{'mot2'})));}
sub nouvelleLigneDeLongueur{my $longueur=$_[0];my @ligne;for (my $iNL=0;$iNL<$longueur;$iNL++) {$ligne[$iNL]=" ";};return @ligne;}
sub myPrintMatrice {my @mat=@{$_[0]};for (my $i=$#mat;$i>=0;$i--) {myPrint ($mat[$i]);};}
sub myPrint {my @str=@{$_[0]};for (my $iP=0;$iP<=$#str;$iP++) {print $str[$iP];};print "\n";}
sub inscritLigneDansLigneACetIndice{my $longueurLigne=$_[0];my $indiceL=$_[2];$_[1][$indiceL]="+";$_[1][$indiceL+$longueurLigne-1]="+";for (my $iL=$indiceL+1;$iL<($indiceL+$longueurLigne)-1;$iL++){$_[1][$iL]="-";};}
sub inscritMotDansLigneACetIndice{my $mot=$_[0];my $indice=$_[2];my $longueurMot=length($mot);for (my $iMDL=$indice;$iMDL<($indice+$longueurMot);$iMDL++){$mot=~ s/(.)//;$_[1][$iMDL]=$1;};}
sub inscritNature {my %riN=%{$_[0]};my $indiceInsertion=$_[2];my $numPhraseiN=$_[3];my $centreMot1=centreMot($riN{'mot1'});my $centreMot2=centreMot($riN{'mot2'});my $centreRelation=($centreMot1+$centreMot2)/2;my $indiceDebut=int($centreRelation-length($riN{'nature'})/2)+1;if (length($riN{'nature'})>=(abs($centreMot2-$centreMot1))){$riN{'nature'}=substr($riN{'nature'},0,(abs($centreMot2-$centreMot1)-1));if ($centreMot1<$centreMot2) {$indiceDebut=$centreMot1+1}else {$indiceDebut=$centreMot2+1};};inscritMotDansLigneACetIndice($riN{'nature'},$_[1][$indiceInsertion],$indiceDebut);}
sub sortDessin{my $numPhrase=$_[0];my @escRel=@{$_[1]};my @nbRPE=@{$_[2]};my @IndiceAxesVerticaux;my @Matrice;for (my $i=$#nbRPE;$i>=0;$i--) {@{$Matrice[$i+1]}=nouvelleLigneDeLongueur(length($Phrase));for (my $jAV=0;$jAV<=$#IndiceAxesVerticaux;$jAV++) {$Matrice[$i+1][$IndiceAxesVerticaux[$jAV]]="|";};for (my $jD=0;$jD<$nbRPE[$i];$jD++) {my $centreMot1=int(centreMot($escRel[$i][$jD]{'mot1'}));my $centreMot2=int(centreMot($escRel[$i][$jD]{'mot2'}));if ($centreMot1>$centreMot2) {my $temp=$centreMot1;$centreMot1=$centreMot2;$centreMot2=$temp;};inscritLigneDansLigneACetIndice($centreMot2-$centreMot1+1,$Matrice[$i+1],$centreMot1);push (@IndiceAxesVerticaux,$centreMot1);push (@IndiceAxesVerticaux,$centreMot2);};for (my $jD=0;$jD<$nbRPE[$i];$jD++) {inscritNature($escRel[$i][$jD],\@Matrice,$i+1,$numPhrase);};};@{$Matrice[0]}=nouvelleLigneDeLongueur(length($Phrase));for (my $jAV=0;$jAV<=$#IndiceAxesVerticaux;$jAV++) {$Matrice[0][$IndiceAxesVerticaux[$jAV]]="|";};myPrintMatrice(\@Matrice);print "<b>$Phrase</b>";print "\n";}

sub myPrintWeb {my @str=@{$_[0]};for (my $iP=0;$iP<=$#str;$iP++) {print $str[$iP];};print "\n";}
