#ifndef HAVE_CL_CONFIG_H
#define HAVE_CL_CONFIG_H

#define CLOL_QUIET    "quiet"
#define CLOL_VERBOSE  "verbose"
#define CLOL_LOCACE   "locace"
#define CLOL_STRICT   "strict"
#define CLOL_CANON    "canonical-dictionary"
#define CLOL_PARENT   "parent-dictionary"
#define CLOL_SUFFIX   "suffix"
#define CLOL_STDOUT   "stdout"

#define CLOS_QUIET    'q'
#define CLOS_VERBOSE  'v'
#define CLOS_LOCACE   'V'
#define CLOS_STRICT   's'
#define CLOS_CANON    'c'
#define CLOS_PARENT   'p'
#define CLOS_SUFFIX   'x'
#define CLOS_STDOUT   'o'

#define CLOH_QUIET    "Be quiet"
#define CLOH_VERBOSE  "Be verbose"
#define CLOH_LOCACE   "Be even more verbose"
#define CLOH_STRICT   "Abort when a warning is issued"
#define CLOH_CANON    "Dictionary of canonical forms, in trish2 single compiled format with one tag"
#define CLOH_PARENT   "Dictionary of parent nodes, in trish2 multi compiled format with one tag"
#define CLOH_SUFFIX   "Suffix to append to input filename for output"
#define CLOH_STDOUT   "Write document to standard output instead of creating a file, ignores --" CLOL_SUFFIX

#define CLOV_QUIET            1
#define CLOV_VERBOSE          2
#define CLOV_LOCACE           3
#define CLOV_STRICT           4

#define CLX_VERBOSITY_OPTIONS {\
  { CLOL_QUIET   , CLOS_QUIET   , POPT_ARG_NONE  , NULL    , CLOV_QUIET   , CLOH_QUIET   , NULL },\
  { CLOL_VERBOSE , CLOS_VERBOSE , POPT_ARG_NONE  , NULL    , CLOV_VERBOSE , CLOH_VERBOSE , NULL },\
  { CLOL_LOCACE  , CLOS_LOCACE  , POPT_ARG_NONE  , NULL    , CLOV_LOCACE  , CLOH_LOCACE  , NULL },\
  { CLOL_STRICT  , CLOS_STRICT  , POPT_ARG_NONE  , NULL    , CLOV_STRICT  , CLOH_STRICT  , NULL },\
  POPT_TABLEEND\
}

#endif

