/*
  mouchard.h - crap debug macros

  Copyright (C) 1988-1994,1996-1999,2003,2004 Free Software Foundation, Inc.
  This file is part of the GNU C Library.  Its master source is NOT part of
  the C library, however.  The master source lives in /gd/gnu/lib.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the GNU C Library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA.
*/


/*
  Summary:

  The macros will only work with gcc since they use stringization, __FILE__ and __LINE__
  The MOUCH_* macros will print a message to the standard error with its position if MOUCHARD is #defined, otherwise they will do nothing
  MOUCH just prints the current file name and the current line number
  MOUCH_INT(i) additionally prints the integer i
  MOUCH_UINT(i) prints the unsigned integer i
  MOUCH_CHR(c) prints the character c
  MOUCH_STR(s) prints the string s
  MOUCH_PTR(p) prints the address pointed by p

  Use gdb instead, you lazy programmer.
*/

#ifndef HAVE_MOUCHARD_H
#define HAVE_MOUCHARD_H

#ifdef MOUCHARD
#include <stdio.h>
#define MOUCH fprintf(stderr, "%s:%d\n", __FILE__, __LINE__)
#define MOUCH_INT(i) fprintf(stderr, "%s:%d %s = %d\n", __FILE__, __LINE__, #i, i)
#define MOUCH_UINT(i) fprintf(stderr, "%s:%d %s = %u\n", __FILE__, __LINE__, #i, i)
#define MOUCH_CHR(c) fprintf(stderr, "%s:%d %s = '%c'\n", __FILE__, __LINE__, #c, c)
#define MOUCH_STR(s) fprintf(stderr, "%s:%d %s = \"%s\"\n", __FILE__, __LINE__, #s, s)
#define MOUCH_PTR(p) fprintf(stderr, "%s:%d %s = %p\n", __FILE__, __LINE__, #p, (void *)p)
#else
#define MOUCH
#define MOUCH_INT(i)
#define MOUCH_UINT(i)
#define MOUCH_CHR(c)
#define MOUCH_STR(s)
#define MOUCH_PTR(p)
#endif

#endif
