/*
  Copyright (C) 1988-1994,1996-1999,2003,2004 Free Software Foundation, Inc.
  This file is part of the GNU C Library.  Its master source is NOT part of
  the C library, however.  The master source lives in /gd/gnu/lib.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the GNU C Library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA.
*/

#define V_NOMAIN
#include "verbosity.h"

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#define V_MASK1 (V_QUIET | V_NORMAL | V_VERBOSE | V_LOCACE)
#define V_MASK2 (V_INFO | V_WARNING | V_ERROR)

void verbosity_message(int attr, const char *format, ...) {
  va_list ap;
  int stop = (attr & V_MASK2) >= severity;
  int display = stop || ((attr & V_MASK1) <= verbosity);

  if (!display)
    return;

  if (!(attr & V_NOHDR))
    switch (attr & V_MASK2) {
    case V_INFO:
      fprintf(stderr, "INFO : ");
      break;
    case V_WARNING:
      fprintf(stderr, "WARNING : ");
      break;
    case V_ERROR:
      fprintf(stderr, "ERROR : ");
      break;
    }

  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);

  if (!(attr & V_NONL))
    fprintf(stderr, "\n");

  if (stop)
    exit(1);
}
