/*
  verbosity.h - verbosity messages, part of libtrish

  Copyright (C) 1988-1994,1996-1999,2003,2004 Free Software Foundation, Inc.
  This file is part of the GNU C Library.  Its master source is NOT part of
  the C library, however.  The master source lives in /gd/gnu/lib.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the GNU C Library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA.
*/

#ifndef HAVE_VERBOSITY_H
#define HAVE_VERBOSITY_H


/*
  V_* - 
 */

#define V_QUIET    1
#define V_NORMAL   2
#define V_VERBOSE  4
#define V_LOCACE   8
#define V_INFO     16
#define V_WARNING  32
#define V_ERROR    64
#define V_NOHDR    128
#define V_NONL     256

#define VERBOSITY_ERROR     (V_QUIET | V_ERROR)
#define VERBOSITY_INFO      (V_NORMAL | V_INFO)
#define VERBOSITY_IMPORTANT (V_QUIET | V_INFO)
#define VERBOSITY_WARNING   (V_NORMAL | V_WARNING)
#define VERBOSITY_GRAVE     (V_QUIET | V_WARNING)
#define VERBOSITY_VERBOSE   (V_VERBOSE | V_INFO)
#define VERBOSITY_TRASH     (V_LOCACE | V_INFO)

#ifdef V_NOMAIN
#define V_GLOBAL extern
#define V_VERBOSITY_INIT
#define V_SEVERITY_INIT
#else
#define V_GLOBAL
#define V_VERBOSITY_INIT = V_NORMAL
#define V_SEVERITY_INIT = V_ERROR
#endif

V_GLOBAL int verbosity V_VERBOSITY_INIT;
V_GLOBAL int severity V_SEVERITY_INIT;

/*
  verbosity_message - display a message to stderr
  display - if non-zero message will be displayed
  stop - if non-zero message will be displayed and exits with code 1
  format, ... - printf-style format
 */

void verbosity_message(int attr, const char *format, ...);

#endif
