#include "message.h"

#include <stdio.h>
#include <stdlib.h>

/*
  AND masks to distinguish verbosity from severity from options
*/
#define VERBOSITY_MASK  3
#define SEVERITY_MASK  12


void message(int flags, const char *format, ...) {
  va_list ap;

  if (verbosity < (flags & VERBOSITY_MASK))
    return;

  va_start(ap, format);
  if (!(flags & MESSAGE_NO_LEVEL)) {
    switch (flags & SEVERITY_MASK) {
    case SEVERITY_INFO: fprintf(stderr, "INFO: "); break;
    case SEVERITY_WARNING: fprintf(stderr, "WARNING: "); break;
    case SEVERITY_ERROR: fprintf(stderr, "ERROR: "); break;
    case SEVERITY_FATAL: fprintf(stderr, "FATAL: "); break;
    default:
      fprintf(stderr, "UNKNOWN: "); break;
    }
  }
  vfprintf(stderr, format, ap);
  if (!(flags & MESSAGE_NO_NEWLINE))
    fprintf(stderr, "\n");
  va_end(ap);

  if (severity > (flags & SEVERITY_MASK))
    return;

  exit(1);
}
