/*
  wchar_utils.h - a functions for wide character strings, part of libtrish

  Copyright (C) 1988-1994,1996-1999,2003,2004 Free Software Foundation, Inc.
  This file is part of the GNU C Library.  Its master source is NOT part of
  the C library, however.  The master source lives in /gd/gnu/lib.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the GNU C Library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA.
*/

#ifndef HAVE_WCHAR_UTILS_H
#define HAVE_WCHAR_UTILS_H

#include <stdio.h>

/*
  print_wchar - prints a L'\0' terminated wide character string
  f - file handle where to print
  wcs - string to print
  nl - if true, prints a newline at the end of the string
*/

void print_wchar(FILE *f, const wchar_t *wcs, int nl);


wchar_t *wchar_duplicate(const wchar_t *src);

/*
  get_nonls - counts the number of newline characters at the end of the string
  s - string to count in
  l - length of s, will be recomputed if <= 0
  return value - number of newline characters (1 for CR, 2 for CRLF, 0 otherwise)
 */

int get_nonls(wchar_t *s, size_t l);

wchar_t *char2wcs(const char *s);

char *wcs2char(const wchar_t *w);

size_t tabs_and_nls(wchar_t *w);

#define WCHAR_ESCAPE L'\\'

#endif
