<xsl:stylesheet version = "1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:a="http://alvis.info/enriched/"
		>

  <xsl:output method="xml" indent="yes" doctype-system="BioTermTagger.dtd" />

  <xsl:key name="word-key" match="a:word" use="a:list_refid_token/a:refid_token" />
  <xsl:key name="lemma-key" match="a:lemma" use="a:refid_word" />

  <xsl:template match="a:documentCollection">
    <xsl:apply-templates select="./a:documentRecord/a:linguisticAnalysis" />
  </xsl:template>

  <xsl:template match="a:linguisticAnalysis">
    <xsl:element name="BioTermTagger">
      <xsl:apply-templates select="./a:sentence_level/a:sentence" />
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="a:sentence">
    <xsl:variable name="tok-start" select="./a:refid_start_token" />
    <xsl:variable name="tok-end" select="./a:refid_end_token" />
    <xsl:variable name="sosent" select="../../a:token_level/a:token[a:id = $tok-start]/a:from" />
    <xsl:variable name="eosent" select="../../a:token_level/a:token[a:id = $tok-end]/a:to" />
    <xsl:element name="token-list">
      <xsl:apply-templates select="../../a:token_level/a:token[a:from >= $sosent and $eosent >= a:to]">
	<xsl:sort select="a:from" data-type="number" />
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>

  <xsl:template match="a:token">
    <xsl:variable name="tokid" select="a:id" />
    <xsl:variable name="word" select="key('word-key',$tokid)" />

    <xsl:choose>
      <xsl:when test="$word">
	<xsl:if test="$word/a:list_refid_token/a:refid_token[1]=$tokid">
	  <xsl:element name="t">
	    <xsl:attribute name="id">
	      <xsl:value-of select="$word/a:id" />
	    </xsl:attribute>
	    <xsl:attribute name="lemma">
	      <xsl:value-of select="key('lemma-key',$word/a:id)/a:canonical_form" />
	    </xsl:attribute>
	    <xsl:value-of select="$word/a:form" />
	  </xsl:element>
	</xsl:if>
      </xsl:when>
      <xsl:when test="./a:type != 'sep'">
	<xsl:element name="t">
	  <xsl:attribute name="id">
	    <xsl:value-of select="$tokid" />
	  </xsl:attribute>
	  <xsl:attribute name="lemma">
	    <xsl:value-of select="./a:content" />
	  </xsl:attribute>
	  <xsl:value-of select="./a:content" />
	</xsl:element>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>