#include <popt.h>

/*
  Command-line options configuration for the trish-* executables

*/

#ifndef HAVE_CL_CONFIG_H
#define HAVE_CL_CONFIG_H

/*
  CLO_LONG_*
  Long versions of command-mine options to be used with two dashes
*/

#define CLO_LONG_QUIET       "quiet"
#define CLO_LONG_VERBOSE     "verbose"
#define CLO_LONG_LOCACE      "locace"
#define CLO_LONG_STRICT      "strict"
#define CLO_LONG_FORCE       "force"
#define CLO_LONG_SEPARATOR   "separator"
#define CLO_LONG_ALVIS       "alvis"
#define CLO_LONG_MAXLENGTH   "max-length"
#define CLO_LONG_DENSITY     "density"
#define CLO_LONG_IC_TABLE    "ic-table"
#define CLO_LONG_LEMMA       "lemma"
#define CLO_LONG_SUFFIX      "suffix"


/*
  CLO_SHORT_*
  Short versions of command-mine options to be used with a single dash
*/

#define CLO_SHORT_QUIET       'q'
#define CLO_SHORT_VERBOSE     'v'
#define CLO_SHORT_LOCACE      'V'
#define CLO_SHORT_STRICT      'W'
#define CLO_SHORT_FORCE       'F'
#define CLO_SHORT_SEPARATOR   's'
#define CLO_SHORT_ALVIS       'A'
#define CLO_SHORT_MAXLENGTH   'm'
#define CLO_SHORT_DENSITY     'd'
#define CLO_SHORT_IC_TABLE    'I'
#define CLO_SHORT_LEMMA       'l'
#define CLO_SHORT_SUFFIX      'x'


/*
  CLO_SWITCH_*
  Return values to use with libpopt
*/

#define CLO_SWITCH_QUIET    1
#define CLO_SWITCH_VERBOSE  2
#define CLO_SWITCH_LOCACE   3
#define CLO_SWITCH_STRICT   4
#define CLO_SWITCH_FORCE    5


/*
  CLO_HELP_*
  Common help texts
*/

#define CLO_HELP_QUIET         "Be quiet"
#define CLO_HELP_VERBOSE       "Be verbose"
#define CLO_HELP_LOCACE        "Be even more verbose"
#define CLO_HELP_STRICT        "Abort when a warning is issued"
#define CLO_HELP_FORCE         "Proceed even after errors (may cause instability)"
#define CLO_HELP_SEPARATOR     "Separator string to insert between each token"
#define CLO_HELP_ALVIS         "Input is in Alvis Enriched Document format"
#define CLO_HELP_MAXLENGTH     "Maximum number of tokens in a term"
#define CLO_HELP_DENSITY       "Expected number of terms"
#define CLO_HELP_IC_TABLE      "IC character replacement table"
#define CLO_HELP_LEMMA         "Search for lemma"
#define CLO_HELP_SUFFIX        "Suffix to add to the input file name to form the output file name"


/*
  Verbose options common to all executables
*/

struct poptOption verb_opts[] = {
  { CLO_LONG_QUIET   , CLO_SHORT_QUIET   , POPT_ARG_NONE  , NULL , CLO_SWITCH_QUIET   , CLO_HELP_QUIET   , NULL },
  { CLO_LONG_VERBOSE , CLO_SHORT_VERBOSE , POPT_ARG_NONE  , NULL , CLO_SWITCH_VERBOSE , CLO_HELP_VERBOSE , NULL },
  { CLO_LONG_LOCACE  , CLO_SHORT_LOCACE  , POPT_ARG_NONE  , NULL , CLO_SWITCH_LOCACE  , CLO_HELP_LOCACE  , NULL },
  { CLO_LONG_STRICT  , CLO_SHORT_STRICT  , POPT_ARG_NONE  , NULL , CLO_SWITCH_STRICT  , CLO_HELP_STRICT  , NULL },
  { CLO_LONG_FORCE   , CLO_SHORT_FORCE   , POPT_ARG_NONE  , NULL , CLO_SWITCH_FORCE   , CLO_HELP_FORCE   , NULL },
  POPT_TABLEEND
};

#define SWITCH_VERBOSITY \
 case CLO_SWITCH_QUIET:\
   verbosity = VERBOSITY_QUIET;\
   break;\
 case CLO_SWITCH_VERBOSE:\
   verbosity = VERBOSITY_VERBOSE;\
   break;\
 case CLO_SWITCH_LOCACE:\
   verbosity = VERBOSITY_LOCACE;\
   break;\
 case CLO_SWITCH_STRICT:\
   severity = SEVERITY_WARNING;\
   break;\
 case CLO_SWITCH_FORCE:\
   severity = SEVERITY_FATAL;\
   break;

#endif
