#ifndef HAVE_MESSAGE_H
#define HAVE_MESSAGE_H

#include <stdarg.h>

/*
  Verbosity levels
*/
#define VERBOSITY_QUIET   0
#define VERBOSITY_NORMAL  1
#define VERBOSITY_VERBOSE 2
#define VERBOSITY_LOCACE  3


/*
  Severity levels
*/
#define SEVERITY_INFO     0
#define SEVERITY_WARNING  4
#define SEVERITY_ERROR    8
#define SEVERITY_FATAL   12


/*
  Message options
*/
#define MESSAGE_NO_LEVEL   16  /* the message has no level (do not issue a level flag before the message) */
#define MESSAGE_NO_NEWLINE 32  /* do not print a newline at the end of the message */


/* Issues a message to standard error
 * flags : OR'ed verbosity level, severity level and options of the message
 * format : printf style format
 * ... : format arguments
 */
void message(int flags, const char *format, ...);

/* Current verbosity level : if the message level is lower than that nothing will be printed */
extern int verbosity;


/* Current severity level : if the message level is lower than that the executable is terminated */
extern int severity;

#endif
