#include "phrase.h"
#include "defaults.h"
#include "strdup.h"

#include <stdlib.h>
#include <string.h>

#include "mouchard.h"

phrase_t *phrase_new(const char *w, const char *l, const char *tokid0) {
  phrase_t *ph = calloc(1, sizeof(phrase_t));
  char *tokid = strdup(tokid0);

  ph->form_length = strlen(w);
  ph->form = calloc(ph->form_length + 1, sizeof(char));
  strcat(ph->form, w);
  ph->lemma_length = strlen(l);
  ph->lemma = calloc(ph->lemma_length + 1, sizeof(char));
  strcat(ph->lemma, l);
  ph->tokens = calloc(1, sizeof(char *));
  ph->tokens[0] = tokid;
  ph->n_tokens = 1;

  return ph;
}

void phrase_free(phrase_t *ph) {
  int i;

  if (ph == NULL) {
    return;
  }
  free(ph->form);
  free(ph->lemma);
  for (i = 0; i < ph->n_tokens; i++)
    free(ph->tokens[i]);
  free(ph->tokens);
  if (ph->label != NULL)
    free(ph->label);
  free(ph);
}

phrase_t *phrase_copy(const phrase_t *ph) {
  phrase_t *ph2 = calloc(1, sizeof(phrase_t));
  int i;

  ph2->form_length = ph->form_length;
  ph2->form = strdup(ph->form);
  ph2->lemma_length = ph->lemma_length;
  ph2->lemma = strdup(ph->lemma);
  ph2->tokens = calloc(ph->n_tokens, sizeof(char *));
  for (i = 0; i < ph->n_tokens; i++) {
    ph2->tokens[i] = strdup(ph->tokens[i]);
  }
  ph2->n_tokens = ph->n_tokens;

  return ph2;
}

void phrase_extension(phrase_t *ph, const char *w, const char *l, const char *sep, const char *tokid0) {
  char *tokid = strdup(tokid0);

  ph->form_length += strlen(w) + strlen(sep);
  ph->form = realloc(ph->form, ph->form_length + 1);
  strcat(ph->form, sep);
  strcat(ph->form, w);
  ph->lemma_length += strlen(l) + strlen(sep);
  ph->lemma = realloc(ph->lemma, ph->lemma_length + 1);
  strcat(ph->lemma, sep);
  strcat(ph->lemma, l);
  ph->n_tokens++;
  ph->tokens = realloc(ph->tokens, sizeof(char *) * ph->n_tokens);
  ph->tokens[ph->n_tokens - 1] = tokid;
}
