#ifndef HAVE_PHRASE_H
#define HAVE_PHRASE_H

#include <bunch.h>

typedef struct {
  char *form;
  char *lemma;
  int form_length;
  int lemma_length;
  char **tokens;
  int n_tokens;
  char *label;
} phrase_t;

phrase_t *phrase_new(const char *w, const char *l, const char *tokid);

void phrase_free(phrase_t *ph);

phrase_t *phrase_copy(const phrase_t *ph);

void phrase_extension(phrase_t *ph, const char *w, const char *l, const char *sep, const char *tokid);


#endif
