/*
  Copyright (C) 1988-1994,1996-1999,2003,2004 Free Software Foundation, Inc.
  This file is part of the GNU C Library.  Its master source is NOT part of
  the C library, however.  The master source lives in /gd/gnu/lib.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the GNU C Library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA.
*/

#include "wchar_utils.h"

#include <stdlib.h>
#include <wchar.h>

#include "mouchard.h"

void print_wchar(FILE *f, const wchar_t *wcs, int nl)  {
  char *s = calloc(MB_CUR_MAX + 1, sizeof(char));
  size_t l = 0;

  for (; *wcs; wcs ++) {
    l = wcstombs(s, wcs, MB_CUR_MAX);
    s[l] = 0;
    fprintf(f, s);
  }

  if (nl)
    fprintf(f, "\n");

  free(s);
}

wchar_t *wchar_duplicate(const wchar_t *src) {
  size_t l = wcslen(src) + 1;
  wchar_t *trg = calloc(l, sizeof(wchar_t));
  return wcscat(trg, src);
}

int get_nonls(wchar_t *s, size_t l) {
  if (l <= 0)
    l = wcslen(s);

  if ((!l) || ((s[l - 1] != L'\r') && (s[l - 1] != L'\n')))
    return 0;

  if ((l < 2) || ((s[l - 2] != L'\r') && (s[l - 2] != L'\n')))
    return 1;

  return 2;
}

wchar_t *char2wcs(const char *s) {
  size_t l = mbstowcs(NULL, s, 0) + 1;
  wchar_t *w;

  if (l == (size_t)-1)
    return NULL;
  w = calloc(l, sizeof(wchar_t));
  mbstowcs(w, s, l - 1);

  return w;
}

size_t tabs_and_nls(wchar_t *w) {
  size_t i, j = 0;
  int esc = 0;

  if (w == NULL)
    return 0;

  for (i = 0; w[i]; i++) {
    if (esc) {
      esc = 0;
      switch (w[i]) {
      case L'n':
	w[j] = L'\n';
	break;
      case L't':
	w[j] = L'\t';
	break;
      default:
	w[j] = w[i];
      }
      j++;
    }
    else if (w[i] == WCHAR_ESCAPE)
      esc = 1;
    else {
      w[j] = w[i];
      j++;
    }
  }

  if (esc) {
    w[j] = WCHAR_ESCAPE;
    j++;
  }
    
  w[j] = L'\0';

  return j;
}

char *wcs2char(const wchar_t *w) {
  size_t x, l = wcstombs(NULL, w, 0);
  char *s;

  if (l == (size_t)-1)
    return NULL;

  s = calloc(l + 1, sizeof(char));
  x = wcstombs(s, w, l);

  return s;
}
