package CompAnalResult::BoxPlotResult; 

use strict;

@CompAnalResult::BoxPlotResult::ISA=qw(CompAnalResult);


BEGIN {
    $CompAnalResultFactory::Factory{BOXPLOT}=sub { return new CompAnalResult::BoxPlotResult @_};
}

sub new {
    my $class=shift;
    my $attributes=shift;

    my $self=new CompAnalResult("BOXPLOT",$attributes->{comment});

    bless $self,$class;

    $self->{boxes}=[];
    $self->{currentbox}={};
    $self->{start}=1;
    $self->{end}=1;
    $self->{type}=$attributes->{'type'};
    return $self;
}

sub _start_tagged_data {

    my $self=shift;
    my $tag=shift;
    my $attributes=shift;


    if (lc $tag eq 'box') {
	my $begin=$attributes->{'begin'};
	my $end=$attributes->{'end'};
	my $thickness=$attributes->{'thickness'};
	$thickness=1.0
	    if (!defined $thickness);
	my $frame=$attributes->{'frame'};
	$frame='none'
	    if (!defined $frame);
	my $strand=$attributes->{'strand'};
	$strand=1
	    if (!defined $strand);
	my $color=$attributes->{'color'};
	$color='black'
	    if (!defined $color);
	my $filled=$attributes->{'filled'};
	if ($filled eq 'yes') {
	    $filled=1;
	} else {
	    $filled=0;
	}
	my $label=$attributes->{'label'};
	my $halign=$attributes->{'halign'};
	my $valign=$attributes->{'valign'};
	my $labelcolor=$attributes->{'labelcolor'};
	$labelcolor='black'
	    if (!defined $labelcolor);
	$self->{currentbox}={ begin=>$begin,
			      end=>$end,
			      thickness=>$thickness,
			      frame =>$frame,
			      strand => $strand,
			      color=>$color,
			      filled=>$filled,
			      label => $label,
			      halign => $halign,
			      valign => $valign,
			      labelcolor => $labelcolor};
    }
}

sub _end_tagged_data {
    my $self=shift;
    my $tag=shift;

    if (lc $tag eq 'box' && $self->{currentbox}) {
	$self->{start}=$self->{currentbox}->{begin}
	if ($self->{currentbox}->{begin}<$self->{start});

	$self->{end}=$self->{currentbox}->{end}
	if ($self->{currentbox}->{end}>$self->{end});

	push @{$self->{boxes}},$self->{currentbox};	
	$self->{currentbox}=undef;
    }
}

1
