package CompAnalResultWidget::LinePlotWidget;

use strict;

use FeatureWidget;

@CompAnalResultWidget::LinePlotWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{LINEPLOTS}=sub { return new CompAnalResultWidget::LinePlotWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $type=$companalresult->{type};
    my $widgettype='feature_overlay';
    $widgettype='interlace'
	if ($type eq 'separate');
    my $self = new CompAnalResultWidget($widgettype);

    $self->{companalresult}=$companalresult;
    bless $self,$class;

    return $self;
}

sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;
    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my ($leftbound,$rightbound)=($startbase,$endbase);
    ($leftbound,$rightbound)=($endbase,$startbase)
	if ($startbase>$endbase);
    my $offset=0;
    my $factor=1;
    ($offset,$factor)=(1.0,-1.0)
	if ($startbase>$endbase);

    my $companalresult=$self->{companalresult};
    my $min=$companalresult->{min};
    my $max=$companalresult->{max};
    my $smoothing=$companalresult->{smoothing};
    foreach my $lineplot (@{$companalresult->{lineplots}}) {
	my $color=$lineplot->{color};
	my $step=$lineplot->{step};
	my $startplot=$lineplot->{start};
	my $endplot=$startplot+$#{$lineplot->{data}}*$step;
	
	my @xcoords=();
	my @ycoords=();

	my $frame=$lineplot->{frame};
	$frame=undef
	    if ($frame eq 'none');

	my $strand=$lineplot->{strand};
	my $amp_factor=0.9;
	if ($frame eq 'all') {
	    $amp_factor=2.7;
	    $frame=2
	}

	my $vert_pos=ScalableFeatureWidget::get_vertical_position($strand,$frame);
	my $vert_amp=$ScalableFeatureWidget::totalthickness;
	$vert_amp*=$amp_factor
	    if (ScalableFeatureWidget::are_frames_visible());

	if (($startplot<$leftbound && $endplot>$rightbound) ||
	    ($startplot>=$leftbound && $startplot<=$rightbound) ||
	    ($endplot>=$leftbound && $endplot<=$rightbound)) {

	    my $startindex=int(($leftbound-$startplot)/$step);
	    $startindex=0
		if ($startindex<0);
	    my $endindex=int(($rightbound-$startplot)/$step)+1;
	    $endindex=$#{$lineplot->{data}}
	       if ($endindex>$#{$lineplot->{data}});
	    
	    my $startx=$lineplot->{start}+$step*$startindex;
	    my $starty=$lineplot->{data}->[$startindex];
	    if ($startx<$leftbound) {
		$starty=$starty+($startx+$step-$leftbound)/($step)*
		    ($lineplot->{data}->[$startindex+1]-$starty);
		$startx=$leftbound;
	    }
	    push @xcoords,$x_start+($offset+$factor*($startx-$leftbound)/($rightbound-$leftbound))*$x_scale;
	    push @ycoords,$y_start+($vert_pos+$vert_amp/2.0-($starty-$min)/($max-$min)*$vert_amp)*$y_scale;
	    my $last_x=$startx;
	    my $last_y=$starty;
	    my $prev_x=$startx;
	    my $prev_y=$starty;
	    my $endx=$lineplot->{start}+$step*$startindex;
	    my $endy=$lineplot->{data}->[$startindex];

	    foreach (my $index=$startindex+1;$index<=$endindex;$index++) {
		$endx+=$step;
		$endy=$lineplot->{data}->[$index];
		if ($endx>$rightbound) {
		    $endy=$endy-($endx-$rightbound)/($endx-$prev_x)*
			($endy-$prev_y);
		    $endx=$rightbound;
		}
		
		my $deltay=abs($last_y-$endy)/($max-$min);
		if ($deltay>=$smoothing || $index==$endindex) {
		    if ($last_x != $prev_x) {
			push @xcoords,$x_start+($offset+$factor*($prev_x-$leftbound)/($rightbound-$leftbound))*$x_scale;
			push @ycoords,$y_start+($vert_pos+$vert_amp/2.0-($prev_y-$min)/($max-$min)*$vert_amp)*$y_scale;
		    }
		    push @xcoords,$x_start+($offset+$factor*($endx-$leftbound)/($rightbound-$leftbound))*$x_scale;
		    push @ycoords,$y_start+($vert_pos+$vert_amp/2.0-($endy-$min)/($max-$min)*$vert_amp)*$y_scale;
		    $last_x=$endx;
		    $last_y=$endy;
		}
		$prev_x=$endx;
		$prev_y=$endy;
	    }
	    
	    $paintdevice->add_polyline(\@xcoords,\@ycoords,'color'=>$color)
		if ($#xcoords>1);
	    $paintdevice->add_line($xcoords[0],$ycoords[0],$xcoords[1],$ycoords[1],'color'=>$color)
		if ($#xcoords==1);
	}
    }
}

1
