package FeatureDataSourceWindow::FileWindow;

use strict;

@FeatureDataSourceWindow::FileWindow::ISA=qw(Gtk::FileSelection);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::FileSelection('Map File Selection');
    
    $self->ok_button->signal_connect('clicked',sub {$self->map_file_selected();});
    $self->cancel_button->signal_connect('clicked',sub {$self->hide();});

    $self->{manager}=$manager;

    bless $self,$class;

    return $self;
}

sub map_file_selected {
    my $self=shift;

    my $filename=$self->get_filename();
    $self->hide();

    my $datasource=new FeatureDataSource::FileFeatureDataSource($filename,'GenBank');

    $self->{manager}->_add_map_from_datasource($datasource);
}
