package FeatureDataSourceWindow::MicadoWindow;

use strict;

@FeatureDataSourceWindow::MicadoWindow::ISA=qw(Gtk::Dialog);



sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog;
    $self->set_title('Micado Retrieval Window');
    $self->{manager}=$manager;


    if (FeatureDataSource::MicadoFeatureDataSource::init) {
	my $genomecombo=new Gtk::Combo();
	my @genometab=FeatureDataSource::MicadoFeatureDataSource::get_complete_genome_names();
	$genomecombo->set_popdown_strings(@genometab);
	$genomecombo->entry->set_editable(0);
	$genomecombo->entry->signal_connect('changed',sub {$self->refresh_entry()});
	$genomecombo->show();
	$self->{genomecombo}=$genomecombo;
	$self->vbox->pack_start($genomecombo,1,1,1);
	
	my $accesshbox=new Gtk::HBox(0);
	$accesshbox->show();
	$self->vbox->pack_start($accesshbox,1,1,1);
	my $accesslabel=new Gtk::Label('Access Number');
	$accesslabel->show();
	$accesshbox->pack_start($accesslabel,1,1,1);
	my $accessentry=new Gtk::Entry;
	$accessentry->show();
	$self->{accessentry}=$accessentry;
	$accesshbox->pack_start($accessentry,1,1,1);
	
	
	my $okbtn=new Gtk::Button('OK');
	$okbtn->show();
	$okbtn->signal_connect('clicked',sub {$self->ok_clicked()});
	$self->action_area->pack_start($okbtn,1,1,1);
	my $cancelbtn=new Gtk::Button('Cancel');
	$cancelbtn->show();
	$cancelbtn->signal_connect('clicked',sub {$self->hide()});
	$self->action_area->pack_start($cancelbtn,1,1,1);

    } else {
	my $errorlabel=new Gtk::Label("Micado connection unavailable.");
	$errorlabel->show();
	$self->vbox->pack_start($errorlabel,1,1,1);
	my $proceedbtn=new Gtk::Button('Proceed');
	$proceedbtn->show();
	$proceedbtn->signal_connect('clicked',sub {$self->hide()});
	$self->action_area->pack_start($proceedbtn,1,1,1);
    }

    bless $self,$class;

    return $self;
}


sub refresh_entry {
    my $self=shift;

    my $organism=$self->{genomecombo}->entry->get_text;
    my $accessnumber=FeatureDataSource::MicadoFeatureDataSource::get_access_number($organism);

    $self->{accessentry}->set_text($accessnumber);
}

sub ok_clicked {
    my $self=shift;
    
    $self->hide();

    my %args=(qualifiers=>1);

    my $accessnumber=$self->{accessentry}->get_text();
    if ($accessnumber =~ /\w{2}\d+/) {
	$args{accessnumber}=$accessnumber;
    } else {
	my $organism=$self->{genomecombo}->entry->get_text();
	$args{organism}=$organism;
    }

    my $datasource=new FeatureDataSource::MicadoFeatureDataSource(%args);

    $self->{manager}->_add_map_from_datasource($datasource);
}

1
