package Gui::MapListWindow;

use strict;

sub new {
 
    my $class=shift;
    my $manager=shift;

    my $self={};
    bless $self,$class;

    $self->{manager}=$manager;

    my $window=new Gtk::Window -toplevel;
    $window->set_title('Map List');
    $window->set_usize(640,400);
    $window->signal_connect('delete_event',sub { Gtk::main_quit($window); });
    $window->signal_connect('destroy_event',sub { Gtk::main_quit($window); });
    $self->{window}=$window;

    my $vbox=new Gtk::VBox(0);
    $window->add($vbox);
    $vbox->show();

    my $maplistframe=new Gtk::Frame 'Map Operations';
    $maplistframe->show();
    $vbox->pack_start($maplistframe,1,1,4);

    my $maplistvbox=new Gtk::VBox(0);
    $maplistvbox->show();
    $maplistframe->add($maplistvbox);

    my $mapscrwindow=new Gtk::ScrolledWindow;
    $maplistvbox->pack_start($mapscrwindow,1,1,1);
    $mapscrwindow->show();
    
    my $maplist=new Gtk::List;
    $maplist->signal_connect('selection_changed',sub { $self->maplist_selection_changed();});
    $maplist->show();
    $mapscrwindow->add_with_viewport($maplist);
    $self->{maplist}=$maplist;
    my $hbox=new Gtk::HBox(0);
    $hbox->show();
    $maplistvbox->pack_start($hbox,0,0,1);
    
    my $mapfileselector=new Gtk::FileSelection('Map File Selection');
    $self->{mapfileselector}=$mapfileselector;
    $mapfileselector->ok_button->signal_connect('clicked',sub {$self->map_file_selected();});
    $mapfileselector->cancel_button->signal_connect('clicked',sub {$self->{mapfileselector}->hide();});

    my $mapaddhbox=new Gtk::HBox(0);
    $hbox->pack_start($mapaddhbox,1,1,1);

    my $mapdatasourcelabel=new Gtk::Label('Data Source:');
    $mapdatasourcelabel->show();
    $mapaddhbox->pack_start($mapdatasourcelabel,1,1,1);

    my $mapdatasourcemenu=new Gtk::Menu;
    $mapdatasourcemenu->show();
    my $mapdatasourceitem;

    if ( eval {require FeatureDataSource::FileFeatureDataSource;
	       require FeatureDataSourceWindow::FileWindow; } ) {
	my $filewindow=new FeatureDataSourceWindow::FileWindow($manager);
	$self->{filewindow}=$filewindow;
	$mapdatasourceitem=new Gtk::MenuItem('Local File');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='Local File'});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }

    if ( eval {require FeatureDataSource::MicadoFeatureDataSource; } &&
	 eval {require FeatureDataSourceWindow::MicadoWindow; } ) {
	if (FeatureDataSource::MicadoFeatureDataSource::init()) {
	    my $micadowindow=new FeatureDataSourceWindow::MicadoWindow($manager);
	    $self->{micadowindow}=$micadowindow;
	    $mapdatasourceitem=new Gtk::MenuItem('Micado');
	    $mapdatasourceitem->show();
	    $mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='Micado'});
	    $mapdatasourcemenu->append($mapdatasourceitem);
	}
    }

    if ( eval {require FeatureDataSource::EMBLFeatureDataSource;
	       require FeatureDataSourceWindow::EMBLWindow;} ) {
	my $emblwindow=new FeatureDataSourceWindow::EMBLWindow($manager);
	$self->{emblwindow}=$emblwindow;
	$mapdatasourceitem=new Gtk::MenuItem('EMBL');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='EMBL'});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }


    if ( eval {require FeatureDataSource::GenBankFeatureDataSource;
	       require FeatureDataSourceWindow::GenBankWindow;} ) {
	my $genbankwindow=new  FeatureDataSourceWindow::GenBankWindow($manager);
	$self->{genbankwindow}=$genbankwindow;
	$mapdatasourceitem=new Gtk::MenuItem('GenBank');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='GenBank'});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }

    my $mapdatasourceoptionmenu=new Gtk::OptionMenu();
    $mapdatasourceoptionmenu->set_menu($mapdatasourcemenu);
    $mapdatasourceoptionmenu->set_history(0);
    $self->{datasourcetype}='Local File';
    $mapdatasourceoptionmenu->show();
    $mapaddhbox->pack_start($mapdatasourceoptionmenu,1,1,1);

    my $mapaddbtn=new Gtk::Button('Add Map');
    $mapaddbtn->signal_connect('clicked',sub { $self->add_map_from_datasource(); });
    $mapaddbtn->show();
    $mapaddhbox->pack_start($mapaddbtn,1,1,1);
    $self->{mapaddbtn}=$mapaddbtn;

    my $mapdupbtn=new Gtk::Button('Duplicate Map');
    $mapdupbtn->set_sensitive(0);
    $mapdupbtn->signal_connect('clicked',sub { $self->duplicate_map; });
    $mapdupbtn->show();
    $hbox->pack_start($mapdupbtn,1,1,1);
    $self->{mapdupbtn}=$mapdupbtn;

    my $maprevcombtn=new Gtk::Button('Flip Map');
    $maprevcombtn->set_sensitive(0);
    $maprevcombtn->signal_connect('clicked',sub { $self->revcom_map; });
    $maprevcombtn->show();
    $hbox->pack_start($maprevcombtn,1,1,1);
    $self->{maprevcombtn}=$maprevcombtn;

    my $mapremovebtn=new Gtk::Button('Remove Map');
    $mapremovebtn->set_sensitive(0);
    $mapremovebtn->signal_connect('clicked',sub { $self->remove_map; });
    $mapremovebtn->show();
    $hbox->pack_start($mapremovebtn,1,1,1);
    $self->{mapremovebtn}=$mapremovebtn;

    my $positionvbox=new Gtk::VBox(0,1);
    $maplistvbox->pack_start($positionvbox,1,1,1);

    my $anchorhbox=new Gtk::HBox(0,1);
    $anchorhbox->show();
    $positionvbox->pack_start($anchorhbox,1,1,1);

    my $anchorlabel=new Gtk::Label('Anchor Position');
    $anchorlabel->show();
    $anchorhbox->pack_start($anchorlabel,0,0,1);
    my $anchorentry=new Gtk::Entry;
    $anchorentry->show();
    $anchorentry->signal_connect('activate',sub {$self->anchor_changed;});
    $self->{anchorentry}=$anchorentry;
    $anchorhbox->pack_start($anchorentry,1,1,1);

    my $focushbox=new Gtk::HBox(0,1);
    $focushbox->show();
    $positionvbox->pack_start($focushbox,1,1,1);

    my $focuslabel=new Gtk::Label('Focus on gene');
    $focuslabel->show();
    $focushbox->pack_start($focuslabel,0,0,1);
    my $focusentry=new Gtk::Entry;
    $focusentry->show();
    $focusentry->signal_connect('activate',sub {$self->focus_changed;});
    $self->{focusentry}=$focusentry;
    $focushbox->pack_start($focusentry,1,1,1);

    my $companalframe=new Gtk::Frame 'Computational Result Operations';
    $companalframe->show();
    $vbox->pack_start($companalframe,1,1,4);

    my $companalvbox=new Gtk::VBox(0,1);
    $companalvbox->show();
    $companalframe->add($companalvbox);

    my $companalscrwindow=new Gtk::ScrolledWindow;
    $companalvbox->pack_start($companalscrwindow,1,1,1);
    $companalscrwindow->show();
    
    my $companallist=new Gtk::List;
    $companallist->show();
    $companallist->signal_connect('selection_changed',sub { $self->companallist_selection_changed();});
    $self->{companallist}=$companallist;
    $companalscrwindow->add_with_viewport($companallist);

    my $companalfileselector=new Gtk::FileSelection(' Comp. Results File Selection');
    $self->{companalfileselector}=$companalfileselector;
    $companalfileselector->ok_button->signal_connect('clicked',sub {$self->companal_file_selected();});
    $companalfileselector->cancel_button->signal_connect('clicked',sub {$self->{companalfileselector}->hide();});

    $hbox=new Gtk::HBox(0);
    $hbox->show();
    $companalvbox->pack_end($hbox,0,0,1);

    my $companaladdbtn=new Gtk::Button('Add Comp. Res.');
    $companaladdbtn->set_sensitive(0);
    $companaladdbtn->signal_connect('clicked',sub { $self->{companalfileselector}->show(); });
    $companaladdbtn->show();
    $hbox->pack_start($companaladdbtn,1,1,1);
    $self->{companaladdbtn}=$companaladdbtn;

    my $companalremovebtn=new Gtk::Button('Remove Comp. Res.');
    $companalremovebtn->set_sensitive(0);
    $companalremovebtn->signal_connect('clicked',sub { $self->remove_companal; });
    $companalremovebtn->show();
    $hbox->pack_end($companalremovebtn,1,1,1);
    $self->{companalremovebtn}=$companalremovebtn;
    

    return $self;
}

sub add_map_from_datasource {
    my $self=shift;

    $self->{filewindow}->show()
	if ($self->{datasourcetype} eq 'Local File');
    $self->{micadowindow}->show()
	if ($self->{datasourcetype} eq 'Micado');
    $self->{emblwindow}->show()
	if ($self->{datasourcetype} eq 'EMBL');
    $self->{genbankwindow}->show()
	if ($self->{datasourcetype} eq 'GenBank');
}

sub add_map {
    my $self=shift;
    my $mapinfo=shift;

    my $maplist=$self->{maplist};

    my $item=new Gtk::ListItem $mapinfo->get_name;
    $item->show();
    $maplist->append_items($item);
    $maplist->select_child($item);

    my $anchorpos=$mapinfo->get_anchor_position();
    $self->{anchorentry}->set_text($anchorpos);
}

sub duplicate_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    $self->{manager}->duplicate_map($mapname);

}


sub revcom_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;


    my $newname=$self->{manager}->revcom_map($mapname);

    $listitem->children->set_text($newname);

    my $anchorpos=$self->{manager}->get_anchor_position('NAME'=>$newname);

    $self->{anchorentry}->set_text($anchorpos);
}


sub remove_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    $self->{manager}->remove_map($mapname);

    $self->{maplist}->unselect_item($listitem);
    $self->{maplist}->remove_items($listitem);
}

sub maplist_selection_changed {
    my $self=shift;

    my $widget=$self->{maplist}->selection();
    if (!defined $widget) {
	$self->{companallist}->set_sensitive(0);
	$self->{mapremovebtn}->set_sensitive(0);
	$self->{mapdupbtn}->set_sensitive(0);
	$self->{maprevcombtn}->set_sensitive(0);
	$self->{anchorentry}->delete_text(0,-1);
	$self->{anchorentry}->set_sensitive(0);
	$self->{focusentry}->delete_text(0,-1);
	$self->{focusentry}->set_sensitive(0);
    } else {
	$self->{mapdupbtn}->set_sensitive(1);
	$self->{maprevcombtn}->set_sensitive(1);
	$self->{companallist}->set_sensitive(1);
	$self->{anchorentry}->set_sensitive(1);
	$self->{focusentry}->set_sensitive(1);
	my $mapname=$widget->children->get;
	my $anchor=$self->{manager}->get_anchor_position('NAME'=>$mapname);
	$self->{anchorentry}->insert_text($anchor,0);
	my @children=$self->{maplist}->children;
	$self->{mapremovebtn}->set_sensitive(1)
	    if ($#children>0);
    }
    $self->refresh_companal_widgets($widget);
}

sub anchor_changed {
    my $self=shift;

    my $mapname=$self->{maplist}->selection->children->get;
    my $newanchor=$self->{anchorentry}->get_text();
    if (!($newanchor =~ /-?\d+/) || $newanchor==0) {
	my $oldanchor=$self->{manager}->get_anchor_position('NAME'=>$mapname);
	$self->{anchorentry}->delete_text(0,-1);
	$self->{anchorentry}->insert_text($oldanchor,0);
    } else {
	$self->{focusentry}->delete_text(0,-1);
	$self->{manager}->set_anchor_position('NAME'=>$mapname,$newanchor);
    }
}

sub focus_changed {
    my $self=shift;

    my $mapname=$self->{maplist}->selection->children->get;
    my $genename=$self->{focusentry}->get_text();

    my $start=$self->{manager}->set_gene_focus('NAME'=>$mapname,$genename);
    if ($start>0) {
	$self->{anchorentry}->delete_text(0,-1);
	$self->{anchorentry}->insert_text($start,0);
    } else {
	$self->{focusentry}->delete_text(0,-1);
    }
}


sub refresh_companal_widgets {
    my $self=shift;
    my $widget=shift;

    my @companalwidgets=$self->{companallist}->children();
    $self->{companallist}->clear_items(0,$#companalwidgets);
    foreach my $companalwidget (@companalwidgets) {
	$companalwidget->destroy();
    }
    if (!defined $widget) {
	$self->{companallist}->set_sensitive(0);
	$self->{companaladdbtn}->set_sensitive(0);
	$self->{companalremovebtn}->set_sensitive(0);
    } else {
	$self->{companallist}->set_sensitive(1);
	$self->{companaladdbtn}->set_sensitive(1);
	my @children=$widget->children;
	if (defined $children[0]) {
	    my @companalnames=$self->{manager}->get_companal_names($children[0]->get);
	    my $lastitem;
	    foreach my $companalname (@companalnames) {
		my $item = new Gtk::ListItem $companalname;
		$item->show();
		$self->{companallist}->append_items($item);
		$lastitem=$item;
	    }
	    $self->{companallist}->select_child($lastitem)
		if (defined $lastitem);
	}
    }
}


sub companallist_selection_changed {
    my $self=shift;

    my $widget=$self->{companallist}->selection();
    if (!defined $widget) {
	$self->{companalremovebtn}->set_sensitive(0);
    } else {
	my @children=$self->{companallist}->children;
	$self->{companalremovebtn}->set_sensitive(1)
	    if ($#children >= 0);
    }
}

sub companal_file_selected {
    my $self=shift;

    my $file=$self->{companalfileselector}->get_filename();

    my $listitem=$self->{maplist}->selection;
    
    my $mapname=$listitem->children->get;    

    $self->{companalfileselector}->hide();
    $self->{manager}->add_companal_from_file($mapname,$file);
}

sub update_comp_anal_list {
    my $self=shift;
    my $mapname=shift;

    my @children=$self->{companallist}->children;
    foreach my $widget (@children) {
	$self->{companallist}->remove($widget);
	$widget->destroy();
    }

    my @companalnames=$self->{manager}->get_companal_names($mapname);
    my $lastitem=undef;
    foreach my $name (@companalnames) {
	my $item=new Gtk::ListItem $name;
	$item->show();
	$self->{companallist}->append_items($item);	
	$lastitem=$item;
    }
    $self->{companallist}->select_child($lastitem)
	if (defined $lastitem);
}

sub remove_companal {
    my $self=shift;

    my $widget=$self->{companallist}->selection();
    my $companalname=$widget->children->get();
    my $mapname=$self->{maplist}->selection->children->get();

    $self->{manager}->remove_companal_result($mapname,$companalname);

    $self->refresh_companal_widgets($self->{maplist}->selection());
}

sub show_all {
    my $self=shift;

    $self->{window}->show_all();

}

1
