package CompAnalResultWidget::BoxPlotWidget;

use strict;

use FeatureWidget;

@CompAnalResultWidget::BoxPlotWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{BOXPLOT}=sub { return new CompAnalResultWidget::BoxPlotWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $type=$companalresult->{type};
    my $widgettype='feature_overlay';
    $widgettype='interlace'
	if ($type eq 'separate');
    my $self = new CompAnalResultWidget($widgettype);

    $self->{companalresult}=$companalresult;
    bless $self,$class;

    return $self;
}

sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;
    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my ($leftbound,$rightbound)=($startbase,$endbase);
    ($leftbound,$rightbound)=($endbase,$startbase)
	if ($startbase>$endbase);
    my $offset=0;
    my $factor=1;
    ($offset,$factor)=(1.0,-1.0)
	if ($startbase>$endbase);

    my $companalresult=$self->{companalresult};

    foreach my $box (@{$companalresult->{boxes}}) {
	my $boxstart=$box->{begin};
	my $boxend=$box->{end};
	if (($boxstart>=$leftbound && $boxstart<=$rightbound) ||
	    ($boxend>=$leftbound && $boxend<=$rightbound) ||
	    ($boxstart<$leftbound && $boxend>$rightbound)) {
	    $boxstart=$leftbound
		if ($boxstart<$leftbound);
	    $boxend=$rightbound
		if ($boxend>$rightbound);
	    my $frame=$box->{frame};
	    $frame=undef
		if ($frame eq 'none');
	    my $strand=$box->{strand};
	    my $amp_factor=0.9;
	    if ($frame eq 'all') {
		$amp_factor=2.7;
		$frame=2;
	    }
	    my $vert_pos=ScalableFeatureWidget::get_vertical_position($strand,$frame);
	    my $vert_amp=$ScalableFeatureWidget::totalthickness;
	    $vert_amp*=$amp_factor
		if (ScalableFeatureWidget::are_frames_visible());	

	    my $start_x=($boxstart-$leftbound)/($rightbound-$leftbound);
	    my $width=($boxend-$boxstart)/($rightbound-$leftbound);
	    
	    my $height=$vert_amp*$box->{thickness};
	    my $y=$vert_pos-$height/2.0;

	    $paintdevice->add_rectangle($x_start+($offset+$factor*$start_x)*$x_scale-$x_scale*$offset*$width,
					$y_start+$y*$y_scale,
					$width*$x_scale,
					$height*$y_scale,
					color=>$box->{color},
					filled=>$box->{filled});
	    if (length($box->{label})) {
		my $label=$box->{label};
		my $halign=$box->{halign};
		my $valign=$box->{valign};
		my $labcolor=$box->{labelcolor};
		my $text_y=$vert_pos;
		if ($valign eq 'above') {
		    $text_y-=$height/2.0;
		    $valign='bottom';
		}
		if ($valign eq 'below') {
		    $text_y+=$height/2.0;
		    $valign='top';
		}
		if ($valign eq 'inside') {
		    $valign='middle';
		}

		my $text_x=$start_x+$width/2;
		$paintdevice->add_text($x_start+($offset+$factor*$text_x)*$x_scale,
				       $y_start+$text_y*$y_scale,
				       $box->{label},
				       color => $labcolor,
				       halign => $halign,
				       valign => $valign,
				       depth => 10);
	    }
	}
    }
}


1
