use strict;


print "Checking for avalaible modules.\n";

my %modules = (
	       'strict' => {type=> 'required'},
	       'Carp' => {type => 'required'},
	       'CORBA::ORBit' => {type => 'optional',
				  functionality => 'EMBL access'},
	       'DBI' => {type => 'optional', 
			 functionality => 'Micado access'},
	       'DBD::Pg' => {type => 'optional',
			     functionality => 'Micado access'},
	       'Error' => {type => 'optional',
			   functionality => 'EMBL access'},
	       'File::Basename' => {type => 'required'},
	       'FindBin' => {type=> 'required'},
	       'GD' => {type => 'required'},
	       'Getopt::Long' => {type=> 'required'},
	       'Gtk' => {type => 'optional',
		     functionality => 'Interactive viewing with mugenv'},
	       'HTTP::Request' => {type => 'optional',
				  functionality => 'EMBL access'},
	       'IO::File' => {type => 'required'},
	       'IO::String' => {type => 'optional',
				functionality => 'Micado access'},
	       'LWP::UserAgent' =>  {type => 'optional',
				  functionality => 'EMBL access'},
	       'Pod::Parser' => {type => 'required'},
	       'Pod::Usage' => {type => 'required'},
	       'XML::Parser::PerlSAX' => {type => 'required'},
	       'XML::Writer' => {type => 'required'},
	       'Bio::DB::GenBank' => {type => 'required'},
	       'Bio::Seq' => {type => 'required'},
	       'Bio::SeqIO' => {type => 'required'},
	       'Bio::SeqFeature::Generic' => {type => 'required'},
	       'Bio::Tools::CodonTable' => {type => 'required'},
	       );

foreach my $module (sort keys %modules) {
    $|=1;
    print "\t$module...";
    
    if ( eval "require $module"  ) {
	print "ok.\n";
    } else {
	print "not found.\n";
	print "Error message : \n\t$@\n";
	if ($modules{$module}->{type} eq 'required') {
	    print "MuGeN WILL NOT WORK AT ALL !\n";
	    exit -1;
	} else {
	    print "\t",$modules{$module}->{functionality}," will not work.\n";
	}
    }
    $|=0;
}

my $DEFAULTPERLPATH="/usr/bin/perl";
my $REALPERLPATH=`which perl`;
chomp($REALPERLPATH);

print "Subsituting path to Perl executable ($REALPERLPATH).\n";

$DEFAULTPERLPATH=~ s/\//\\\//g;
$REALPERLPATH=~ s/\//\\\//g;
my @scripts=qw(mugenb mugenv) ;

foreach my $script (@scripts) {
    $|=1;
    print "\t$script...";
    `perl -i -pe 's/$DEFAULTPERLPATH/$REALPERLPATH/' $script`;
    print "done.\n";
    $|=0;
}

