package ColorHandler::ECColorHandler;

use strict;

use ColorHandler::DefaultColorHandler;
use PaintDevice;

@ColorHandler::ECColorHandler::ISA=qw(ColorHandler::DefaultColorHandler);

%ColorHandler::ECColorHandler::color_scheme=%ColorHandler::DefaultColorHandler::color_scheme;

@ColorHandler::ECColorHandler::ECColors=qw(black red green blue cyan magenta yellow);

BEGIN {
    $ColorHandlerFactory::Factory{'EC number based'}=sub { return new ColorHandler::ECColorHandler @_};

}

sub new {
    my $class=shift;
    my $name=shift;
    $name='EC number based'
	unless defined $name;

    my $self=new ColorHandler::DefaultColorHandler($name);

    bless $self,$class;

    return $self;
}

sub get_colors_for_cds {
    my $self=shift;
    my $feature=shift;

    my $filled=0;
    my $color='black';
    my $has_ec=$feature->has_tag('EC_number');
    if ($has_ec) {
	$filled=1;
	my ($ecnumber,@dummy)=$feature->each_tag_value('EC_number');
	my (@digits)=split /\./,$ecnumber;
	$color=$ColorHandler::ECColorHandler::ECColors[$digits[0]]
	    if (defined $ColorHandler::ECColorHandler::ECColors[$digits[0]]);
    }
    return ($color,$filled);
}

$ColorHandler::ECColorHandler::color_scheme{'cds'}=sub { get_colors_for_cds @_ };

sub get_colors_for {
    my $self=shift;
    my $feature=shift;

    %ColorHandler::color_scheme=%ColorHandler::ECColorHandler::color_scheme;
    
    return $self->ColorHandler::get_colors_for($feature);
}


1
