package ColorHandler::FileColorHandler;

use strict;

use XML::Parser::PerlSAX;

use ColorHandler;

@ColorHandler::FileColorHandler::ISA=qw(ColorHandler);
%ColorHandler::FileColorHandler::FeatureColors=(
			      'default' => { 'leading' => 'black',
					     'leading_filled' => 0,
					     'lagging' => 'black',
					     'lagging_filled' => 0});
BEGIN {
    $ColorHandlerFactory::Factory{'File based'}=sub { return new ColorHandler::FileColorHandler @_};

}

sub new {
    my $class=shift;
    my $name=shift;
    $name='File based'
	unless defined $name;

    my $self=_new ColorHandler($name);

    bless $self,$class;

    return $self;
}

sub start_element {
    my $self=shift;
    my $tag=shift;

    my $attributes=$tag->{Attributes};

    if ($tag->{Name} eq 'color') {
	my $colorname=$attributes->{name};
	my $red=$attributes->{red};
	my $green=$attributes->{green};
	my $blue=$attributes->{blue};
	if (defined $colorname && defined $red && defined $green &&
	    defined $blue) {
	  PaintDevice::color_alloc($colorname,$red,$green,$blue);
	}
    }

    if ($tag->{Name} eq 'feature') {
	my $type=$attributes->{type};
	if (!defined $ColorHandler::FileColorHandler::FeatureColors{$type}) {
	    $ColorHandler::FileColorHandler::FeatureColors{$type}={};
	}
	my $color=$attributes->{color};
	my $filled=$attributes->{filled};
	if (defined $filled) {
	    if (lc $filled eq 'yes' || lc $filled eq 'y') {
		$filled=1;
	    } else {
		$filled=0;
	    }
	}

	my $strand=$attributes->{strand};
	my $qualifier=$attributes->{qualifier};
	my $value=$attributes->{value};

	if (defined $qualifier && defined $value) {
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}={}
	    if (!defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers});
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}={}
	    if (!defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier});
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}->{$value}={color=>$color};
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}->{$value}->{filled}=$filled
		if (defined $filled) ;
	} elsif (!defined $strand) {
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{'leading'}=$color;
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{'lagging'}=$color;
	    if (defined $filled) {
		$ColorHandler::FileColorHandler::FeatureColors{$type}->{'leading_filled'}=$filled;
		$ColorHandler::FileColorHandler::FeatureColors{$type}->{'lagging_filled'}=$filled;
	    }
	} elsif ($strand == -1) {
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{'lagging'}=$color;
	    if (defined $filled) {
		$ColorHandler::FileColorHandler::FeatureColors{$type}->{'lagging_filled'}=$color;
	    }
	} else {
	    $ColorHandler::FileColorHandler::FeatureColors{$type}->{'leading'}=$color;
	    if (defined $filled) {
		$ColorHandler::FileColorHandler::FeatureColors{$type}->{'leading_filled'}=$color;
	    }
	}
    }
}

sub load_colors {
    my $self=shift;
    
    my $file=shift;

    my $parser=new XML::Parser::PerlSAX();

    $parser->parse(Source => {SystemId => $file},
		   Handler => $self);

}

sub get_colors_for {
    my $self=shift;
    my $feature=shift;

    my $type=lc $feature->primary_tag;
    my $strand=$feature->strand;
    my $strandkey='leading';
    $strandkey='lagging'
	if ($strand == -1);

    my $color=$ColorHandler::FileColorHandler::FeatureColors{'default'}->{$strandkey};
    my $filled=$ColorHandler::FileColorHandler::FeatureColors{'default'}->{$strandkey."_filled"};
    
    if (defined $ColorHandler::FileColorHandler::FeatureColors{$type}) {
	$color=$ColorHandler::FileColorHandler::FeatureColors{$type}->{$strandkey}
	if (defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{$strandkey});
	
	$filled=$ColorHandler::FileColorHandler::FeatureColors{$type}->{$strandkey."_filled"}
	if (defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{$strandkey."_filled"});

	if (defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}) {
	    foreach my $qualifier (%{$ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}}) {
		if ($feature->has_tag($qualifier)) {
		    my (@values)=$feature->each_tag_value($qualifier);
		    foreach my $value (%{$ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}}) {
			if ($value eq $values[0]) {
			    $color=$ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}->{$value}->{color};
			    $filled=$ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}->{$value}->{filled}
			    if (defined $ColorHandler::FileColorHandler::FeatureColors{$type}->{qualifiers}->{$qualifier}->{$value}->{filled});
			}
		    }
		}
	    }
	}
    }
    return ($color,$filled);
}

1
