package CompAnalResultWidget;

use strict;

use CompAnalResult;

sub new {
    my $class=shift;
    my $layout=shift;

    my $self={};

    $self->{layout}=$layout;

    bless $self,$class;

    return $self;
}

sub id {
    my $self=shift;
    
    return $self->{companalresult}->{id};
}

sub layout {
    my $self=shift;
    return $self->{layout};
}

package CompAnalResultWidgetFactory;

use strict;

use FindBin;

use lib $FindBin::Bin;

BEGIN {

    my $subdir=$FindBin::Bin;
    %CompAnalResultWidgetFactory::Factory=();
    my @modules=<$subdir/CompAnalResultWidget/*.pm>;

    foreach my $module (@modules) {
	eval {
	    require $module;
	}
    }
}

sub get_widget_instance {
    my $companal_result= shift;
    my $id=uc $companal_result->id;


    return undef
	unless defined $CompAnalResultWidgetFactory::Factory{$id};

    return &{$CompAnalResultWidgetFactory::Factory{$id}}($companal_result);
}

1

