package CompAnalResultWidget::ColorHandlerWidget;

use strict;

@CompAnalResultWidget::ColorHandlerWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{COLORS}=sub { return new CompAnalResultWidget::ColorHandlerWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $self = new CompAnalResultWidget('feature_overlay');

    $self->{companalresult}=$companalresult;
    bless $self,$class;
    
    return $self;
}

sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my $colors=$self->{companalresult}->{colors};
    if (!$self->{companalresult}->{in_sync}) {
	foreach my $name (sort keys %{$colors}) {
	    PaintDevice::color_alloc($name,
				     $colors->{$name}->{red},
				     $colors->{$name}->{green},
				     $colors->{$name}->{blue});
	}
	$self->{companalresult}->{in_sync}=1;
    }

}

1
