package FeatureDataSourceWindow::GenBankWindow;

use strict;

@FeatureDataSourceWindow::GenBankWindow::ISA=qw(Gtk::Dialog);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog;
    $self->set_title('GenBank Retrieval Window');
    $self->{manager}=$manager;

    my $accesshbox=new Gtk::HBox(0);
    $accesshbox->show();
    $self->vbox->pack_start($accesshbox,1,1,1);
    my $accesslabel=new Gtk::Label('Access Number');
    $accesslabel->show();
    $accesshbox->pack_start($accesslabel,1,1,1);
    my $accessentry=new Gtk::Entry;
    $accessentry->show();
    $self->{accessentry}=$accessentry;
    $accesshbox->pack_start($accessentry,1,1,1);


    my $okbtn=new Gtk::Button('OK');
    $okbtn->show();
    $okbtn->signal_connect('clicked',sub {$self->ok_clicked()});
    $self->action_area->pack_start($okbtn,1,1,1);
    my $cancelbtn=new Gtk::Button('Cancel');
    $cancelbtn->show();
    $cancelbtn->signal_connect('clicked',sub {$self->hide()});
    $self->action_area->pack_start($cancelbtn,1,1,1);

    bless $self,$class;

    return $self;
}


sub ok_clicked {
    my $self=shift;
    
    $self->hide();

    my %args=(qualifiers=>1);

    my $accessnumber=$self->{accessentry}->get_text();
    $args{accessnumber}=$accessnumber;

    my $datasource=new FeatureDataSource::GenBankFeatureDataSource(%args);

    $self->{manager}->_add_map_from_datasource($datasource);
}

1
