package Gui::FeatureWindow;

use strict;

sub new {
    my $class=shift;
    my $manager=shift;
    my $self={};

    $self->{manager}=$manager;

    my $window=new Gtk::Window -toplevel;
    $window->set_usize(450,400);
    $window->set_title("Feature Qualifier Window");
    $self->{window}=$window;

    my $vbox=new Gtk::VBox(0,0);
    $vbox->show();
    $window->add($vbox);
    my $scrolledwindow=new Gtk::ScrolledWindow;
    $scrolledwindow->show();
    $vbox->pack_start($scrolledwindow,1,1,0);

    my $annotationtext=new Gtk::Text;
    $annotationtext->show();
    $annotationtext->set_word_wrap(1);
    $annotationtext->set_line_wrap(1);
    $scrolledwindow->add($annotationtext);
    $self->{annotationtext}=$annotationtext;

    bless $self,$class;

    return $self;
}

sub reactive_zone_entered {
    my $self=shift;
    my $feature=shift;

    my $textbuffer="Feature : ".$feature->primary_tag()."\n";
    $textbuffer.="Location : ".$feature->location->to_FTstring()."\n";
    foreach my $tag ($feature->all_tags()) {
	$textbuffer.="\t/$tag = ".join(' ',$feature->each_tag_value($tag))."\n";
    }
    $self->{annotationtext}->freeze();
    my $position=0;
    $self->{annotationtext}->delete_text(0,-1);
    $self->{annotationtext}->insert_text($textbuffer,0);
    $self->{annotationtext}->set_point(0);
    $self->{annotationtext}->thaw();
}


sub show_all {
    my $self=shift;

    $self->{window}->show_all;
}

1
