package PaintDevice;

use strict;

use Carp;

%PaintDevice::colortab=(
			'white' => { colorid => 1,
				     red => 1,
				     green => 1,
				     blue => 1},
			'black' => { colorid => 2,
				     red => 0,
				     green => 0,
				     blue => 0},
			'red' => { colorid => 3,
				   red => 1,
				   green => 0,
				   blue => 0},
			'green' => { colorid => 4,
				     red => 0,
				     green => 1,
				     blue => 0},
			'blue' => { colorid=> 5,
				    red => 0,
				    green => 0,
				    blue => 1},
			'yellow' => { colorid => 6,
				      red => 1,
				      green => 1,
				      blue => 0},
			'cyan' => { colorid => 7,
				    red => 0,
				    green => 1,
				    blue => 1},
			'magenta' => { colorid => 8,
				       red=> 1,
				       green=> 0,
				       blue => 1}
			);

$PaintDevice::colorcounter=8;

%PaintDevice::PAGE_WIDTHS_CM=(
			      'custom' => -1,
			      'a4' => 21,
			      'a3' => 29.7,
			      'a2' => 42,
			      'a1' => 60,
			      'a0' => 84);


%PaintDevice::PAGE_HEIGHTS_CM=(
			       'custom' => -1,
			       'a4' => 29.7,
			       'a3' => 42,
			       'a2' => 60,
			       'a1' => 84,
			       'a0' => 120);


sub color_alloc {
    croak "usage: \$colorid=\$PaintDevice::color_alloc(\$name,\$r,\$g,\$b)"
	if (@_ !=4);

    my $name=shift;
    my ($red,$green,$blue)=@_;

    my $colorid=++$PaintDevice::colorcounter;
    if (defined $PaintDevice::colortab{$name}) {
	$colorid=$PaintDevice::colortab{$name}->{colorid};
	carp "PaintDevice::alloc_color: redefining color $name.";
    }

    $PaintDevice::colortab{$name}->{colorid}=$colorid;
    $PaintDevice::colortab{$name}->{red}=$red;
    $PaintDevice::colortab{$name}->{green}=$green;
    $PaintDevice::colortab{$name}->{blue}=$blue;

    return $colorid;
}

sub color_defined {
    my $name=shift;

    return 1
	if (defined $PaintDevice::colortab{$name});

    return 0;
}

sub _new {
    my $class = shift;
    my $self = {};

    $self->{primitives}=[];

    bless $self,$class;

    return $self;
}

sub width {
    my $self = shift;
    my $width = shift;

    return $self->{width} unless defined $width;

    $self->{width} = $width;
}

sub height {
    my $self = shift;
    my $height = shift;

    return $self->{height} unless defined $height;
    $self->{height}=$height;
}

sub clear {
    my $self = shift;

    $self->{primitives}=[];
}

=item

Method allocating new colors in this paintdevice's color table. All colors are defined in the RGB colorspace by three float values between 0.0 and 1.0 giving the intensity of each color component (red, green and blue).

If a color having the same name already exists in this paintdevice's colormap, its components are replaced with the new components given as arguments.

Usage: $colorid=$paintdevice->color_alloc($name,$r,$g,$b)

Arguments:

=over

=item $name: string representing a symbolic name form the color to be allocated.

=item= $r: float value in [0..1], intensity of the red color channel,

=item= $g: float value in [0..1], intensity of the green color channel,

=item= $b: float value in [0..1], intensity of the blue color channel,

=back

Returns: an identifier for the newly allocated color.

=cut

sub add_line {
    my $self = shift;
    my $x1 = shift;
    my $y1 = shift;
    my $x2 = shift;
    my $y2 = shift;

    my %opts=('color'=>'black',
	      'depth'=>50);
    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }
    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'line',x1=>$x1,y1=>$y1,x2=>$x2,y2=>$y2,
				 color=>$opts{'color'}};
}

sub add_text {
    my $self = shift;
    my $x = shift;
    my $y = shift;
    my $text = shift;

    my %opts=('color'=>'black',
	      'depth'=>50,
	      'halign'=>'left',
	      'valign'=>'top');

    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }
    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'text',x=>$x,y=>$y,text=>$text,
				 color=>$opts{'color'},
				 halign=>$opts{'halign'},
				 valign=>$opts{'valign'}};
}

sub add_circle {
    my $self = shift;
    my $x = shift;
    my $y = shift;
    my $r = shift;

    my %opts=('color'=>'black',
	      'depth'=>50,
	      'filled'=>0);

    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }

    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'circle',x=>$x,y=>$y,radius=>$r,
			     filled=>$opts{'filled'},color=>$opts{'color'}};
}

sub add_rectangle {
    my $self = shift;
    my $x = shift;
    my $y = shift;
    my $width = shift;
    my $height = shift;

    my %opts=('color'=>'black',
	      'depth'=>50,
	      'filled'=>0);

    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }

    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'rectangle',x=>$x,y=>$y,
				 width=>$width,height=>$height,
				 filled=>$opts{'filled'},color=>$opts{'color'}};
}

sub add_polygon {
    my $self=shift;
    my $x=shift;
    my $y=shift;

    my %opts=('color'=>'black',
	      'depth'=>50,
	      'filled'=>0);

    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }
    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'polygon',x=>$x,y=>$y,
				filled=>$opts{'filled'},color=>$opts{'color'}};
}

sub add_polyline {
    my $self=shift;
    my $x=shift;
    my $y=shift;

    my %opts=('color'=>'black',
	      'depth'=>50);

    while (@_) {
	my $key=lc shift;
	if (defined $key) {
	    $opts{lc $key}=shift;
	}
    }
    $self->{primitives}->[$opts{'depth'}]=()
	if (!defined $self->{primitives}->[$opts{'depth'}]);
    push @{$self->{primitives}->[$opts{'depth'}]},{type=>'polyline',x=>$x,y=>$y,color=>$opts{'color'}};
				
}

sub render {
    die "PaintDevice::render called";
}

sub resize {
    my $self = shift;

    $self->{width} = shift;
    $self->{height} = shift;

}

sub text_width {
    die "PaintDevice::text_width called";
}

sub text_height {
    die "PaintDevice::text_height called";
}

1
