package PaintDevice::PSPaintDevice;

use strict;

@PaintDevice::PSPaintDevice::ISA=qw(PaintDevice);

$PaintDevice::PSPaintDevice::CM_PER_INCH = 2.54;
$PaintDevice::PSPaintDevice::MARGIN_INCH = 0.5;
$PaintDevice::PSPaintDevice::POINTS_PER_INCH = 72;
$PaintDevice::PSPaintDevice::POINTS_PER_CM = $PaintDevice::PSPaintDevice::POINTS_PER_INCH/$PaintDevice::PSPaintDevice::CM_PER_INCH;
$PaintDevice::PSPaintDevice::FONT_SIZE = 10;

sub new {
    my $class = shift;
    my $self = _new PaintDevice ;

    $self->{filename} = shift;
    $self->{width} = shift;
    $self->{height} = shift;
    $self->{type}= 'ps';
    $self->{media}= 'custom';
    $PaintDevice::PAGE_WIDTHS_CM{'custom'}=$self->{width};
    $PaintDevice::PAGE_HEIGHTS_CM{'custom'}=$self->{height};
    

    while (my $key=shift) {
	if (my $value=shift) {
	    $self->{$key}=$value;
	}

    }
    bless $self,$class;
    return $self;
}

sub render {
    my $self = shift;

    my $margin_inch=0;
    $margin_inch=$PaintDevice::PSPaintDevice::MARGIN_INCH
	if ($self->{type} eq 'ps');
    my $margin_points=$margin_inch*$PaintDevice::PSPaintDevice::POINTS_PER_INCH;

    my $page_width_inch=$PaintDevice::PAGE_WIDTHS_CM{$self->{media}}/$PaintDevice::PSPaintDevice::CM_PER_INCH;
    my $page_height_inch=$PaintDevice::PAGE_HEIGHTS_CM{$self->{media}}/$PaintDevice::PSPaintDevice::CM_PER_INCH;
    my $dimx_inch=$self->{width}/$PaintDevice::PSPaintDevice::CM_PER_INCH-2*$margin_inch;
    my $dimy_inch=$self->{height}/$PaintDevice::PSPaintDevice::CM_PER_INCH-2*$margin_inch;

    my $pointwidth=$dimx_inch*$PaintDevice::PSPaintDevice::POINTS_PER_INCH;
    my $pointheight=$dimy_inch*$PaintDevice::PSPaintDevice::POINTS_PER_INCH;

    open PSFILE,">$self->{filename}";

    print PSFILE << "EOPSFILE";
%!PS-Adobe-3.0 EPSF-3.0
%%Creator: MuGeN (http://www-mig.versailles.inra.fr/bdsi/MuGeN)
%%Title: $self->{filename}
%%LanguageLevel: 2
%%Pages: (atend)
EOPSFILE

    if ($self->{type} eq 'eps') {
	my $bbllx=0;
	my $bblly=0;
	my $bburx=$pointwidth;
	my $bbury=$pointheight;
	print PSFILE "%%BoundingBox: $bbllx $bblly $bburx $bbury\n";
    } else {
	my $deltay=($page_height_inch-$dimy_inch)*$PaintDevice::PSPaintDevice::POINTS_PER_INCH;
	print PSFILE "$margin_points $deltay $margin_points sub translate\n";
    }

    print PSFILE "%----Color Definitions----\n";
    foreach my $color (keys (%PaintDevice::colortab)) {
	my $red=$PaintDevice::colortab{$color}->{red};
	my $green=$PaintDevice::colortab{$color}->{green};
	my $blue=$PaintDevice::colortab{$color}->{blue};
	print PSFILE "/$color {$red $green $blue setrgbcolor} def\n";
    }

    print PSFILE << "EOPSFILE";
%----Drawing Macros----
/line {newpath moveto lineto closepath stroke} def
/empty_circle {0 360 arc stroke} def
/filled_circle {0 360 arc fill} def
/empty_box {newpath moveto dup 0 exch rlineto exch 0 rlineto neg 0 exch rlineto closepath stroke} def
/filled_box {newpath moveto dup 0 exch rlineto exch 0 rlineto neg 0 exch rlineto closepath fill} def
/left_text {/Courier findfont  $PaintDevice::PSPaintDevice::FONT_SIZE scalefont setfont moveto show } def
/right_text {/Courier findfont $PaintDevice::PSPaintDevice::FONT_SIZE scalefont setfont moveto dup stringwidth pop neg 0 rmoveto show } def
/middle_text {/Courier findfont $PaintDevice::PSPaintDevice::FONT_SIZE scalefont setfont moveto dup stringwidth pop 2 div neg 0 rmoveto show } def
/empty_polygon {
    3 1 roll newpath moveto {lineto} repeat closepath stroke
} def
/filled_polygon {
    3 1 roll newpath moveto {lineto} repeat closepath fill
} def
/polyline {
    3 1 roll newpath moveto {lineto} repeat stroke
} def
%----Feature Drawings----
0.5 setlinewidth
EOPSFILE
    
    if ($self->{type} eq 'ps') {
	print PSFILE "%%Page: 1 1\n";
    }
    for (my $depth=$#{$self->{primitives}};$depth>=0;$depth--) {
	for (my $shapeno=0;$shapeno<=$#{$self->{primitives}->[$depth]};$shapeno++) {
	    my $shape=$self->{primitives}->[$depth]->[$shapeno];
	    print PSFILE "$shape->{color}\n";
	    if ($shape->{type} eq 'text') {
		my $text_x=$shape->{x}*$pointwidth;
		my $text_y=(1.0-$shape->{y})*$pointheight;
		
		$text_y-=$PaintDevice::PSPaintDevice::FONT_SIZE/2
		    if ($shape->{valign} eq 'middle');
		$text_y-=$PaintDevice::PSPaintDevice::FONT_SIZE
		    if ($shape->{valign} eq 'top');
		print PSFILE "($shape->{text}) $text_x $text_y ";
		print PSFILE "left_text\n"
		    if ($shape->{halign} eq 'left') ;
		print PSFILE "right_text\n"
		    if ($shape->{halign} eq 'right');
		print PSFILE "middle_text\n"
		    if ($shape->{halign} eq 'middle'); 
	    }
	    if ($shape->{type} eq 'line') {
		my $x1=$shape->{x1}*$pointwidth;
		my $y1=(1.0-$shape->{y1})*$pointheight;
		my $x2=$shape->{x2}*$pointwidth;
		my $y2=(1.0-$shape->{y2})*$pointheight;
		print PSFILE "$x1 $y1 $x2 $y2 line\n";
	    }
	    if ($shape->{type} eq 'circle') {
		my $x=$shape->{x}*$pointwidth;
		my $y=(1.0-$shape->{y})*$pointheight;
		my $factor=$pointwidth;
		$factor=$pointheight
		    if ($pointheight<$pointwidth);
		my $r=$shape->{radius}*$factor;
		print PSFILE "$x $y $r empty_circle\n" if ($shape->{filled}==0);
		print PSFILE "$x $y $r filled_circle\n" if ($shape->{filled}==1);
	    }
	    if ($shape->{type} eq 'rectangle') {
		my $x=$shape->{x}*$pointwidth;
		my $y=(1.0-$shape->{y})*$pointheight;
		my $w=$shape->{width}*$pointwidth;
		my $h=-$shape->{height}*$pointheight;
		print PSFILE "$w $h $x $y empty_box\n" if ($shape->{filled}==0);
		print PSFILE "$w $h $x $y filled_box\n" if ($shape->{filled}==1);
	    }
	    if ($shape->{type} eq 'polygon') {
		for (my $i=$#{$shape->{x}};$i>=0;$i--) {
		    my $x=$shape->{x}->[$i]*$pointwidth;
		    my $y=(1.0-$shape->{y}->[$i])*$pointheight;
		    print PSFILE "$x $y ";
		}
		print PSFILE "$#{$shape->{x}} ";
		print PSFILE "empty_polygon\n" if ($shape->{filled}==0);
		print PSFILE "filled_polygon\n" if ($shape->{filled}==1);
	    }
	    if ($shape->{type} eq 'polyline') {
		for (my $i=$#{$shape->{x}};$i>=0;$i--) {
		    my $x=$shape->{x}->[$i]*$pointwidth;
		    my $y=(1.0-$shape->{y}->[$i])*$pointheight;
		    print PSFILE "$x $y ";
		}
		print PSFILE "$#{$shape->{x}} ";
		print PSFILE "polyline\n";
	    }
	}    
    }

    print PSFILE "showpage\n";
    
    print PSFILE "%%Pages: 1\n%%EOF\n";
    close(PSFILE);

}

sub text_width {
    my $self=shift;
    my $text=shift;

    return length($text)*0.45*$PaintDevice::PSPaintDevice::FONT_SIZE/$PaintDevice::PSPaintDevice::POINTS_PER_INCH*$PaintDevice::PSPaintDevice::CM_PER_INCH;

}

sub text_height {
 my $self = shift;

 return $PaintDevice::PSPaintDevice::FONT_SIZE/$PaintDevice::PSPaintDevice::POINTS_PER_INCH*$PaintDevice::PSPaintDevice::CM_PER_INCH;
 
}

1
