package ColorHandler::DefaultColorHandler;

use strict;

use ColorHandler;

@ColorHandler::DefaultColorHandler::ISA=qw(ColorHandler);

BEGIN {
    $ColorHandlerFactory::Factory{'Default'}=sub { return new ColorHandler::DefaultColorHandler @_};

}
sub new {
    my $class=shift;
    my $name=shift;
    $name='Default'
	unless defined $name;

    my $self=_new ColorHandler($name);

    bless $self,$class;

    return $self;
}

sub get_colors_for_promoter {
    my $self=shift;
    return ('black',1);
}

sub get_colors_for_terminator {
    my $self=shift;
    return ('red',0);
}

sub get_colors_for_cds {
    my $self=shift;
    my $feature=shift;

    my $filled=0;
    my $has_function=$feature->has_tag('function');
    if ($has_function) {
	my ($function,@dummy)=$feature->each_tag_value('function');
	$function=~s/"//g;   # "  
        $function=~tr/a-z/A-Z/; 
	$filled=1 
	    if ($function !~ /UNKNOWN/); 
    }
    $filled=1 
	if $feature->has_tag('product');

    my $color='cyan';
    $color='magenta'
	if ($feature->strand() == -1);
    return ($color,$filled);
}

sub get_colors_for_misc_rna {
    my $self=shift;
    my $feature=shift;

    return ('green',1);
}

sub get_colors_for_trna {
    my $self=shift;
    my $feature=shift;

    return ('blue',1);

}

sub get_colors_for_rrna {
    my $self=shift;
    my $feature=shift;

    return ('red',1);
}

sub get_colors_for_rbs {
    my $self=shift;
    my $feature=shift;

    return ('green',1);
}

%ColorHandler::DefaultColorHandler::color_scheme = (
                 'promoter' => sub { get_colors_for_promoter @_ },
		 'terminator' => sub { get_colors_for_terminator @_ },
		 'cds' => sub { get_colors_for_cds @_ },
		 'misc_rna' => sub { get_colors_for_misc_rna @_ },
		 'trna' => sub { get_colors_for_trna @_ },
		 'rrna' => sub { get_colors_for_rrna @_ },
		 'rbs' => sub { get_colors_for_rbs @_});


sub get_colors_for {
    my $self=shift;
    my $feature=shift;

    %ColorHandler::color_scheme=%ColorHandler::DefaultColorHandler::color_scheme;
    
    return $self->ColorHandler::get_colors_for($feature);
}

1
